/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _PARSE_OBJECT_H__
#define _PARSE_OBJECT_H__

/* Allows HTML body searches to span packets */
typedef struct html_parse_state 
{
  unsigned int state;
  int match_indx;
  char *tmpp;
} html_parse_state_t;

#define HTML_P_NOT_STARTED 0x0
#define HTML_P_GOT_ELEMENT 0x1

#define HTML_P_IN_MATCH_IMG 0x2
#define HTML_P_GOT_MATCH_IMG 0x4
#define HTML_P_IN_IMG_SRC 0x8
#define HTML_P_IN_IMG_SUNDRYCHARS 0x10
#define HTML_P_IN_IMG_URL 0x20

#define HTML_P_IN_CLEAR_ANCHOR 0x40
#define HTML_P_IN_MATCH_HREF 0x80
#define HTML_P_IN_HREF_SUNDRYCHARS 0x100
#define HTML_P_IN_HREF_URL 0x200

#define HTML_P_IN_MATCH_BASE 0x400
#define HTML_P_IN_BASE_SUNDRYCHARS 0x800
#define HTML_P_IN_BASE_URL 0x1000

#define HTML_P_IN_MATCH_LINK 0x2000
#define HTML_P_IN_MATCH_LINK_HREF 0x4000
#define HTML_P_IN_LINK_SUNDRYCHARS 0x8000
#define HTML_P_IN_LINK_URL 0x10000

#define HTML_P_NEED_IMG_TIMESTAMP 0x40000000
#define HTML_P_NEED_URL_TIMESTAMP 0x80000000

#define HTML_PARSE_STATE tconnp->su.http.reptrans->inner.html_p_state.state
#define HTML_PARSE_STATE_MATCH_INDX tconnp->su.http.reptrans->inner.html_p_state.match_indx
#define HTML_PARSE_STATE_TMPP tconnp->su.http.reptrans->inner.html_p_state.tmpp 

/* Apart from top nibble (time stamp state)  states are exclusive */
#define SET_HTML_PARSE_STATE(state) \
MACRO_BEGIN                   \
  unsigned int *statep = & HTML_PARSE_STATE;  \
  *statep &= ~0xfffffff;      \
  *statep |= (state);  \
MACRO_END


struct tcp_conn; /* forward */


/*
 * Parse_object.c 
 */

int chain_new_imgcharbuf(struct tcp_conn *tconnp);
int chain_new_link_urls_buf(struct tcp_conn *tconnp);
char *find_img_src_end(char *s, int len);
char *find_href_end(char *s, int len);
char *find_linkref_end(char *s, int len);
int parse_rep_body(prec_t *pp, struct tcp_conn *tconnp, int len, short code);

#endif /* _PARSE_OBJECT_H__ */


/*
 * end parse_object.h 
 */
