/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _INTERFACE_H_
#define  _INTERFACE_H_

#ifdef __alpha__
#include <net/bpf.h>

#define LINK_ETH_10MB DLT_EN10MB
#define LINK_FDDI     DLT_FDDI
#define FDDI_HDR_LEN  sizeof(struct fddi_header)

#endif

#ifdef __linux__

#define LINK_ETH_10MB 1
#define LINK_FDDI     10
/* linux doesn't know how large an fddi header is */
#define FDDI_HDR_LEN  (sizeof(struct fddi_header)+3)

#endif

#define LINK_NPROBE DLT_NPROBE
#define LINK_NPROBE_LZO DLT_NPROBE_LZO

/* Not in net/bpf.h */
#define DLT_RAW_HIGH 101
#define LINK_RAW_HIGH DLT_RAW_HIGH

#ifdef PROBE_FED

// XXXX this is slightly hacky - sort out later

#include "config.h"

#ifdef ATM
#define IS_ETHER_MIN_FRAME(pp) 0
#define IS_FDDI_MIN_FRAME(pp)  0
#endif

#ifdef ETHERNET
#define IS_ETHER_MIN_FRAME(pp) \
         ((pp)->wirelen == ETHERMIN + sizeof(struct ether_header))
#define IS_FDDI_MIN_FRAME(pp)  0
#endif



#else /* not PROBE_FED */

#define IS_ETHER_MIN_FRAME(pp) ((pp)->link_type == LINK_ETH_10MB \
	       && (pp)->wirelen == ETHERMIN + sizeof(struct ether_header))

#define IS_FDDI_MIN_FRAME(pp) ((pp)->link_type == LINK_FDDI \
	       && (pp)->wirelen == ETHERMIN + FDDI_HDR_LEN \
			   + sizeof(struct llc))

#endif

#ifdef TCPDUMP_FED
void get_linkstripper(link_data_t *ld);

int strip_eth10_encaps(prec_t *pp);
int strip_fddi_encaps(prec_t *pp);
int strip_nprobe_encaps(prec_t *pp);
int strip_raw_encaps(prec_t *pp);
int strip_constant_offset(prec_t *pp);
#endif /* #ifdef TCPDUMP_FED */

#endif /* _INTERFACE_H_ */

/*
 * end interface.h 
 */
