/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _IF_STATS_H_
#define _IF_STATS_H_

/*
 * Stuff for recording any dropped packets from /proc/net 
 */

#ifdef PROBE_FED

#ifndef IFNAMSIZ
#define	IFNAMSIZ	16
#endif

#define _PATH_PROCNET_DEV		"/proc/net/dev"

struct net_device_stats 
{
  char if_name[IFNAMSIZ];
  struct timeval ts;
  unsigned long long rx_packets;	/* total packets received       */
  unsigned long long rx_bytes;	/* total bytes received         */
  unsigned int rx_errors;	/* bad packets received         */
  unsigned int rx_dropped;	/* no space in linux buffers    */
  unsigned int rx_multicast;	/* multicast packets received   */
  unsigned int rx_compressed;
  
  /* detailed rx_errors: */
  unsigned int rx_length;
  unsigned int rx_over;	/* receiver ring buff overflow  */
  unsigned int rx_crc;	/* recved pkt with crc error    */
  unsigned int rx_frame;	/* recv'd frame alignment error */
  unsigned int rx_fifo;	/* recv'r fifo overrun          */
  unsigned int rx_missed;	/* receiver missed packet     */
};

typedef struct net_device_stats net_device_stats_t;

/*
 * if_stats.c
 */
int lookat_if(int chan, struct timeval *tvp);


#endif /* probe fed */





#endif /* _IF_STATS_H_ */

/******************************************************************************
 * end if_stats.h
 */
