/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _IF_NPROBE_H_
#define _IF_NPROBE_H_

/* used by libpcap */
#ifdef ZFLAGX
#define unsigned short unsigned short
#define unsigned int unsigned int
#endif


#define DLT_NPROBE 12321

/*****************************************************************************/

/*
 * Packet dump flags (excluding per-service pkt dumps controlled by control  
 * blocks
 */

#define DUMP_NO_PKTS 0x0
#define DUMP_TCP_PKTS 0x1
#define DUMP_UDP_PKTS 0x2
#define DUMP_ICMP_PKTS 0x4
#define DUMP_IP_PKTS (DUMP_TCP_PKTS | DUMP_UDP_PKTS | DUMP_ICMP_PKTS)
#define DUMP_NON_IP_PKTS 0x8
#define DUMP_ALL_PKTS (DUMP_IP_PKTS | DUMP_NON_IP_PKTS)

/*****************************************************************************/

/*
 * Structures mimicking MAC header for if_nprobe dumped packets
 */

#ifndef ETH_HLEN
#define ETH_HLEN 14
#define ETH_ALEN  6
#endif

/*
 * Struct np_hdr MUST NOT exceed 14 bytes length
 */
#define NP_HDR_DATA_SZ (14 -(sizeof(char) + sizeof(unsigned short) + sizeof(unsigned int)))

struct np_hdr 
{
  unsigned int atmdata;		/* NBO */
  unsigned char code;
  char data[NP_HDR_DATA_SZ];
  unsigned short etype;			/* NBO */
} __attribute__ ((packed));

typedef struct np_hdr np_hdr_t;
  
  
typedef struct nprobe_hdr
{
  union 
    {
      char dummy[ETH_HLEN];	/* s/be struct ether_hdr */
      np_hdr_t nh;
    } u;
} nprobe_hdr_t;


/*****************************************************************************/



struct prec; //forward

void dump_pkt(struct prec *pp, int why, char *data, unsigned int atmdata);

void dump_ethpkt(struct prec *pp, int why, char *data, unsigned int atmdata);


#endif /* _IF_NPROBE_H_ */

/*
 * end if_nprobe.h 
 */
