/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _CPRINTF_H_
#define _CPRINTF_H_


#ifdef CPRINTF

#define cprintf(buf, col, fmt, args...) printf("%s"fmt"%s%s", col, ##args, \
                                                 csf_def, csb_def)
#define csprintf(buf, col, fmt, args...) printf("%s"fmt"%s%s", col, ##args, \
                                                 csf_def, csb_def)
#define cfprintf(file, col, fmt, args...) fprintf(file, "%s"fmt"%s%s", col, \
                                                 ##args, csf_def, csb_def)
#else

#define cprintf(buf, col, fmt, args...) printf(fmt, ##args)
#define csprintf(buf, col, fmt, args...) printf(fmt, ##args)
#define cfprintf(file, col, fmt, args...) fprintf(file, fmt, ##args)

#endif


extern int cprintf_restore_defaults();

#define F_BLACK csf_bl
#define F_RED csf_r
#define F_GREEN csf_g
#define F_YELLOW csf_y
#define F_BLUE csf_b
#define F_MAGENTA csf_m
#define F_CYAN csf_c
#define F_WHITE csf_w
#define F_DEF csf_def
#define F_NORM csf_norm

#define UNDER_LINED csf_under
#define F_BOLD csf_bld
#define UP_LINE printf("%s", c_up);
#define FUP_LINE(file) fprintf(file, "%s", c_up);
#define OVERPRINT printf("%s%s", c_home, clear_r)

#define B_BLACK csb_bl
#define B_RED csb_r
#define B_GREEN csb_g
#define B_YELLOW csb_y
#define B_BLUE csb_b
#define B_MAGENTA csb_m
#define B_CYAN csb_c
#define B_WHITE csb_w
#define B_DEF csb_def
#define B_NORM csb_norm

extern char csf_bl[], csf_r[], csf_g[], csf_y[], csf_b[], csf_m[], csf_c[], csf_w[];
extern char csf_norm[], csf_def[];
extern char csf_under[], csf_bld[];
extern char c_up[], c_home[], clear_r[];
extern char csb_bl[], csb_r[], csb_g[], csb_y[], csb_b[], csb_m[], csb_c[], csb_w[];
extern char csb_norm[], csb_def[];


#endif /* _CPRINTF_H_ */
