/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stdio.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "interface.h"
#include "flows.h"
#include "http.h"
#include "tcp.h"
#include "udp.h"
#include "udp_ns.h"
#include "timeouts.h"
#include "seq.h"
#include "counters.h"
#include "writer.h"
#include "if_nprobe.h"

#ifdef PRINT_OUT
#include "print_util.h"
#endif

#include "output.h"
#include "pool.h"

#define TELL_SZ(obj)  \
MACRO_BEGIN    \
  printf("\t%18s %6d\n", #obj, sizeof(obj)); \
MACRO_END

#define USE_SZ(obj, n)  \
MACRO_BEGIN    \
  int used = n*sizeof(obj); \
  printf("\t%18s *%8d =%10d\n", #obj, n, used); \
  tot_use += used; \
MACRO_END

#define TELL_OFFSET(cont, field, what)  \
MACRO_BEGIN    \
  printf("%10s %6d at %5d\n", #field, sizeof(what), (char *)&cont.field - (char *)&cont); \
MACRO_END

#define FILL(cont)  \
MACRO_BEGIN    \
  int i;  \
  int sz = sizeof(cont);  \
  char *tgt = (char *)&cont;  \
  for (i = 0; i < sz; i++)  \
    tgt[i] = (char)(i & 0xff);  \
MACRO_END

int 
main()
{
  counters_t ct;
  flow_inner_t ft;
  tcp_simplex_flow_t tsf;
  ns_rec_t nsr;

  FILL(tsf);

  return;
  
}

