/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _ARR_HIS_H_
#define _ARR_HIS_H_ 

#include "sampleHistogram.h"
#include "sampleStatistic.h"

/*
 * Which histograms to construct
 */

#define HIS_NONE 0x0
#define HIS_GET 0x1
#define HIS_FETCH 0x2
#define HIS_HOSTWALK 0x4
#define HIS_PORTWALK 0x8
#define HIS_PKTS 0x10



/*
 * arr_hist.c 
 */

extern sampleHistogram *get_his, *fetch_his, *pkts_his, *hw_his, *pw_his;

void arr_hist_init(void);
void  get_hist(void);
unsigned int fetch_hist(void);
void arr_hist_end(void); 




#endif  /* _ARR_HIS_H_ */

/*
 * End arr_his.h
 */
