#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
##
## 
## 
##
## 

############################################################################

from string import * 

############################################################################ 

sizes = [512, 1024, 1460, 2048, 4096, 8192, 16384]
speeds = [10, 100, 155, 1000]

MAC_HDR_SZ = 12
IP_HDR_SZ = 20
TCP_HDR_SZ = 20

ENCPS_OHD = MAC_HDR_SZ + IP_HDR_SZ + TCP_HDR_SZ


print 'TCP Packet serialisation times (inclusive of MAC/IP/TCP headers)'
print
print

print '%s%s' % (center('Payload bytes', 15), center('Serialisation delay ms for Bandwidth', 60))
print 
print '%s' % (center('', 15)),
for bw in speeds:
    print '%s' % (center('%dMbs' % (bw), 10)),

print
print

for s in sizes:
    print '%s' % (center('%6d' % (s), 15)),
    bits = (s+ENCPS_OHD)*8
    for bw in speeds:
	t = bits/(bw*1000.0) #ms
	print '%s' % (center('%6.3f' % (t), 10)),
    print
