/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _TCP_SERV_H_
#define _TCP_SERV_H_

/*
 * tcp_common connection types (0-255)
 */

#define TCP_SERV_HTTP 1
#define TCP_SERV_FTP_DATA 2
#define TCP_SERV_FTP 3
#define TCP_SERV_TELNET 4
#define TCP_SERV_SMTP 5
#define TCP_SERV_POP3 6
#define TCP_SERV_NNTP 7
#define TCP_SERV_NETBIOS_SSN 8
#define TCP_SERV_RTSP 9
#define TCP_SERV_PNM 10
#define TCP_SERV_BGP 11
#define TCP_SERV_TEST 254
#define TCP_SERV_OTHER 255


/*
 * udp_common connection types (0-255)
 */

#define UDP_SERV_NFS 1
#define UDP_SERV_DNS 2
#define UDP_SERV_ICQ 3

#define UDP_SERV_OTHER 255

#ifndef SWIG

/*
 * forward
 */

struct tcp_conn; 
struct tcp_heldpkt;
struct tcp_simplex_flow;

struct udp_conn; 



/*
 * Suite of service specific methods for dealing with packet content
 */

struct tcp_serv_methods
{
  void (*serv_open)(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
  int (*serv_pkt)(prec_t *pp, struct tcp_conn *tconnp, int way);
  int (*serv_sync)(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, struct tcp_simplex_flow *tsp, unsigned int gap, int way, unsigned int tm);
  void (*serv_close)(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
  void (*serv_dump)(struct tcp_conn *tconnp);
};

typedef struct tcp_serv_methods tcp_serv_methods_t;

#define TCP_SERV_OPEN(pp, tconnp, way, flags) \
  (tconnp)->serv_control->methu.tmeth.serv_open((pp), (tconnp), (way), (flags))
#define TCP_SERV_PKT(pp, tconnp, way) \
  (tconnp)->serv_control->methu.tmeth.serv_pkt((pp), (tconnp), (way))
#define TCP_SERV_SYNC(hpp, tconnp, tsp, gap, way, tm) \
  (tconnp)->serv_control->methu.tmeth.serv_sync((hpp), (tconnp), (tsp), (gap), (way), (tm))
#define TCP_SERV_CLOSE(pp, tconnp, way, flags) \
  (tconnp)->serv_control->methu.tmeth.serv_close((pp), (tconnp), (way), (flags))
#define TCP_SERV_DUMP(tconnp) \
  (tconnp)->serv_control->methu.tmeth.serv_dump((tconnp))

struct udp_serv_methods
{
  void (*serv_open)(prec_t *pp, struct udp_conn *uconnp, int way);
  int (*serv_pkt)(prec_t *pp, struct udp_conn *uconnp, int way, unsigned int tm);
  void (*serv_close)(prec_t *pp, struct udp_conn *uconnp, int way);
  void (*serv_dump)(struct udp_conn *uconnp);
};

typedef struct udp_serv_methods udp_serv_methods_t; 

#define UDP_SERV_OPEN(pp, uconnp, way) \
  (uconnp)->serv_control->methu.umeth.serv_open((pp), (uconnp), (way))
#define UDP_SERV_PKT(pp, uconnp, way, tm) \
  (uconnp)->serv_control->methu.umeth.serv_pkt((pp), (uconnp), (way), (tm))
#define UDP_SERV_CLOSE(pp, uconnp, way) \
  (uconnp)->serv_control->methu.umeth.serv_close((pp), (uconnp), (way))
#define UDP_SERV_DUMP(uconnp) \
  (uconnp)->serv_control->methu.umeth.serv_dump((uconnp))


/* Transport type */
#define TRANS_TCP 0x1
#define TRANS_UDP 0x2

/* Values for control flags */

#define NO_DUMP 0x0
#define DUMP_OPEN 0x1
#define DUMP_HDRS 0x2
#define DUMP_PKTS 0x4
#define DUMP_PAYLOAD 0x8


struct serv_control
{
  union
  {
    void *methp;
    tcp_serv_methods_t tmeth;
    udp_serv_methods_t umeth;
  } methu;
  struct
  {
    /* record types for dump */
    unsigned int open : 8;
    unsigned int hdrs : 8;
    unsigned int close : 8;
    /* the actual service type */
    unsigned int serv_type : 8;
  } rectypes;
  ctr_t *serv_ctr;
  unsigned int cflags;
};

typedef struct serv_control serv_control_t;

struct serv_entry 
{
  listhdr_t hlist;
  serv_control_t *control;
  unsigned short port;
  unsigned char trans;
};
typedef struct serv_entry serv_entry_t;

extern listhdr_t *serv_hashtbl;
#define N_SERVICE_BUCKETS 1024
listhdr_t *service_hashtbl_initialise();

void reg_serv(unsigned short port, unsigned char trans, serv_control_t *tmpl, int dump_set, int dump_clear);

int get_serv(unsigned short sport, unsigned short dport, unsigned char trans, serv_control_t **sp);
void services_init();

void service_reg(void);

#endif /* ifndef SWIG */

#endif /* _TCP_SERV_H_ */

/* 
 * end tcp_serv.h 
 */
