/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _NP_FILE_H_
#define _NP_FILE_H_

/*****************************************************************************/


struct np_file 
{
  FILE *file;
  char fnm[PATH_MAX];
  counters_t counters;		
  /* array of offsets to records - used if indexing */
  int *offsets;
  int indx;			/* index of next record expected*/
  int curr_offset;		/* offset of current record  */
  int curr_len;         	/* length of current record */
  int patches;
};

#define MAX_REC_PATCHES 10	/* per file */

/*****************************************************************************/

/* 
 * Report file record types 
 *  
 *  - any 0
 *  - TCP 3 - 99
 *  - UDP 101 - 199
 *  - ICMP 201 - 209
 *  - housekeeping/other 211 - 254
 *
 * - for tcp service type records top 6 bits give service
 *   bottom two bits: 0x0 = (close) record
 *                    0x1 = open record
 *                    0x2 = pkt hdrs
 *                    0x3 = comp pkt hdrs
 */

#define OPEN_BIT 0x1
#define HDRS_BIT 0x2

#define REC_ALL 0
#define REC_IP 1

#define REC_TCP_MIN 2
#define REC_TCP_ALL 4 /* REC_TCP_MIN */

#define REC_TCP_TEST 8
#define REC_TCP_TEST_OPEN (REC_TCP_TEST | OPEN_BIT)
#define REC_TCP_TEST_HDRS (REC_TCP_TEST | HDRS_BIT)
#define REC_TCP_HTTP 12
#define REC_TCP_HTTP_OPEN (REC_TCP_HTTP | OPEN_BIT)
#define REC_TCP_HTTP_HDRS (REC_TCP_HTTP | HDRS_BIT)
#define REC_TCP_FTP 16
#define REC_TCP_FTP_OPEN (REC_TCP_FTP | OPEN_BIT)
#define REC_TCP_FTP_HDRS (REC_TCP_FTP | HDRS_BIT)
#define REC_TCP_FTP_DATA 20
#define REC_TCP_FTP_DATA_OPEN (REC_TCP_FTP_DATA | OPEN_BIT)
#define REC_TCP_FTP_DATA_HDRS (REC_TCP_FTP_DATA | HDRS_BIT)
#define REC_TCP_RTSP 24
#define REC_TCP_RTSP_OPEN (REC_TCP_RTSP | OPEN_BIT)
#define REC_TCP_RTSP_HDRS (REC_TCP_RTSP | HDRS_BIT)
#define REC_TCP_PNM 28
#define REC_TCP_PNM_OPEN (REC_TCP_PNM | OPEN_BIT)
#define REC_TCP_PNM_HDRS (REC_TCP_PNM | HDRS_BIT)
#define REC_TCP_BGP 32
#define REC_TCP_BGP_OPEN (REC_TCP_BGP | OPEN_BIT)
#define REC_TCP_BGP_HDRS (REC_TCP_BGP | HDRS_BIT) 
#define REC_TCP_OTHER 96
#define REC_TCP_OTHER_OPEN (REC_TCP_OTHER | OPEN_BIT)
#define REC_TCP_OTHER_HDRS (REC_TCP_OTHER | HDRS_BIT)

#define REC_TCP_MAX 100

#define REC_UDP_MIN 100 /* REC_TCP_MAX */
#define REC_UDP_ALL 100 /* REC_UDP_MIN */

#define REC_UDP_NFS 110
#define REC_UDP_DNS 111
#define REC_UDP_ICQ 112
#define REC_UDP_OTHER 199

#define REC_UDP_MAX 200

#define REC_ICMP_MIN 200	/* REC_UDP_MAX */
#define REC_ICMP_ALL 200
#define REC_ICMP_UNREACH 201
#define REC_ICMP_MAX 210

#define REC_OTHER_MIN 210 /* REC_ICMP_MAX */
#define REC_OTHER_ALL 210 /* REC_OTHER_MIN */

#define REC_INFORM 244
#define REC_NIC_FAIL 245
#define REC_OTHER_PROCSTAT 246
#define REC_OTHER_WRAPPER 247
#define REC_WIRE_PERIOD_REPORT 248
#define REC_RUSAGE 249
#define REC_INTERESTING 250
#define REC_PERIOD_REPORT 251
#define REC_BUF_ALLOC_FAIL 252
#define REC_OTHER_OTHER 253

#define REC_OTHER_MAX 254
#define REC_COUNTERS 255

#define REC_MAX 255

/*****************************************************************************/


#ifdef SWIG

#define ERROR(msg)        \
MACRO_BEGIN               \
  throw(msg);             \
  return 0;               \
MACRO_END

#else  /* SWIG */

#define ERROR(msg) wr_error(msg)

#endif /* SWIG */

/*****************************************************************************/

#endif /* ifndef _NP_FILE_H_ */


