/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _HTTP_ERRDEFS_H_
#define  _HTTP_ERRDEFS_H_


#define N_HTTP_ERRS 206

/*
 * Some error codes 
 */

#define HTTP_ERR_NONE 0 

/* Client 1 - 50 */
#define HTTP_CLI_ERR_TRUNCHDR -1
#define HTTP_CLI_ERR_REQHDR_NOMETHOD -2
#define HTTP_CLI_ERR_MULTREQ -3
#define HTTP_CLI_ERR_REQHDR_PARSE -4
#define HTTP_CLI_ERR_VERS -5
#define HTTP_CLI_ERR_LEN -6
#define HTTP_CLI_ERR_UBL -7
#define HTTP_CLI_ERR_BODY_TOO_LONG -8
#define HTTP_CLI_ERR_NO_HDRDELIM -9
#define HTTP_CLI_ERR_NO_POST_BODYLEN -10
#define HTTP_CLI_ERR_PERSISTANCE -11
#define HTTP_CLI_ERR_HDRCOP -12
#define HTTP_CLI_ERR_HDRBUF -13
#define HTTP_CLI_ERR_CHUNK -14
#define HTTP_CLI_ERR_CHUNKLEN -15
#define HTTP_CLI_ERR_TRANS_EXC -16
#define HTTP_CLI_ERR_EXBYTES -17
#define HTTP_CLI_SERVER_ACTIVE -18 /* server has already opened  HTTP connection */ 
#define HTTP_CLI_SERVER_TRANS_ACTIVE -19
#define HTTP_CLI_ILLICIT_BODY -20


/* Server 51 - 100 */
#define HTTP_SERV_ERR_TRUNCHDR -51
#define HTTP_SERV_ERR_MULTREP -52
#define HTTP_SERV_ERR_REPHDR_PARSE -53
#define HTTP_SERV_ERR_SCODE -54
#define HTTP_SERV_ERR_VERS -55
#define HTTP_SERV_ERR_LEN -56
#define HTTP_SERV_ERR_UBL -57
#define HTTP_SERV_ERR_BODY_TOO_LONG -58
#define HTTP_SERV_ERR_NO_HDRDELIM -59
#define HTTP_SERV_ERR_PERSISTANCE -60
#define HTTP_SERV_ERR_HDRCOP -61
#define HTTP_SERV_ERR_HDRBUF -62
#define HTTP_SERV_ERR_CHUNK -63
#define HTTP_SERV_ERR_CHUNKLEN -64
#define HTTP_SERV_ERR_TRANS_EXC -65
#define HTTP_SERV_ERR_SERVER_OP -66 /* server is opening HTTP connection */
#define HTTP_SERV_ERR_EXBYTES -67

#define HTML_ERR_PARSE -90
#define HTML_ERR_RUNAWAY_URL -91
#define HTML_LINKS_BUFS_EXHUSTED -92 /* doesn't show as an error */
#define HTML_TAG_BUF_EXHUSTED -93



/* Other 101 - 150 */
#define HTML_ERR_NO_IMGSRC -101
#define HTTP_ERR_PERSISTANCE -102
#define IP_ERR_HDRCHKSUM -103
#define TCP_ERR_CHKSUM -104
#define TCP_ERR_SERV_CONNERR -105
#define TCP_ERR_CLI_CONNERR -106
#define TCP_ERR_BAD_OPTLEN -107
#define TCP_ERR_BAD_OPTFLAGS -108

#define PKT_ERR_LEN -120

#define HTTP_ERR_NS_DECODE -140

/* Client assertions 151 - 175 */
#define HTTP_CLI_ASSERT_FAIL_REFSTRNULL -151
#define HTTP_CLI_ASSERT_FAIL_REFSTRLEN -152

/* Server assertions 176 - 200 */
#define HTTP_SERV_ASSERT_FAIL_LINKSURL_COPLEN -176
#define HTTP_SERV_ASSERT_FAIL_INLINESURL_COPLEN -177
#define HTTP_SERV_ASSERT_FAIL_SCRIPTSURL_COPLEN -178

/* Interesting things to dump (not really errors) 201 - 255 */
#define TCP_TESTPKT -202
#define INTERESTING_RTSP_PKT -203
#define INTERESTING_PNM_PKT -204
#define INTERESTING_DNS_PKT -205




/*
 * errstring.c 
 */
char *http_err_string(int err);
void print_http_err_data(int err, char *data);


#endif /*  _HTTP_ERRDEFS_H_ */

/* 
 * end http_errdefs.h 
 */
