/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef BASIC_DEFS_H
#define BASIC_DEFS_H

#define DEBUG

#include "vers.h"

#ifdef __ia64__

typedef long ll_t;
typedef unsigned long ull_t;

#endif

#ifdef __i386__

typedef long long ll_t;
typedef unsigned long long ull_t;

#endif


#ifndef SWIG_ONLY

typedef ull_t ulonglong;

#else

struct ulonglong 
{
  unsigned int low;
  unsigned int high;
}; 

typedef struct ulonglong ulonglong;

struct ulong_int
{
  int half;
  int odd;
};

#endif /* SWIG_ONLY */


#ifndef SWIG 

#ifndef MACRO_BEGIN

#define MACRO_BEGIN do {
#define MACRO_END } while (0)

#endif /* ifndef MACRO_BEGIN */

#define NTOHL(x) x = ntohl(x)

#endif /* ifndef SWIG */


/*
 * Stuff for maintaining a us clock - driven by incoming packets 
 * (struct timeval in sk_buff)
 */

#define US_IN_MS 1000
#define US_IN_S  1000000
#define US_IN_S_LL  1000000LL

#ifndef SWIG_ONLY
typedef ll_t us_clock_t;
#else
struct us_clock 
{
  unsigned int us_low;
  unsigned int us_high;
};
typedef struct us_clock us_clock_t;
#endif

#define TV_TO_US(tv, us)   \
MACRO_BEGIN                \
  (us) = (tv).tv_sec*US_IN_S_LL + (tv).tv_usec; \
MACRO_END

/*
 * Analogue of a struct timeval for python use
 */

#ifdef SWIG_ONLY

struct tval 
{
  int tv_sec;
  int tv_usec;
};

#endif

#ifdef __ia64__

struct tmval
{
  int tv_sec;
  int tv_usec;
};
typedef struct tmval tmval;

#else

typedef struct timeval tmval;

#endif
  

#define SERVER 0x1
#define CLIENT 0x2


#endif /*  BASIC_DEFS_H */
