#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
##
## Date and time of epoch seconds 
##
## 
############################################################################ 

import string
import os
import sys
from sys import argv
import getopt

from time import asctime, gmtime

from traceback import print_stack
############################################################################

def usage(n):

    print 'usage: %s <some string containing epoch time in seconds>' % (n)
    sys.exit(1)


############################################################################ 

scriptname = os.path.basename(argv[0])

try:
    optlist, args = getopt.getopt(sys.argv[1:], '')
    
except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    
for opt in optlist:
    if opt[0] == "-h":
        help(scriptname)

if not len(args):
   usage(scriptname) 

s = args[0]
l = len(s)
start = 0
end = l
done = 0

while not done:
    end = l
    while not done:
        #print s[start:end]
        try:
            t = int(s[start:end])
            #print t
            print '%s is %s' % (s[start:end], asctime(gmtime(t)))
            done = 1
        except ValueError:
            pass
        end = end-1
        if start >= end:
            break
    start = start+1
    end = l
    if start >= end:
        break

if not done:
    print 'Couldn\'t find time in \'%s\'' % (s)
