#!/usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from commands import getstatusoutput

def main():

    base = '131.111.8.'

    for i in range(256):
        dotaddr = base + '%d' % (i)
        #print dotaddr
        cmd = 'host ' + dotaddr

        status, output = getstatusoutput(cmd)

        if status:
            print 'Failed %s with output %s' % (cmd, output)
            break

        else:
            if output.find('not found') >= 1:
                continue
            print output.replace('.in-addr.arpa.', ' is').replace('domain name pointer', '')
        
    return


if __name__ == "__main__":
    main()
