#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from sys import argv
import getopt
import os
import sys


scriptname = os.path.basename(argv[0])

try:
    optlist, args = getopt.getopt(sys.argv[1:], '')

except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    sys.exit(1)


servd = {}
nclients = 0
npages = 0
nobs = 0
nbytes = 0
nconns = 0

print 'files from', os.path.dirname(args[0]), ':'
for fnm in args:
    print os.path.basename(fnm)
    f = open(fnm, 'r')
    for l in f.readlines():
        l = l.replace('\n', '')
        if len(l.split(' ')) != 11:
            print 'XXX'
        server, npg, no, nby, nc, dtm, dtmld, dtm85, dtm85ld, pcpd, pc85pd = l.split(' ')
        if not servd.has_key(server):
            servd[server] = 0 # servers may be replicated accross partitions
        if int(dtm) >  int(dtmld):
            servd[server] = 1
        npages += int(npg)
        nobs += int(no)
        nbytes += int(nby)
        nconns += int(nc)

nservers = len(servd)
nsd = 0
for s in servd.values():
    if s:
        nsd += 1

print '%d servers - %d delayed %d pages %d obs %d bytes %d conns' % (nservers, nsd,  npages,
                                      nobs, nbytes, nconns)
