#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
## 
## Sum and mean all or parts of data fields in file
##
##
############################################################################ 
############################################################################

import os
from sys import argv
import getopt
import sys
from np_data import DataError, DataReader

		
############################################################################## 
#############################################################################
 

def usage(s):

    print '%s <file>' % (s)
    sys.exit(0)

##############################################################################

def doit(d, start, end):

    nf = len(d[0])
    d.sort()

    n = 0
    totn = 0
    sums = [0]*nf

    e1 = e2 = v1 = v2 = None

    startx = start
    if start == None:
        startx = d[0][0]
    endx = end
    if end == None:
        endx = d[-1][0]

    for r in d:
        if startx <= r[0] <= endx:
            if e1 == None:
                e1 = totn
                v1 = r[0]
            e2 = totn
            v2 = r[0]
            for f in range(nf):
                sums[f] += r[f]
            n += 1
        totn += 1

    print nf, 'data fields', n, 'entries read',
    if start != None:
        print 'starting at entry %d (%f)' % (e1, v1),
    if  end != None:
        print 'ending at entry %d (%f)' % (e2, v2),
    print
    print 'mean value(s):',
    for f in range(nf):
        print sums[f]/n,
    print

##############################################################################


def main():

    scriptname = os.path.basename(argv[0])
    fields = None
    exping = 0
    start = end = None

    try:
        optlist, args = getopt.getopt(sys.argv[1:], 's:e:')

    except getopt.error, s:
        print s, 'foo'
        usage(scriptname)

    for opt in optlist:
        if opt[0] == '-h':
            usage(scriptname)
        if opt[0] == '-s':
            try:
                start = float(opt[1])
            except:
                print '%s is not a valid starting value' % (opt[1])
                usage(scriptname)
        if opt[0] == '-e':
            print 'bar'
            try:
                end = float(opt[1])
                print 'bar2'
            except:
                print '%s is not a valid ending value' % (opt[1])
                usage(scriptname)
            

    #if len(args) < 1:
        #print 'No data file specified'
        #usage(scriptname)
    if len(args) > 1:
        print 'Too many data files specified'
        usage(scriptname)
            

    dr = DataReader(args, fields=fields)

    try:
        sets, path, title, xlab, ylab, decs, mode, decs = dr.get_data()
    except DataError, s:
        print 'Data Error %s' % (s)
        sys.exit(1)

    #print sets[0].data

    doit(sets[0].data, start, end)
	     
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
