#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
## 
## Given two data sets with a common IV correlate DVs by associating on
##   coincident IV values
##
## 

############################################################################ 

import string
import glob
import os
import sys
import nprobe
from sys import argv
import getopt
from signal import *
from np_plot import *
	    
	     
##############################################################################

def usage():

    print 'usage corr.py  <data file ts1> <data file ts2>'
    sys.exit(1)
	    
	     
##############################################################################

##############################################################################

def get_data(files):

    alldata = []

    for file in files:
	data = []
	f = open(file, 'r')
	line = 0
	while 1:
	    s = f.readline()
	    line = line +1
	    if not len(s):
		break
	    if s[0] == '#' or s[0] == ' ' or s[0] =='\n':
		#print 'comment'
		continue
	    vs = string.split(s)
	    try:
		data.append([string.atof(vs[0]), string.atof(vs[1])])
	    except IndexError:
		print 'Malformed data line %d in %s' % (line, file)
		sys.exit (1)
	alldata.append((data,len(data)))

    return alldata
	    
	     
##############################################################################

def corr(data, s, e):

    for d in data:
	d[0].sort()

    newdata= []

    print data

    i1 = i2 = 0
    d1 = data[0][0]
    d2 = data[1][0]
    t1 = d1[0][0]
    t2 = d2[0][0]

    if s == None:
	s = min([t1, t2])
    if e == None:
	e = max([data[0][0][-1][0], data[1][0][-1][0]])

    while 1:
## 	if i1 == data[0][1] or i2 == data[1][1]:
## 	    break
	try:
	    if t1 == t2:
		#if s < t1 < e:
		if 1:
		    print 'tm %.3f x=%.3f y=%.3f' % (t1, d1[i1][1], d2[i2][1])
		    newdata.append([d1[i1][1], d2[i2][1]])
		i1 += 1
		i2 += 1
		t1 = d1[i1][0]
		t2 = d2[i2][0]
	    else:
		if t1 < s or t1 > e:
		    print 'zero val for %.3f' % (d1[i1][1])
		    newdata.append([d1[i1][1], 0.0])
		if  t1 < t2:
		    print 't1 > missed t1 = %.3f' % (t1)  
		    i1 += 1
		    t1 = d1[i1][0]
		elif  t1 > t2:
		    print 't1 < missed t1 = %.3f' % (t1)
		    i2 += 1
		    t2 = d2[i2][0]
	except IndexError:
	    # run out of data
	    break

    return newdata  
	    
	     
############################################################################## 


def main():

    start = None
    end = None
    
    try:
        optlist, args = getopt.getopt(sys.argv[1:], 'hs:e:')
	
    except getopt.error, s:
        print 'corr: ' + s
        usage()
        sys.exit(1)
	
    for opt in optlist:
	if opt[0] == "-h":
	    usage(scriptname)
	if opt[0] == "-s":
	    start = string.atof(opt[1])
	if opt[0] == "-e":
	    end = string.atof(opt[1])

    if len(args) == 2:
	print args
	data  = get_data([args[0],args[1]])
    else:
	print 'Specify two data files'
	usage()

    basepath = args[0]

    d = corr(data, start, end)

    s = DataSet(d, DATA_TS, 'correlated', 0, None)

    try:
	np_Plot([s], standalone='yes', path=basepath,  
	    title='Correlated', xlab=os.path.split(args[0])[1], ylab=os.path.split(args[1])[1])
    except EmptyDataSetError:
	print '%s - empty data set' % (ds.path)
	sys.exit(1)


    return
	    
	     
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
