#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################

import string
import nprobe
import socket
import aanon

##############################################################################
## 
##
## IP address anonymisation and net recognition
## 
##
## 
############################################################################

class CU_Local_Nets:

    def __init__(self):
        
        self.nets_txt = ['128.232',
                         '129.169',
                         '131.111',
                         '158.124',
                         '193.60',
                         '192.5.239',
                         '192.18.195',
                         '192.153.213',
                         '192.31.62',
                         '192.84.5',
                         '193.60.80',
                         '193.63.252',
                         '193.63.253'
                         ]
        
        self.calc_nets()

    def calc_nets(self):

        maskA = '255.255.0.0'
        maskB = '255.255.255.0'

        self.nets = []

        for net in self.nets_txt:
            s = string.split(net, '.')
            l = len(s)
            if l == 2:
                net += '.0.0'
                m = maskA
            elif l == 3:
                net += '.0'
                m = maskB
            
            self.nets.append((nprobe._inet_aton(net), nprobe._inet_aton(m)))

##         for n in self.nets:
##             print '%08x ' % (n[0]),
##             print '%08x ' % (n[1]),
##             print nprobe.intoa_string(n[0])

    def is_local(self, addr):

        for n in self.nets:
            p = n[0]
            m = n[1]
            if addr & m == p:
                return 'I'

        return 'E'
        
############################################################################

class Addranon:

    def __init__(self, key=''):

        while key == '':
            key = raw_input('Enter address anonymisation key\n?')

        l = len(key)
        m = 0
        while l < 15:
            key += key[m]
            l += 1
            m += 1

        key = key[:15]

        self.an = aanon.aanon(key)

    def anon(self, addr):

        return self.an.aencode(addr)

    def deanon(self, addr):

        return self.an.adecode(addr)
        
############################################################################

def main():

    test_addrs = ['128.232.123.123',
                '129.169.123.123',
                '131.111.123.123',
                '158.124.123.123',
                '193.60.123.123',
                '192.5.239.123',
                '192.18.195.123',
                '192.153.213.123',
                '192.31.62.123',
                '192.84.5.123',
                '193.60.80.123',
                '212.123.123.123',
                  '213.86.246.80'
                ]
    
    cln = CU_Local_Nets()

    for a in test_addrs:
        print '%15s %s' % (a, cln.is_local(nprobe._inet_aton(a)))

    an = Addranon()

    for a in test_addrs:
        enc = an.anon(nprobe._inet_aton(a))
        dec = an.deanon(enc)
        print '%15s -> %15s -> %15s' % (a, nprobe.intoa_string(enc), nprobe.intoa_string(dec))
    
        
############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()

        
