#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from random import *
from sys import argv
import getopt
import os
import sys

from np_TCPConn import D_BIGDEL


scriptname = os.path.basename(argv[0])
ofnm = None

try:
    optlist, args = getopt.getopt(sys.argv[1:], '')

except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    sys.exit(1)

print args

prop = float(args[0])
#prop = prop/100.0
base = 100.0 - prop

for fnm in args[1:]:
    ff = fnm.replace('.cdf', '')
    newfnm = ff + '-mod'
    newfnm += '.cdf'
    print fnm
    f = open(fnm, 'r')
    nf = open(newfnm, 'w')
    write = nf.write
    xmax = 0
    ymin = 100000000000
    ymax = 0
    bf = []
    for l in f.readlines():
        #print l
        if l[0] =='#':
            continue
        l = l.replace('\n', '')
        l = l.replace('\t', ' ')
        l1 = l.split(' ')
        #print l1
        xc, yc, ya = l1
        #print x, y
        x = float(xc)
        y = float(yc)
        bf.append([x, y])
        xmax = max(x, xmax)
        ymin = min(y, ymin)
        ymax = max(y, ymax)

    range = ymax-ymin 
    mult = prop/range
    print range, prop, mult
        
    print 'writing to', newfnm
    last = bf[0][0]
    for i in bf:
        p = ((i[1]-ymin)*mult)+base
        x = i[0]
        #x += x*(100-p)
        #x *= (xmax-x)/10000
        #if x < last:
        #    x = last
        #last = x
        #print ((i[1]-ymin)*mult)+base
        write('%d %f\n' % (x, p))
