/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/




typedef struct server 
{
  list_t hlist;		/* hash list links */
  unsigned int addr;	/* NBO */
  unsigned int tcp_conns;
  unsigned int http_reqs;
  unsigned int pkts_tx;
  long long bytes_tx;
  unsigned int pkts_retrans;
  long long bytes_retrans;
  unsigned int pkts_served;
  unsigned long long bytes_served;
} server_t;



#define N_SERVER_BUCKETS 16381	/* about 2^14 buckets for hash by hosts */

#define SAME_SERVER(severp, addr) ((serverp)->addr == (addr))

#define N_SERVERS_REPORT 10

int server_hashtbl_initialise();
void do_server(tcp_conn_t *tconnp);
int servers_finish();
