
/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _POOL_H_
#define _POOL_H_


/* TODO - adjust these to appropriate sizes */


#ifndef SINGLE_HOSTS
#define HOSTFLOW_POOL_SZ 4*4096
#else
#define HOSTFLOW_POOL_SZ N_HOST_BUCKETS
#endif
#define TCONN_POOL_SZ 256*256
#define UCONN_POOL_SZ 32*256
#define TRANS_POOL_SZ 32*2024
#define PREC_POOL_SZ BUFFS_HOLDABLE
#define HELDPKT_POOL_SZ (PREC_POOL_SZ*3)/2
#define HDR_BUF_POOL_SZ 16*256
#define LINKS_POOL_SZ 16*256
#define NS_REC_POOL_SZ  16*256
#define TAG_BUF_POOL_SZ 4*1024

#ifdef TCPDUMP_FED
#define BUFREC_POOL_SZ PREC_POOL_SZ
#endif


/* Increment for further pool  allocation if exhausted */

#define POOL_ADDITION 0
#define POOL_INITIALISATION 1

#define POOL_EXHAUST_INC_FRAC 16

#define HOSTFLOW_POOL_INC (HOSTFLOW_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define TCONN_POOL_INC  (TCONN_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define UCONN_POOL_INC  (UCONN_POOL_SZ/POOL_EXHAUST_INC_FRAC) 
#define TRANS_POOL_INC  (TRANS_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define PREC_POOL_INC  (PREC_POOL_SZ/POOL_EXHAUST_INC_FRAC) 
#define HELDPKT_POOL_INC  (HELDPKT_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define HDR_BUF_POOL_INC  (HDR_BUF_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define LINKS_POOL_INC  (LINKS_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define NS_REC_POOL_INC  (NS_REC_POOL_SZ/POOL_EXHAUST_INC_FRAC)
#define TAG_BUF_POOL_INC  (TAG_BUF_POOL_SZ/POOL_EXHAUST_INC_FRAC)

/*
 * pool.c 
 */
void pool_init(void);
host_flow_t *get_host_flow_t(void);
void recycle_host_flow_t(host_flow_t *hfp);
tcp_conn_t *get_tcp_conn_t(void);
void recycle_tcp_conn_t(tcp_conn_t *tcp);
udp_conn_t *get_udp_conn_t(void);
void recycle_udp_conn_t(udp_conn_t *ucp);
http_trans_t *get_http_trans_t(void);
void recycle_http_trans_t(http_trans_t *tp);
tcp_heldpkt_t *get_tcp_heldpkt_t(void);
void recycle_tcp_heldpkt_t(tcp_heldpkt_t *hpp);  
prec_t *get_prec_t(void);
void recycle_prec_t(prec_t *pp);
#ifdef TCPDUMP_FED 
bufrec_t *get_bufrec_t(void);
void recycle_bufrec_t(bufrec_t *bp);
#endif
hdr_buf_t *get_saved_hdr_buffer(void);
void recycle_saved_hdr_buffer(hdr_buf_t *bp);
links_buf_t *get_links_buffer(void);
void recycle_links_buffer(links_buf_t *bp);
void recycle_ns_rec(ns_rec_t *np);
ns_rec_t *get_ns_rec(void);
void tag_buf_pool_init(int n, int init);
char *get_tag_buf(void);
void recycle_tag_buf(char *tp);


#endif /* _POOL_H_ */

/*
 * end pool.h 
 */
