/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _INTERESTING_H_
#define _INTERESTING_H_

#define INTBUF_LEN_MAX 1024

#define INFORM(fmt, args...)     \
MACRO_BEGIN                   \
rec_dump_start(); \
outp += sprintf(outp, fmt, ##args);   \
outp ++; \
rec_dump_end(REC_INFORM); \
MACRO_END


#define INTERESTING(flowp, way, fmt, args...)     \
MACRO_BEGIN                   \
rec_dump_start(); \
DUMP_STRUCT(outp, (flowp), flow_inner_t);  \
DUMP_INT(outp, (way), int);   \
outp += sprintf(outp, fmt, ##args);   \
outp ++; \
rec_dump_end(REC_INTERESTING); \
MACRO_END


#define INTERESTING_NL(flowp, way, buffer, fmt, args...)     \
MACRO_BEGIN                   \
char *cp = (buffer)->buf;       \
int len = (buffer)->len;    \
int copied = 0;   \
rec_dump_start(); \
DUMP_STRUCT(outp, (flowp), flow_inner_t);  \
DUMP_INT(outp, (way), int);   \
outp += sprintf(outp, fmt, ##args);   \
*outp = ' ';    \
while (*cp != '\n' && copied < INTBUF_LEN_MAX && copied++ < len)     \
{        \
*outp = *cp;   \
outp++;     \
cp++;   \
       }     \
*outp = '\0';   \
outp++;    \
rec_dump_end(REC_INTERESTING); \
MACRO_END


#define INTERESTING_END(flowp, way, start, end, fmt, args...)     \
MACRO_BEGIN                   \
char *cp = (start);       \
int copied = 0;   \
rec_dump_start(); \
DUMP_STRUCT(outp, (flowp), flow_inner_t);  \
DUMP_INT(outp, (way), int);   \
outp += sprintf(outp, fmt, ##args);   \
*outp = ' ';    \
while (cp < end  && copied < INTBUF_LEN_MAX)     \
{        \
*outp = *cp;   \
outp++;     \
cp++;   \
       }     \
*outp = '\0';   \
outp++;    \
rec_dump_end(REC_INTERESTING); \
MACRO_END



#endif /* _INTERESTING_H_ */


/*
 * end interesting.h
 */
