#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


import os, sys
from sys import argv
from getopt import getopt
from string import replace
from time import asctime
	    
##############################################################################
	
def main():

    scriptname = os.path.basename(argv[0])

    try:
        optlist, args = getopt(argv[1:], '')

    except getopt.error, s:
        print '%s: Unrecognised option' % (scriptname)
        sys.exit(1)

    if len(args) != 3:
        print '%s ERROR: Takes three arguments - %d given' % (scriptname, len(args))
        sys.exit(1)

    try:
        tmplf = open(args[0], 'r')
    except IOError, s:
        print '%s ERROR: %s' % (scriptname, s)
        sys.exit(1)

    try:
        bmpf = open(args[1], 'w')
    except IOError, s:
        print '%s ERROR: %s' % (scriptname, s)
        sys.exit(1)

    bitmapdir = args[2]

    if not os.path.isdir(bitmapdir):
        print '%s ERROR: %s is not a directory' % (scriptname, bitmapdir)

    bmpf.write('##\n## %s\n## Atomatically generated from %s\n## by %s@%s 0n %s\n##\n\n\n' % (args[1], args[0], os.environ['LOGNAME'], os.environ['HOSTNAME'], asctime()))

    lines = tmplf.readlines()

    for l in lines:
        bmpf.write(replace(l, '$BITMAPDIR', bitmapdir)) 
        
	    
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
