/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _WRITER_H_
#define _WRITER_H_

#define WRITE_BLKSZ 8192

#ifndef SWIG_ONLY

//#define WTRACE

#ifdef WTRACE

#define WRITER_TRACE(col, fmt, args...) \
MACRO_BEGIN  \
  cfprintf(stderr, col, fmt, ##args);\
MACRO_END

#else
#define WRITER_TRACE(fmt, args...)
#endif


#ifdef LARGE_DUMP_FILES

#define N_REPBLKS 256U
//#define N_DUMPBLKS 32768U
#define N_DUMPBLKS 8192U

#else

//#define N_REPBLKS 1024
#define N_REPBLKS 512U
#define N_DUMPBLKS 256U

#endif /* ifdef LARGE_DUMP_FILES */

/* 
 * output buffer over run area 
 * MUST ammend as output data changes
 */

#define TCP_PART_MAXWRITESZ \
(sizeof(unsigned int)\
+sizeof(flow_inner_t)\
+2*sizeof(tcp_simplex_flow_t)\
+sizeof(us_clock_t)\
+sizeof(http_conn_meta_t)\
+sizeof(int) \
+MAX_TCP_DUMPHDRS_HELD*sizeof(tcp_dumphdr_t))

#define TRANS_MAX_WRITESZ \
(sizeof(http_trans_cinf_t) \
+sizeof(http_trans_sinf_t) \
+2*sizeof(http_transinf_t)\
+8*HTTP_REQSTR_LEN\
+4*sizeof(int)   \
+LINKS_BUFSZ*LINKS_MAX_BUFS)

/* buffer managed after every transaction dumped */
#define MAX_WRITESZ (TCP_PART_MAXWRITESZ+TRANS_MAX_WRITESZ)

#define N_REP_ORUNBLKS ((MAX_WRITESZ/WRITE_BLKSZ) + 1)

#define N_DUMP_ORUNBLKS 1	/* XXX s'be calculated */

#define WRITER_STACK_SZ 4*8192

typedef struct 
{
  char *blk_start;
  char *file_end;		/* only set if part block at file end */
} blk_map_t;

/* Flag values */
#define BLK_CONTAINS_FILE_END 0x1

/*
 * writer.c 
 */

extern int writer_pid;
extern int parent_pid;
extern int output_finished;

extern struct rusage *wru;
extern struct timeval *wru_ts;
extern int writer_rusage_lock;
extern int parent_rusage_lock;

extern uint repblk_consumed;
extern blk_map_t rep_blk_map[];
extern blk_map_t dump_blk_map[];

extern uint repblk_used;
extern uint repblk_written;
extern uint dumpblk_used;
extern uint dumpblk_written;

int writer_init(void);
void obuffs_init(void);
int writer(void *arg);
int kill_writer(void);
void writer_error(char *msg, char *pmsg);
void open_rep_file(FILE *f);
void open_dump_file(FILE *f);
void writer_loop(void);


#endif /* ifndef SWIG_ONLY */

#endif /* _WRITER_H_ */

/*
 * end writer.h 
 */
