/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _PROCSTAT_H_
#define _PROCSTAT_H_




/*
 *  Record nprobe process and system activity as gleaned from /proc 
 */

/* Per process */
struct procstat_procrec 
{
  /* from /proc/self/stat */
  unsigned int minflt;
  unsigned int majflt;
  unsigned int utm;
  unsigned int stm;
  unsigned int vsz;			/* # pages vm */
  int rss;
  unsigned int nswap;

  /* from /proc/self/statm */
  int msz;			/* # pages in memory */
  int mrss;			/* # pages rs */
  int mshare;			/* # mmaped pages */
  int mtrs;			/*  text rss */
  int mlrs;			/* shared lib rss */
  int mdrs;			/* data rss */
  int mdt;			/* dirty pages */
};

typedef struct procstat_procrec procstat_procrec_t;

/* System activity */
struct procstat_statrec 
{
  unsigned int utm;
  unsigned int ntm;
  unsigned int stm;
  unsigned int itm;
  unsigned int swin;
  unsigned int swout;
  unsigned int bin;
  unsigned int bout;
  unsigned int itot;
  unsigned int csw; 
};

typedef struct procstat_statrec procstat_statrec_t;

/* Memory state */
struct procstat_memrec 
{
  unsigned int mfree;
  unsigned int mbuff;
  unsigned int memc;
  unsigned int memswp;
  unsigned int memsi;
  unsigned int memso;
  unsigned int bi;
  unsigned int bo;
};

typedef struct procstat_memrec procstat_memrec_t;

/* All of them */
struct procstat_rec 
{
  struct timeval ts;
  struct procstat_procrec proc;
  struct procstat_statrec stat;
  struct procstat_memrec mem;
};

typedef struct procstat_rec procstat_rec_t;

#endif /* _PROCSTAT_H_ */

/* End procstat.h */
  
 
