/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _MALLOC_REC_H_
#define _MALLOC_REC_H_

#ifdef REC_MALLOC


#ifdef REC_MALLOC_MED

#define malloc(x) _rec_malloc((x), #x)
void *_rec_malloc(size_t sz, char *what);

#elif defined REC_MALLOC_MAX

#define malloc(x) _rec_malloc((x), #x, __LINE__, __FILE__)
void *_rec_malloc(size_t sz, char *what, int line, char *file);

#else

#define malloc(x) _rec_malloc((x))
void *_rec_malloc(size_t sz);


#endif

#define free(x) _rec_free((x))

void _rec_free(void *addr);
void report_rec_malloc(void);
void report_rec_malloc_full(void);


#endif /* ifdef REC_MALLOC */


#endif /* ifndef _MALLOC_REC_H_ */

/*
 * end malloc_rec.h
 */
