#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from sys import argv
import getopt
import os
import sys

from np_TCPConn import D_BIGDEL


scriptname = os.path.basename(argv[0])

try:
    optlist, args = getopt.getopt(sys.argv[1:], '')

except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    sys.exit(1)


serverd = {}
nserver = 0
npkts = 0
nconns = 0
nconnsd = 0
nconnsbd = 0
totdel = 0


print 'files from', os.path.dirname(args[0]), ':'
for fnm in args:
    print os.path.basename(fnm)
    f = open(fnm, 'r')
    for l in f.readlines():
        l = l.replace('\n', '')
        #print l
        stuff = l.split(' ')
        server, pkts, nc, ncdel, ncbdel, dl, dflags = stuff

        if not serverd.has_key(server):
            serverd[server] = 0
        if int(dflags) & D_BIGDEL:
            serverd[server] += 1
            #print '%x' % (int(dflags)), serverd[server]
        npkts += int(pkts)
        nconns += int(nc)
        nconnsd += int(ncdel)
        nconnsbd += int(ncbdel)

nserver = len(serverd)
nservdel = 0
for d in serverd.values():
    #print d
    if d:
        nservdel += 1


print '%d servers %d delayed %d server data pkts %d conns %d delayed conns (%d delayed all causes)' % (nserver,
                                    nservdel, npkts, nconns, nconnsbd, nconnsd)
