#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from sys import argv
import getopt
import os
import sys


scriptname = os.path.basename(argv[0])
ofnm = None

try:
    optlist, args = getopt.getopt(sys.argv[1:], '-o')

except getopt.error, s:
    print '%s: %s' % (scriptname, s)
    usage(scriptname)
    sys.exit(1)

for opt in optlist:
    if opt[0] == '-o':
        ofnm = opt[1]


basedir =  os.path.dirname(args[0])
print 'files from', basedir, ':'
for fnm in args:
    print os.path.basename(fnm)

    

if not ofnm:
    ofnm = raw_input('output files base? - base is %s\n?' % (basedir))
outfbase = os.path.join(basedir, ofnm)
print 'writing to'


write = []
for suff in ['.dur', '.dur85', '.ndur', '.ndur85', '.del', '.del85']:
    outfnm = outfbase + suff
    f = open(outfnm, 'w')
    write.append(f.write)
    #print 'writing to', os.path.basename(outfnm)
    print 'writing to', outfnm

npages = 0
npdel = 0
npbdel = 0
npbdel85 = 0
mintm = 999999999999999
maxtm = 0
for fnm in args:
    print os.path.basename(fnm)
    f = open(fnm, 'r')
    for l in f.readlines():
        npages += 1
        l = l.replace('\n', '')
        tm, dur, ndur, dur85, ndur85, dflags = l.split(' ')
        tm = float(tm)
        dur = int(dur)
        ndur = int(ndur)
        dur85 = int(dur85)
        ndur85 = int(ndur85)
        dflags = int(dflags)
        if ndur != dur:
            npbdel += 1
        if ndur85 != dur85:
            npbdel85 += 1
        if dflags:
            npdel += 1
        mintm = min(mintm, tm)
        maxtm = max(maxtm, tm)

        write[0]('%.3f\t%d\n' % (tm, dur))
        write[1]('%.3f\t%d\n' % (tm, dur85))
        write[2]('%.3f\t%d\n' % (tm, ndur))
        write[3]('%.3f\t%d\n' % (tm, ndur85))
        
        write[4]('%.3f\t%d\n' % (tm, dur-ndur))
        write[5]('%.3f\t%d\n' % (tm, dur85-ndur85))


print '%d page downloads - %d delayed %d big delayed %d 85%% bigdelayed' % (npages, npdel, npbdel, npbdel85)

print 'mintm %d maxtm %d' % (mintm, maxtm)
