#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#
# Inputs series of Nprobe logs, accumulates and prints aggregated counters.
# 
###############################################################################

import string
import glob
import os
import sys
import nprobe
from sys import argv
import getopt

from nprobe import *

import np_file_util
#import np_transvalid

#############################################################################

#
#Key types for report filtering (from wread_util.h)
#

KEY_REC = 0x1
KEY_CONN_ID =  0x2
KEY_SERV_ADDR =  0x4
KEY_CLI_ADDR =  0x8

#############################################################################

def usage(n):
    print "%s usage: %s [-r] [-q] [-s]  [-t<type>]" % (n, n)
    print '\t[-c<id>] [-R<rec_no>] [-S<serv_addr>] [-C<cli_addr>]'
    print '\t[-f<type>] [-h] rep-file-list'
    print
    print "Ascii read out of nprobe rep file(s)"
    print "\t[-r] - show records (default is aggregated counters only)"
    print "\t[-q] - check files for consistency (read but don't print out)"
    print "\t[-s] - save aggregated counters to file"
    print "\t[-t<type>] - select records of type <type>"
    print "\t\tall - all (default)\n\t\ti -IP\n\t\tt - TCP\n\t\tu - UDP\n\t\to - Other"
    print "\t\tOther values:- test, http, ftp, ftp-data, rtsp, pnm, nfs, dns"
    print "\t\t fails (buff-alloc fails), rep (periodic accounting reports)"
    print '\t[-c] - show records for connection id only'
    print '\t[-R] - show record rec-no only'
    print '\t[-S] - show connections to server serv-addr only'
    print '\t[-C] - ditto client cli-addr'
    print '\t[-f] - create sub-dir containing rep files corresponding to originals \n\tbut containing records of type only'
    print '\t[-h] - this help'

    sys.exit(1)

#############################################################################

recordsflag = quietflag = saveflag = filterflag = 0
rectype = 0 # REC_ALL
keytype = 0
key = ''

scriptname = os.path.basename(sys.argv[0])

try:
    optlist, args = getopt.getopt(sys.argv[1:], 'rqt:shc:R:S:C:f:')

except getopt.error, s:
    print '%s %s' % (scriptname, s)
    usage(scriptname)

for opt in optlist:
    if opt[0] == "-r":
	recordsflag = 1
    elif opt[0] == "-q":
	quietflag = 1
        recordsflag = 1
    elif opt[0] == "-t":
	rectype = nprobe.parse_type(opt[1])
        recordsflag = 1
    elif opt[0] == "-s":
	saveflag = 1
    elif opt[0] == "-h":
	usage(scriptname)
    elif opt[0] == '-c':
        keytype = KEY_CONN_ID
        key = opt[1][:]
    elif opt[0] == '-R':
        keytype = KEY_REC
        key = opt[1][:]
    elif opt[0] == '-C':
        keytype = KEY_CLI_ADDR
        key = opt[1][:]
    elif opt[0] == '-S':
        keytype = KEY_SERV_ADDR
        key = opt[1][:]
    elif opt[0] == '-f':
        filterflag += 1
	rectype = nprobe.parse_type(opt[1])
        typestr = opt[1]

if not len(args):
    print 'no rep-file list specified'
    usage(scriptname)

if filterflag:
    recordsflag = 0
    if not rectype:
        print 'No record type specified for filter operation'
        usage(scriptname)
        

filelist, counters, basepath = np_file_util.get_files(args)

if not (keytype or rectype or filterflag):
    counters.printself("")
else:
    recordsflag = 1

if saveflag:
    filepath = basepath + 'counters'
    counters.printself_tofile(filepath, '')

if filterflag:
    dirnm = 'filt_' + typestr
    os.mkdir(basepath + dirnm)
    for file in filelist:
	if len(filelist) > 1:
	    print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	    print "File %s - %d records" % (file.fnm, file.counters.nrecords)
	    print
        filenm = os.path.dirname(file.fnm) + '/' + dirnm + '/' + os.path.basename(file.fnm)
        file.filter(rectype, filenm)

elif recordsflag:
    for file in filelist:
	if len(filelist) > 1:
	    print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	    print "File %s - %d records" % (file.fnm, file.counters.nrecords)
	    print
	file.printfile(rectype, keytype, key, quietflag)
