#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


from random import *
import sys
import string
from sys import argv
import getopt

n = 1000
mean = 10.0
sd = 10.0

try:
    optlist, args = getopt.getopt(sys.argv[1:], 'm:d:n:')

except getopt.error, s:
    print 'genorm.py: [-m<mean>] [-d<std dev>] [-n]' + s
    
    sys.exit(1)

for opt in optlist:
    if opt[0] == '-n':
	n = string.atoi(opt[1])
    if opt[0] == '-m':
	mean = string.atof(opt[1])
    if opt[0] == '-d':
	sd = string.atof(opt[1])


f = open('Normal.%.3f.%.3f.%d' % (mean, sd, n), 'w')

for i in range(n):
    f.write('%d\t%.3f\n' % (i, normalvariate(mean, sd)))

f.close()
