#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#
# Investigate usage of in-line images buffers
# 

import string
import glob
import os
import sys
import nprobe
from sys import argv
import getopt

import np_util

#############################################################################

def cmp_by_key(a, b):
    if a[0] > b[0]:
	return 1
    elif a[0] < b[0]:
	return -1
    else:
	return 0

#############################################################################

openfilelist, counters = np_util.get_files(sys.argv[1:])
#openfilelist, counters = np_util.get_files(args)
counters.printself("")

connrec = nprobe.tcp_conn()

nchars_dist = {}
tottrans = 0
tottrans2 = 0
totbufs = 0

for file in openfilelist:
    i = 0
    #print file.counters.nrecords
    while i < file.counters.nrecords:
	i = i + 1
	connrec.getconn(file)
	if connrec.is_http():
	    connrec.get_trans_chain(file)
	    ntrans = connrec.ntrans()
	    tottrans = tottrans + ntrans
	    j = 0
	    trans = connrec.su.http.trans
	    while j < ntrans:
		j = j + 1
		#tottrans = tottrans + 1
		if connrec.server_seen() and not trans.isdummy():
		    n_imgchars = trans.inner.il_imagechars_indx
		    if n_imgchars == 0:
			continue
		    if n_imgchars > 16386:
			trans.printself(connrec)
		    totbufs = totbufs + 1
		    if not nchars_dist.has_key(n_imgchars):
			nchars_dist[n_imgchars] = 0
		    nchars_dist[n_imgchars] = nchars_dist[n_imgchars] + 1
		    trans = trans.next
	    connrec.free_trans_chain()

distlist = nchars_dist.items()
distlist.sort(cmp_by_key)
accum = 0
cd = 0.0


pdf = open("./imgchars.pdf", "w")
cdf = open("./imgchars.cdf", "w")

print "total transactions ", tottrans
for item in distlist:
    print "%8d %8d" % (item[0], item[1]),
    accum = accum + item[1]
    cd = (accum*100)/totbufs
    print "%.2f" % (cd)
    pdf.write("%8d %8d\n" % (item[0], item[1]))
    cdf.write("%8d %.2f\n" % (item[0], cd))
    tottrans2 = tottrans2 + item[1]
print "total transactions ", tottrans2
pdf.close()
cdf.close()

