#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
## 
##
############################################################################ 

import string
import glob
import os
import sys
import nprobe
from sys import argv
import getopt

import np_file_util

############################################################################

def usage(scriptname):
    print "usage: " + scriptname + "rep-file-list"
    print
    print "Print out DNS records"

    return

############################################################################# 

class lookup:

    def __init__(self, conn, nsrec):

	def rrlist(rec):
	    l = []
	    
	    rr = nsrec.rrbuf
	    indx = 0

	    ent = nprobe.rrent()
	    #print 'index %d' % (indx)
	    add = ent.nextent(indx, nsrec)
	    #print 'X add = %d' % (add)
	    #print 'X ent = '
	    #ent.printself()

	    while add > 0:
		if ent.code < 50 and ent.code >= 0:
		    print 'adding code %d' % (ent.code)
		    l.append(ent)
		    ent = nprobe.rrent()
		indx = add
		#print 'index %d' % (indx)
		add = ent.nextent(indx, nsrec)
		#print 'X add = %d' % (add)
		#print 'X ent = '
		#ent.printself()

	    
	    return l
	



	self.client = conn.shost()
	self.server = conn.dhost()
	self.nsrec = nsrec
	if nsrec.ns_rec.state & 0x10:
	    self.rrlist = rrlist(nsrec)
	else:
	    self.rrlist = []

    def printself(self):
	print '%s ../.. %s' % (nprobe.intoa_string(self.client), nprobe.intoa_string(self.server))
	#self.nsrec.printself()
	for ent in self.rrlist:
	    ent.printself()
	print

############################################################################# 

scriptname = 'np_ns.py'

try:
    optlist, args = getopt.getopt(sys.argv[1:], 'h')

except getopt.error, s:
    print scriptname + ": " + s
    usage(scriptname)
    sys.exit(1)

for opt in optlist:
    if opt[0] == "-h":
        usage(scriptname)
    sys.exit(1)

openfilelist, counters, basepath = np_file_util.get_files(args)

counters.printself("")

conn = nprobe.udp_conn()
nsrec = nprobe.ns_fullrec()

for file in openfilelist:

    if len(openfilelist) > 1:
        print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
        print "File %s - %d records" % (file.fnm, file.counters.nrecords)
        print
        sys.stdout.flush()

    while 1:

	if conn.get_ns_conn(file) == -1:
	    break

	#conn.printself()
	nsrec.get_ns_rec(file)
	#nsrec.printself()
	l = lookup(conn, nsrec)
	l.printself()
	print
