###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#import string
#import os
import sys
#import nprobe
#from sys import argv
#import getopt
#from signal import *
#import socket

#from traceback import print_stack

#import np_file_util
#import np_http_util
#from np_obnode import *
#from  np_longutil import *
#from np_tfilter import *
#import np_addranon


############################################################################

#
# Writes strings to a list
#

class ListWriter:

    def __init__(self, list):

        self.list = list

    def write(self, string):

        self.list.append(string)
        

############################################################################

class E_Counters:

    def __init__(self):

        # TCP conns
        self.nconns = 0
        self.start_rej = 0 # before specified start record
        self.id_rej = 0 # rejected by id filter
        self.cf_rej = 0 # rejected by connection filter
        self.ow_rej = 0 # one way only
        self.tf_rej = 0 # rejected by tfilter
        self.host_rej = 0 # rejected by hosts/clients/servers filter
        self.port_rej = 0 # rejected by port filter

        self.conn_ids_got = 0 # specific connection ids found

        # transactions
        self.ntrans = 0
        self.valtrans = 0
        self.tnoresp = 0
        self.tnopersresp = 0
        self.tsinval = 0
        self.tcinval = 0
        self.tdummy = 0
        self.terr = 0
        self.treqstart = 0
        self.treqend = 0
        self.trepstart = 0
        self.trepbodystart = 0
        self.trepend = 0

############################################################################

    def printself(self, tfilt, f=sys.stdout, leader=''):
        print 'Counters'
        print
        f.write('%sTotal connections: %d \n' % (leader, self.nconns))
        f.write('%sRejected:\n' % (leader))
        if self.start_rej:
            f.write('%s   Before specified start record %d \n' % (leader, self.start_rej))
        if self.id_rej:
            f.write('%s   Rejected by id filter %d \n' % (leader, self.id_rej))
        if self.cf_rej:
            f.write('%s   Rejected by flow filter %d \n' % (leader, self.cf_rej))
        if self.ow_rej:
            f.write('%s   One way only %d \n' % (leader, self.ow_rej))
        if self.tf_rej:
            f.write('%s   Rejected by tfilter: %d \n' % (leader, self.tf_rej))
        if self.host_rej:
            f.write('%s   Rejected by host/client/server filter: %d \n' % (leader, self.host_rej))
        if self.port_rej:
            f.write('%s   Rejected by port filter: %d \n' % (leader, self.port_rej))

        if tfilt:
            tfr = tfilt.report()
            if len(tfr):
                for r in tfr:
                    f.write('%s      %s %d ' % (leader, r[0], r[1]))

        f.write('\n')

        if self.ntrans:

            f.write('%sTotal transactions %d \n' % (leader, self.ntrans))
            f.write('%sValid %d \n' % (leader, self.valtrans))
            f.write('%sRejected: \n' % (leader))
            if self.tnoresp:
                f.write('%s   No response from server %d \n' % (leader, self.tnoresp))
            if self.tnopersresp:
                f.write('%s   No response from server to persistent request %d \n' % (leader, self.tnopersresp))
            if self.tcinval:
                f.write('%s   Client transaction invalid %d \n' % (leader, self.tcinval))
            if self.tsinval:
                f.write('%s   Server transaction invalid %d \n' % (leader, self.tsinval))
            if self.tdummy:
                f.write('%s   Dummy %d\n' % (leader, self.tdummy))
            if self.terr:
                f.write('%s   Error %d\n' % (leader, self.terr))
            if self.treqstart:
                f.write('%s   Request start timing error %d \n' % (leader, self.treqstart))
            if self.treqend:
                f.write('%s   Request end before start %d \n' % (leader, self.treqend))
            if self.trepstart:
                f.write('%s   Response before request end %d\n' % (leader, self.trepstart))
            if self.trepend:
                f.write('%s   Response ends before start %d \n' % (leader, self.trepend))
            if self.trepbodystart:
                f.write('%s   Response body start outside response time %d \n' % (leader, self.trepbodystart))

############################################################################

    def printself_tofile(self, fnm, tfilt, leader='# '):
        
        try:
            f = open(fnm, 'a')
        except IOError, msg:
            print 'I/O error %s' % (msg)
            sys.exit(1)
            
        self.printself(tfilt, f=f, leader=leader)

        f.close()

############################################################################

    def printself_tolist(self, list, tfilt, leader=''):

        f = ListWriter(list)

        self.printself(tfilt, f=f, leader=leader)

############################################################################
