/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


%module aanon

%{
struct aanon 
{
  int keyfold;
  unsigned char key[16];
  unsigned char perm[257];
};
%}

struct aanon 
{
  int keyfold;
  unsigned char key[16];
  unsigned char perm[257];
};

%addmethods aanon {

/* Constructor */

aanon(char *key)
{
  int i, j, *kf;
  unsigned char *k, *p, x;
  struct aanon *ap;
	
  if ((ap = (struct aanon *)malloc(sizeof(struct aanon))) == NULL)
    {
      fprintf(stderr, "pymod aanon: init malloc error\n");
      exit(1);
    }

  if (strlen(key) != 15)
    {
      fprintf(stderr, "pymod aanon: init keylen error\n");
      exit(1);
    }

  k = ap->key;
  p = ap->perm;
  strcpy(k, key);

  for (i=0; i<256; i++)
    {
      x = (i+k[0])^k[1];
      x = (x+k[2])^k[3];
      p[i^k[4]] = x;
    }

  for (i=0; i<2; i++)
    {
      p[256] = p[0];
      for (j=0; j <256; j++)
	{
	  p[j] = p[x];
	  p[x] = p[j+1];
	  x = p[(x+k[j&15]) & 255];
	  k[j&15] = x;
	}
    }

  kf = (int *)k;
  ap->keyfold = (kf[0]^kf[3]) ^ (kf[1]^kf[2]);

  return ap;
}

/*Destructor */
~aanon() 
{
  free(self);
}

int aencode(int addr)
{
  int i;
  int add = addr;
  unsigned char  *a = (unsigned char *)&add;
  unsigned char *p = self->perm;

  for (i=0; i<3; i++)
    {
      a[0] = a[0] ^ p[(2*a[3])&255];
      a[1] = a[1] ^ p[(a[0]+a[2])&255];
      a[2] = a[2] ^ p[(a[1]+a[1])&255];
      a[3] = a[3] ^ p[(a[2]+a[0])&255];
    }

  return add^self->keyfold;
}

int adecode(int addr)
{
  int i;
  int add = addr^self->keyfold;
  unsigned char  *a = (unsigned char *)&add;
  unsigned char *p = self->perm;

  for (i=0; i<3; i++)
    {
      a[3] = a[3] ^ p[(a[2]+a[0])&255];
      a[2] = a[2] ^ p[(a[1]+a[1])&255];
      a[1] = a[1] ^ p[(a[0]+a[2])&255];
      a[0] = a[0] ^ p[(2*a[3])&255];
    }

  return add;
}

}; /* End addmethods aanon */
