/******************************************************************************
 * mpls.h
 * 
 *   User-space interface library for MPLS-on-Linux.
 * 
 *   Copyright (c) 2000, K A Fraser
 */

#ifndef __USER_MPLS_H__
#define __USER_MPLS_H__

#include <linux/mpls.h>

int mpls_init(void);
void mpls_cleanup(void);

int mpls_add_switch_mapping(switch_mapping_t *sm);
int mpls_del_switch_mapping(cid_t *cid);
int mpls_add_port_mapping(port_mapping_t *pm);
int mpls_del_port_mapping(int port);
int mpls_add_ingress_mapping(ingress_mapping_t *im);
int mpls_del_ingress_mapping(fec_t *fec);
int mpls_add_egress_mapping(egress_mapping_t *em);
int mpls_del_egress_mapping(cid_t *cid);
int mpls_flush_all(void);
int mpls_debug_on(void);
int mpls_debug_off(void);
#ifdef LABEL_STACKING
int mpls_add_label_pop(cid_t *cid);
int mpls_del_label_pop(cid_t *cid);
#endif

#endif /* __USER_MPLS_H__ */
