/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <rpc/types.h>

#ifndef _FORE_XDR_H
#define _FORE_XDR_H

#if defined(RCSID) && !defined(lint)
static char _fore_xdr_x_rcsid[] = "@(#)$Id: fore_xdr.h 1.1 Thu, 29 Apr 1999 09:53:48 +0100 dr10009 $ FSI";
#endif /* RCSID && !lint */

#define FORE_ATM_VERSION 0x100 /* version number is x.y, encoded as x*256+y */

#ifdef aix
#include <sys/time.h>
#include <rpc/rpc.h>
#include <rpc/xdr.h>
#endif /* aix */
#ifdef hppa
#include <rpc/xdr.h>
#endif /* hppa */

struct Atm_address {
	char addr[8];
};
typedef struct Atm_address Atm_address;
bool_t xdr_Atm_address();

typedef u_int Atm_hdr;
bool_t xdr_Atm_hdr();

typedef u_int Atm_sap;
bool_t xdr_Atm_sap();
#define ATM_NSAP_LENGTH 20
#ifdef WSCP
#pragma pack 1
#pragma align 1
#endif 

struct nsap_t {
	char addr[20];
};
typedef struct nsap_t nsap_t;
bool_t xdr_nsap_t();

typedef u_int mask_t;
bool_t xdr_mask_t();

struct lognode_t {
	nsap_t node_id;
	mask_t mask;
};
typedef struct lognode_t lognode_t;
bool_t xdr_lognode_t();

typedef u_int logport_t;
bool_t xdr_logport_t();
#ifdef WSCP
#pragma pack 0
#pragma align 0
#endif 

enum route_orig_t {
	static_route = 1,
	spans_pnni = 2,
	ilmi_registered = 3,
	pnni = 4,
	external = 5
};
typedef enum route_orig_t route_orig_t;
bool_t xdr_route_orig_t();

typedef u_int capset_t;
bool_t xdr_capset_t();
#define  VPC_SUPPORT         0x00008000
#define  ABR_SUPPORT         0x00004000
#define  SYNC_TIMING_SUPPORT 0x00002000
#define  EPD_SUPPORT         0x00001000

struct loglink_t {
	lognode_t src;
	logport_t sport;
	lognode_t dst;
	logport_t dport;
	u_int cost;
	u_int ubr_vcs;
	u_int cbr_cap;
	u_int cbr_fifo;
	u_int vbr_cap;
	u_int vbr_fifo;
	route_orig_t originator;
	capset_t capset;
	u_int freshness;
	u_int unused_1;
	u_int unused_2;
};
typedef struct loglink_t loglink_t;
bool_t xdr_loglink_t();

typedef u_int Vpvc;
bool_t xdr_Vpvc();

struct Atm_vpvc_pref {
	u_int valid;
	Vpvc vpvc;
};
typedef struct Atm_vpvc_pref Atm_vpvc_pref;
bool_t xdr_Atm_vpvc_pref();

typedef u_int Version;
bool_t xdr_Version();

enum Encaps_type {
	encaps_null = 0,
	encaps_llc = 1,
	encaps_ieee802 = 2
};
typedef enum Encaps_type Encaps_type;
bool_t xdr_Encaps_type();

enum Aal_type {
	aal_null = 0,
	aal_type_1 = 1,
	aal_type_2 = 2,
	aal_type_3 = 3,
	aal_type_4 = 4,
	aal_type_5 = 5
};
typedef enum Aal_type Aal_type;
bool_t xdr_Aal_type();

enum Message_type {
	status_request = 0,
	status_indication = 1,
	status_response = 2,
	open_request = 3,
	open_indication = 4,
	open_response = 5,
	open_confirmation = 6,
	close_request = 7,
	close_indication = 8,
	close_response = 9,
	close_confirmation = 10,
	rclose_request = 11,
	rclose_indication = 12,
	rclose_response = 13,
	rclose_confirmation = 14,
	multi_request = 15,
	multi_indication = 16,
	multi_response = 17,
	multi_confirmation = 18,
	add_request = 19,
	add_indication = 20,
	add_response = 21,
	add_confirmation = 22,
	join_request = 23,
	join_confirmation = 24,
	leave_request = 25,
	leave_confirmation = 26,
	mpp_request = 27,
	mpp_response = 28,
	nsap_map_request = 98,
	nsap_indication = 99,
	map_indication = 100,
	setup_request = 101,
	setup_response = 102,
	change_request = 103,
	change_response = 104,
	relocate_request = 105,
	relocate_response = 106,
	hello_indication = 107,
	query_request = 110,
	query_response = 111
};
typedef enum Message_type Message_type;
bool_t xdr_Message_type();

struct Atm_connection {
	Atm_address daddr;
	Atm_address saddr;
	Atm_sap dsap;
	Atm_sap ssap;
};
typedef struct Atm_connection Atm_connection;
bool_t xdr_Atm_connection();

struct Atm_conn_resource {
	u_int peak_bandwidth;
	u_int mean_bandwidth;
	u_int mean_burst;
};
typedef struct Atm_conn_resource Atm_conn_resource;
bool_t xdr_Atm_conn_resource();

struct Atm_rc_info {
	u_int rc_period_desc;
};
typedef struct Atm_rc_info Atm_rc_info;
bool_t xdr_Atm_rc_info();

struct Network_link {
	Atm_address dst_addr;
	Atm_address src_addr;
	u_int capacity;
	u_int freshness;
	u_int cost;
};
typedef struct Network_link Network_link;
bool_t xdr_Network_link();
#define VOID_CAPACITY 0xFFFFFFFF
#define MAX_HOPS 64

struct Atm_switch_route {
	u_int num_hops;
	u_int next_hop;
	u_int route[MAX_HOPS];
};
typedef struct Atm_switch_route Atm_switch_route;
bool_t xdr_Atm_switch_route();

enum Atm_sig_result {
	success = 0,
	failure = 1,
	no_vpvc = 2,
	no_resources = 3,
	bad_destination = 4
};
typedef enum Atm_sig_result Atm_sig_result;
bool_t xdr_Atm_sig_result();

struct Open_req_args {
	Atm_connection conn;
	Aal_type aal;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
};
typedef struct Open_req_args Open_req_args;
bool_t xdr_Open_req_args();

struct Open_ind_args {
	Atm_connection conn;
	Aal_type aal;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
};
typedef struct Open_ind_args Open_ind_args;
bool_t xdr_Open_ind_args();

struct Open_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc vpvc;
};
typedef struct Open_rsp_args Open_rsp_args;
bool_t xdr_Open_rsp_args();

struct Open_cnf_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc vpvc;
};
typedef struct Open_cnf_args Open_cnf_args;
bool_t xdr_Open_cnf_args();

struct Multi_req_args {
	Atm_connection conn;
	Aal_type aal;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
};
typedef struct Multi_req_args Multi_req_args;
bool_t xdr_Multi_req_args();

struct Multi_ind_args {
	Atm_connection conn;
	Aal_type aal;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
};
typedef struct Multi_ind_args Multi_ind_args;
bool_t xdr_Multi_ind_args();

struct Multi_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc vpvc;
};
typedef struct Multi_rsp_args Multi_rsp_args;
bool_t xdr_Multi_rsp_args();

struct Multi_cnf_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc vpvc;
};
typedef struct Multi_cnf_args Multi_cnf_args;
bool_t xdr_Multi_cnf_args();

struct Add_req_args {
	Atm_connection conn;
	Atm_connection old;
};
typedef struct Add_req_args Add_req_args;
bool_t xdr_Add_req_args();

struct Add_ind_args {
	Atm_connection conn;
	Atm_connection old;
};
typedef struct Add_ind_args Add_ind_args;
bool_t xdr_Add_ind_args();

struct Add_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
};
typedef struct Add_rsp_args Add_rsp_args;
bool_t xdr_Add_rsp_args();

struct Add_cnf_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
};
typedef struct Add_cnf_args Add_cnf_args;
bool_t xdr_Add_cnf_args();

struct Join_req_args {
	Atm_address group;
};
typedef struct Join_req_args Join_req_args;
bool_t xdr_Join_req_args();

struct Join_cnf_args {
	Atm_address group;
	Atm_sig_result result;
};
typedef struct Join_cnf_args Join_cnf_args;
bool_t xdr_Join_cnf_args();

struct Leave_req_args {
	Atm_address group;
};
typedef struct Leave_req_args Leave_req_args;
bool_t xdr_Leave_req_args();

struct Leave_cnf_args {
	Atm_address group;
	Atm_sig_result result;
};
typedef struct Leave_cnf_args Leave_cnf_args;
bool_t xdr_Leave_cnf_args();

struct Mpp_req_args {
	Atm_connection pseudo;
	Atm_connection conn;
	Aal_type aal;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
};
typedef struct Mpp_req_args Mpp_req_args;
bool_t xdr_Mpp_req_args();

struct Mpp_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Vpvc vpvc;
	Atm_conn_resource qos;
};
typedef struct Mpp_rsp_args Mpp_rsp_args;
bool_t xdr_Mpp_rsp_args();

struct Close_req_args {
	Atm_connection conn;
};
typedef struct Close_req_args Close_req_args;
bool_t xdr_Close_req_args();

struct Close_ind_args {
	Atm_connection conn;
};
typedef struct Close_ind_args Close_ind_args;
bool_t xdr_Close_ind_args();

struct Close_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
};
typedef struct Close_rsp_args Close_rsp_args;
bool_t xdr_Close_rsp_args();

struct Close_cnf_args {
	Atm_connection conn;
	Atm_sig_result result;
};
typedef struct Close_cnf_args Close_cnf_args;
bool_t xdr_Close_cnf_args();

struct Rclose_req_args {
	Atm_connection conn;
};
typedef struct Rclose_req_args Rclose_req_args;
bool_t xdr_Rclose_req_args();

struct Rclose_ind_args {
	Atm_connection conn;
};
typedef struct Rclose_ind_args Rclose_ind_args;
bool_t xdr_Rclose_ind_args();

struct Rclose_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
};
typedef struct Rclose_rsp_args Rclose_rsp_args;
bool_t xdr_Rclose_rsp_args();

struct Rclose_cnf_args {
	Atm_connection conn;
	Atm_sig_result result;
};
typedef struct Rclose_cnf_args Rclose_cnf_args;
bool_t xdr_Rclose_cnf_args();

struct Status_req_args {
	long host_epoch;
};
typedef struct Status_req_args Status_req_args;
bool_t xdr_Status_req_args();

struct Status_ind_args {
	long switch_epoch;
	Atm_address host_addr;
	Atm_address switch_addr;
};
typedef struct Status_ind_args Status_ind_args;
bool_t xdr_Status_ind_args();

struct Status_rsp_args {
	long host_epoch;
	Atm_address host_addr;
};
typedef struct Status_rsp_args Status_rsp_args;
bool_t xdr_Status_rsp_args();

struct Hello_ind_args {
	lognode_t lognode;
	logport_t logport;
	long cost;
	long ubr_vcs;
	long cbr_cap;
	long cbr_fifo;
	long vbr_cap;
	long vbr_fifo;
	capset_t capset;
};
typedef struct Hello_ind_args Hello_ind_args;
bool_t xdr_Hello_ind_args();

struct Nsap_req_args {
	lognode_t lognode;
	logport_t logport;
};
typedef struct Nsap_req_args Nsap_req_args;
bool_t xdr_Nsap_req_args();
#define MAX_LINKS 64

struct Map_ind_args {
	u_int num_links;
	Network_link links[MAX_LINKS];
};
typedef struct Map_ind_args Map_ind_args;
bool_t xdr_Map_ind_args();
#define MAX_NSAP_LINKS 32

struct Nsap_ind_args {
	u_int num_links;
	loglink_t links[MAX_NSAP_LINKS];
};
typedef struct Nsap_ind_args Nsap_ind_args;
bool_t xdr_Nsap_ind_args();

struct Setup_req_args {
	Atm_connection conn;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	Atm_vpvc_pref pref;
	u_int num_vci;
	u_int min_vci;
};
typedef struct Setup_req_args Setup_req_args;
bool_t xdr_Setup_req_args();

struct Setup_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc first_vpvc;
	Vpvc last_vpvc;
};
typedef struct Setup_rsp_args Setup_rsp_args;
bool_t xdr_Setup_rsp_args();

struct Change_req_args {
	Atm_connection conn;
	Atm_conn_resource qos;
	Atm_conn_resource min;
	u_int num_vci;
	u_int min_vci;
};
typedef struct Change_req_args Change_req_args;
bool_t xdr_Change_req_args();

struct Change_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	Atm_conn_resource qos;
	Vpvc first_vpvc;
	Vpvc last_vpvc;
};
typedef struct Change_rsp_args Change_rsp_args;
bool_t xdr_Change_rsp_args();

struct Relocate_req_args {
	Atm_connection conn;
	Atm_connection new_path;
	Atm_vpvc_pref pref;
};
typedef struct Relocate_req_args Relocate_req_args;
bool_t xdr_Relocate_req_args();

struct Relocate_rsp_args {
	Atm_connection conn;
	Atm_sig_result result;
	u_int new_vci;
};
typedef struct Relocate_rsp_args Relocate_rsp_args;
bool_t xdr_Relocate_rsp_args();

enum Atm_sig_state {
	sig_state_open = 0,
	sig_state_open_pending = 1,
	sig_state_close_pending = 2,
	sig_state_closed = 3
};
typedef enum Atm_sig_state Atm_sig_state;
bool_t xdr_Atm_sig_state();

enum Atm_query_action {
	Atm_query_normal = 0,
	Atm_query_debug = 1,
	Atm_query_end2end = 2
};
typedef enum Atm_query_action Atm_query_action;
bool_t xdr_Atm_query_action();

struct Query_req_args {
	Atm_connection conn;
	Atm_query_action type;
};
typedef struct Query_req_args Query_req_args;
bool_t xdr_Query_req_args();

struct Query_rsp_args {
	Atm_connection conn;
	Atm_query_action type;
	Atm_sig_state state;
	u_int data;
};
typedef struct Query_rsp_args Query_rsp_args;
bool_t xdr_Query_rsp_args();

struct Msg_contents {
	Message_type type;
	union {
		Status_req_args status_req;
		Status_ind_args status_ind;
		Status_rsp_args status_rsp;
		Open_req_args open_req;
		Open_req_args open_ind;
		Open_rsp_args open_rsp;
		Open_rsp_args open_cnf;
		Multi_req_args multi_req;
		Multi_req_args multi_ind;
		Multi_rsp_args multi_rsp;
		Multi_rsp_args multi_cnf;
		Add_req_args add_req;
		Add_req_args add_ind;
		Add_rsp_args add_rsp;
		Add_rsp_args add_cnf;
		Join_req_args join_req;
		Join_cnf_args join_cnf;
		Leave_req_args leave_req;
		Leave_cnf_args leave_cnf;
		Mpp_req_args mpp_req;
		Mpp_rsp_args mpp_rsp;
		Close_req_args close_req;
		Close_req_args close_ind;
		Close_rsp_args close_rsp;
		Close_rsp_args close_cnf;
		Rclose_req_args rclose_req;
		Rclose_req_args rclose_ind;
		Rclose_rsp_args rclose_rsp;
		Rclose_rsp_args rclose_cnf;
		Nsap_req_args nsap_req;
		Nsap_ind_args nsap_ind;
		Map_ind_args map_ind;
		Setup_req_args setup_req;
		Setup_rsp_args setup_rsp;
		Change_req_args change_req;
		Change_rsp_args change_rsp;
		Relocate_req_args relocate_req;
		Relocate_rsp_args relocate_rsp;
		Hello_ind_args hello_ind;
		Query_req_args query_req;
		Query_rsp_args query_rsp;
	} Msg_contents_u;
};
typedef struct Msg_contents Msg_contents;
bool_t xdr_Msg_contents();

struct Atm_sig_msg {
	Version release;
	Msg_contents value;
};
typedef struct Atm_sig_msg Atm_sig_msg;
bool_t xdr_Atm_sig_msg();

#endif /* _FORE_XDR_H */
