
#include <nemesis.h>
#include <stdio.h>
#undef EOF
#include <stdlib.h>

#include <contexts.h>
#include <ntsc.h>

#define SCR_WIDTH  1024
#define SCR_HEIGHT  768
#define SCRSIZEINBYTES   (SCR_WIDTH * SCR_HEIGHT * 2)

int main(int argc, char **argv)
{
    addr_t scrmem;
    unsigned char *scrcopy;
    int red, green, blue;
    int word;
    int i;
    int ipl;
    FILE *f;

    if (argc != 2)
    {
	fprintf(stderr,
		"usage: scrdump <filename>\n"
		"\twrites a screen image to filename in PPM format\n");
	return 0;
    }

    f = fopen(argv[1], "w");
    if (!f)
    {
	fprintf(stderr, "scrdump: failed to open %s\n", argv[1]);
	return 2;
    }

    fprintf(stderr,"Screen dump starting; better have kernel privileges\n");

    scrmem = NAME_FIND("dev>fblite", addr_t);

    fprintf(stderr,"Framebuffer is at %x\n", scrmem);

    scrcopy = malloc(SCRSIZEINBYTES);

    if (!scrcopy) {
	fprintf(stderr,"Couldn't get memory for temporary buffer\n");
	return 3;
    }


    ENTER_KERNEL_CRITICAL_SECTION();
    ipl = ntsc_ipl_high();

    memcpy(scrcopy, scrmem, SCRSIZEINBYTES);

    ntsc_swpipl(ipl);
    LEAVE_KERNEL_CRITICAL_SECTION();

    fprintf(stderr, "Writing approx %d bytes...\n", SCRSIZEINBYTES / 2 * 3);

    fprintf(f, "P6\n");
    fprintf(f, "# Generated by scrdump.c on Nemesis\n");
    fprintf(f, "%d %d\n", SCR_WIDTH, SCR_HEIGHT);
    fprintf(f, "31\n");
    i = 0;
    while(i < SCRSIZEINBYTES)
    {
	word = (scrcopy[i+1] << 8) | scrcopy[i];

	red   = (word >> 10) & 0x1f;
	green = (word >>  5) & 0x1f;
	blue  = (word)       & 0x1f;
	
	fprintf(f, "%c%c%c", red, green, blue);

	i += 2;
    }
    fclose(f);

    fprintf(stderr,"Screendump done.\n");
    return 0;
}
