﻿// $Id: RunStereoVideoProgram.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using VideoLib;
using VideoLib.Scheduling;
using VideoLib.Sources;
using VideoLib.LibAv;
using VideoLib.Frames;
using VideoLib.Sinks;
using System.IO;
using CrossChecker;
using StereoLibTester;

namespace RunStereoVideo
{
	class RunStereoVideoProgram
	{
		static void Main(string[] args)
		{
			if (args.Length < 5)
			{
				Console.WriteLine("Usage: RunStereoVideo input_dir num_frames num_disparities disparity_scale technique_name");
				return;
			}

			// inputs
			string dataPath = args[0]; // "../../../data/teddy/";
			int numFrames = Int32.Parse(args[1]); // 5
			int numDisparities = Int32.Parse(args[2]); // 64
			int dispScale = Int32.Parse(args[3]); // 4
			string techniqueName = args[4];
			int noiseLevel = (args.Length > 5 ? Int32.Parse(args[5]) : 0);

			// derived inputs
			//string outputPath = Path.Combine(dataPath, String.Format("{0}-{1:000}", techniqueName, noiseLevel)); // dir: TechniqueName-NoiseLevel
			string outputPath = Path.Combine(dataPath, techniqueName); // dir: TechniqueName
			//string leftImageFilename = Path.Combine(dataPath, "left.png");
			//string rightImageFilename = Path.Combine(dataPath, "right.png");
			//string maskAllFilename = Path.Combine(dataPath, "mask-all.png");
			//string maskNonoccFilename = Path.Combine(dataPath, "mask-nonocc.png");
			//string maskDiscFilename = Path.Combine(dataPath, "mask-disc.png");
			//string groundTruthFilename = Path.Combine(dataPath, "true.png");
			string leftImageFilename = Path.Combine(dataPath, "L{0:0000}.png");
			string rightImageFilename = Path.Combine(dataPath, "R{0:0000}.png");
			string groundTruthFilename = Path.Combine(dataPath, "TL{0:0000}.png");

			////string leftDispFilename = Path.Combine(outputPath, "disp-left.png");
			////string rightDispFilename = Path.Combine(outputPath, "disp-right.png");
			//string leftDispFilename = Path.Combine(outputPath, "RawDL{0:0000}.png");
			//string rightDispFilename = Path.Combine(outputPath, "RawDR{0:0000}.png");
			//string leftCleanedFilename = Path.Combine(outputPath, "DL{0:0000}.png");
			//Directory.CreateDirectory(outputPath);

			// for saving noisy input images (for supplementary videos)
			// NB: StereoLibTesterProgram.GenerateDepthMaps
			string leftDispFilename = Path.Combine(dataPath, String.Format("Noise{0:000}-", noiseLevel) + "L{0:0000}.png");
			string rightDispFilename = Path.Combine(dataPath, String.Format("Noise{0:000}-", noiseLevel) + "R{0:0000}.png");

			// run left-right & right-left stereo
			RunLeftRightStereoVideo(leftImageFilename, rightImageFilename, numFrames, numDisparities, techniqueName, noiseLevel, leftDispFilename, rightDispFilename);

			//// can comment this out for noisy videos
			//RunLeftRightValidationAndEvaluation(leftDispFilename, rightDispFilename, numFrames, numDisparities, dispScale, leftCleanedFilename, groundTruthFilename);
		}

		public static void RunLeftRightStereoVideo(
			string leftImageFilename, string rightImageFilename,
			int numFrames, int numDisparities, string techniqueName, int noiseLevel,
			string leftDispFilename, string rightDispFilename)
		{
			Console.WriteLine("Running LeftRightStereoVideo");
			Console.WriteLine("----------------------------");
			Console.WriteLine("Left images  : {0}", leftImageFilename);
			Console.WriteLine("Right images : {0}", rightImageFilename);
			Console.WriteLine("# of Frames  : {0}", numFrames);
			Console.WriteLine("Disparities  : {0}", numDisparities);
			Console.WriteLine("Technique    : {0}", techniqueName);
			Console.WriteLine("Noise Level  : {0}", noiseLevel);
			Console.WriteLine();

			// run left-right stereo
			Console.WriteLine("Starting Left-Right Sequence ...");
			Console.WriteLine();
			StereoLibTesterProgram.Main(new string[] { leftImageFilename, rightImageFilename, numFrames.ToString(), numDisparities.ToString(), leftDispFilename, techniqueName, noiseLevel.ToString() });

			// run right-left stereo
			Console.WriteLine("Starting Right-Left Sequence ...");
			Console.WriteLine();
			StereoLibTesterProgram.Main(new string[] { rightImageFilename, leftImageFilename, numFrames.ToString(), numDisparities.ToString(), rightDispFilename, techniqueName, noiseLevel.ToString(), "flip" });
		}

		private static void RunLeftRightValidationAndEvaluation(string leftDispFilename, string rightDispFilename, int numFrames, int numDisparities, int dispScale, string leftCleanedFilename, string groundTruthFilename)
		{
			// set up topology and scheduler ------------------------------------------------------
			Topology topology = Topology.MainInstance;
			Scheduler scheduler = new SimpleDequeScheduler(topology);

			// set up nodes -----------------------------------------------------------------------

			// load input images
			var leftSource = new ImageSequenceSource(leftDispFilename) { FirstNumber = 1, LastNumber = numFrames };
			var rightSource = new ImageSequenceSource(rightDispFilename) { FirstNumber = 1, LastNumber = numFrames };

			// convert to float map
			var leftMap = new GreyToFloatNode() { ScaleFactor = numDisparities / 255.0f };
			var rightMap = new GreyToFloatNode() { ScaleFactor = numDisparities / 255.0f };
			topology.Connect(leftSource, new LibAvConvert(PixelFormat.RGB24), leftMap);
			topology.Connect(rightSource, new LibAvConvert(PixelFormat.RGB24), rightMap);

			// left-right consistency check
			var checker = new LeftRightValidationNode();
			topology.Connect(leftMap, checker["inL"]);
			topology.Connect(rightMap, checker["inR"]);

			// convert back to image
			topology.Connect(
				checker["outL"],
				new FloatToGreyNode() { ScaleFactor = dispScale },
				new ImageSequenceSink(leftCleanedFilename));

			// evaluation
			//var eval = new MiddleburyEvaluationNode() { MaskAllFilename = maskAllFilename, MaskDiscFilename = maskDiscFilename, MaskNonoccFilename = maskNonoccFilename };
			var eval = new MiddleburyEvaluationNode();
			topology.Connect(checker["outL"], eval["in_disparities"]);
			topology.Connect(
				new ImageSequenceSource(groundTruthFilename) { FirstNumber = 1, LastNumber = numFrames },
				new GreyToFloatNode() { ScaleFactor = 1.0f / dispScale },
				eval["in_groundtruth"]);

			// start the scheduler ----------------------------------------------------------------
			scheduler.Setup();
			scheduler.StartWorkers(4);
			scheduler.Join();
		}
	}
}
