#pragma once

#include "UnmanagedParameterTarget.h"
#include "StereoNodeFactory.h"

// Managed wrappers
namespace Stereo { namespace GpGpuLib {

// This terribly unsafe delegate method signature is due to the impossibility of creating
// generic delegates
delegate IParameterTarget^ CreateParams(void* client);

// This wrapper just encapsulates an additional managed delegate reference to a static method, provided to create the settings for each node
template<typename T>
ref class StereoNodeFactoryListNodeWrap
{
private:
	StereoNodeFactoryListNode<T>* pNode;
	StereoNodeFactoryListNodeWrap<T>^ next;
	CreateParams^ paramsCreator;

public:
	StereoNodeFactoryListNodeWrap(StereoNodeFactory<T>* theFactory, CreateParams^ paramProvider) : paramsCreator(paramProvider), next(nullptr)
	{ 
		pNode = new StereoNodeFactoryListNode<T>(theFactory); 
	}
	~StereoNodeFactoryListNodeWrap()
	{
		delete pNode;
		pNode = NULL;
		next = nullptr;
	}

	property StereoNodeFactoryListNodeWrap<T>^ Next
	{
		StereoNodeFactoryListNodeWrap<T>^ get() { return next; }
		void set(StereoNodeFactoryListNodeWrap<T>^ val) 
		{ 
			next = val; 
			pNode->pNext = val->Node;
		}
	}
	property StereoNodeFactoryListNode<T>* Node
	{
		StereoNodeFactoryListNode<T>* get() { return pNode; }
	}

	IParameterTarget^ CreateParams(T* client)
	{
		return paramsCreator(client);
	}
};

} }

// Creator methods which provide a list of all available nodes in each category
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<PreProcStereoNode>^ GetPreFactoriesManaged();
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<CostComputeStereoNode>^ GetCostFactoriesManaged();
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<CostAggregateStereoNode>^ GetAggregateFactoriesManaged();
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<GlobalOptStereoNode>^ GetOptFactoriesManaged();
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<WtaSolveStereoNode>^ GetWtaFactoriesManaged();
Stereo::GpGpuLib::StereoNodeFactoryListNodeWrap<GuidedGlobalOptStereoNode>^ GetGuidedOptFactoriesManaged();