﻿// $Id: NullPreProcessor.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Does not do any pre-processing.
	/// </summary>
	class NullPreProcessor : PreProcessorStereoNode
	{
		/// <summary>
		/// Initializes a new instance of the <see cref="NullPreProcessor"/> class.
		/// </summary>
		public NullPreProcessor() : base() { }

		/// <summary>
		/// Initializes a new instance of the <see cref="NullPreProcessor"/> class.
		/// </summary>
		/// <param name="theStream">The execution stream to run this node on.</param>
		public NullPreProcessor(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Pre-processes the given stereo image pair.
		/// </summary>
		/// <param name="leftImage">The left image.</param>
		/// <param name="rightImage">The right image.</param>
		public override void PreProcessImages(InputImage leftImage, InputImage rightImage)
		{
			// this space intentionally left blank
		}
	}

	/// <summary>
	/// Factory that produces a <see cref="NullPreProcessor"/>.
	/// </summary>
	class NullPreProcessorFactory : StereoNodeFactory<PreProcessorStereoNode>
	{
		/// <summary>
		/// Creates a <see cref="NullPreProcessor"/> to run on the specified execution stream.
		/// </summary>
		/// <param name="stream">The execution stream.</param>
		/// <returns>
		/// An instance of <see cref="PreProcessorStereoNode"/>.
		/// </returns>
		public override PreProcessorStereoNode Create(ExecutionStream stream)
		{
			return new NullPreProcessor(stream);
		}

		/// <summary>
		/// Checks if the <see cref="NullPreProcessor"/> is compatible with the given datatypes.
		/// </summary>
		/// <param name="imageType">Image datatype.</param>
		/// <param name="gridType">Cost space datatype.</param>
		/// <param name="mapType">Depth map datatype.</param>
		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = true; // always valid
		}

		/// <summary>
		/// Gets the name of this node.
		/// </summary>
		public override string Name { get { return "No pre-processing"; } }

		/// <summary>
		/// Gets the sort key. Should put this node first.
		/// </summary>
		public override string SortKey { get { return "_1_" + Name; } }
	}
}
