﻿// $Id: NaiveDcbAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.Parameters;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates cost using the dual-cross-bilateral filter.
	/// </summary>
	class NaiveDcbAggregator : AggregatorStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0, Maximum = 20, Default = 17, FriendlyName = "Window radius")]
		public int Radius { get; set; } 

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Colour sigma")]
		public int SigmaC { get; set; }

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Spatial sigma")]
		public int SigmaS { get; set; }

		#endregion

		public NaiveDcbAggregator() : base() { }
		public NaiveDcbAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunNaiveDcbKernel(costGrid, leftImage, rightImage, (uint)Radius, SigmaS, SigmaC, stream);
		}
	}

	class NaiveDcbAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new NaiveDcbAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "Full-kernel DCB"; }
		}

		public override string SortKey { get { return "_5_" + Name; } } // put this fifth
	}
}
