// $Id: ManagedUpsamplers.h 65 2010-03-18 17:06:22Z cr333 $
#pragma once

#include "InputImage.h"
#include "CostSpace.h"
#include "DepthMap.h"

namespace Stereo { namespace GpGpuLib {

public ref class ManagedUpsamplers
{
public:
	static void NnUpsample(DepthMap^ input, InputImage^ refImage, DepthMap^ output);
	static void JbUpsample(DepthMap^ input, InputImage^ refImage, float sigmaS, float sigmaC, DepthMap^ output);
    static void DcbUpsample(
        DepthMap^ input, int inputDisparities,
        InputImage^ leftImage, InputImage^ rightImage, CostSpace^ costSpace, InputImage^ tempGrid,
        DepthMap^ output, int outputDisparities,
        const float clipCosts, const float sigmaS, const float sigmaC, const unsigned int numInterations);
};

} }