/*
 * Decompiled with CFR 0.152.
 */
package isabelle.kodkodi;

import isabelle.kodkodi.ConsoleReporterV2;
import isabelle.kodkodi.Context;
import isabelle.kodkodi.ExternalSolverV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.Node;
import kodkod.ast.Relation;
import kodkod.ast.Variable;
import kodkod.ast.operator.ExprCastOperator;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.operator.IntCastOperator;
import kodkod.ast.operator.IntCompOperator;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.operator.Multiplicity;
import kodkod.engine.Solution;
import kodkod.engine.Solver;
import kodkod.engine.config.Options;
import kodkod.engine.config.Reporter;
import kodkod.engine.fol2sat.HigherOrderDeclException;
import kodkod.engine.fol2sat.UnboundLeafException;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.SATFactory;
import kodkod.engine.ucore.RCEStrategy;
import kodkod.instance.Bounds;
import kodkod.instance.Instance;
import kodkod.instance.Tuple;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;
import kodkod.util.ints.SparseSequence;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class KodkodiParser
extends Parser {
    public static final String[] tokenNames = new String[]{"<invalid>", "<EOR>", "<DOWN>", "<UP>", "SOLVER", "COLON", "STR_LITERAL", "COMMA", "SYMMETRY_BREAKING", "NUM", "SHARING", "BIT_WIDTH", "SKOLEM_DEPTH", "FLATTEN", "TRUE", "FALSE", "TIMEOUT", "DELAY", "UNIV", "UNIV_NAME", "TUPLE_SET_REG", "COLON_EQ", "TUPLE_REG", "BOUNDS", "RELATION_NAME", "BRACKET_LEFT", "BRACKET_RIGHT", "INT_BOUNDS", "FORMULA_REG", "REL_EXPR_REG", "INT_EXPR_REG", "SOLVE", "SEMICOLON", "PLUS", "MINUS", "AND", "ARROW", "OFFSET_UNIV_NAME", "PAREN_LEFT", "PAREN_RIGHT", "BRACE_LEFT", "DOT_DOT", "HASH", "BRACE_RIGHT", "NONE", "ALL", "ATOM_NAME", "TUPLE_NAME", "BAR", "SOME", "SUM", "LET", "IF", "THEN", "ELSE", "OR", "IFF", "IMPLIES", "NOT", "EQ", "LT", "LE", "GT", "GE", "IN", "ACYCLIC", "FUNCTION", "ONE", "LONE", "TOTAL_ORDERING", "SHL", "SHA", "SHR", "STAR", "DIVIDE", "MODULO", "HAT", "AMP", "OVERRIDE", "IFNO", "DOT", "VARIABLE_NAME", "IDEN", "INTS", "TILDE", "ABS", "SGN", "BITS", "INT", "NO", "SET", "NAT", "WHITESPACE", "INLINE_COMMENT", "BLOCK_COMMENT", "RELATION"};
    public static final int FUNCTION = 66;
    public static final int SHR = 72;
    public static final int BITS = 87;
    public static final int LT = 60;
    public static final int STAR = 73;
    public static final int SHL = 70;
    public static final int BRACE_RIGHT = 43;
    public static final int SHA = 71;
    public static final int ONE = 67;
    public static final int NOT = 58;
    public static final int EOF = -1;
    public static final int TUPLE_REG = 22;
    public static final int BRACKET_RIGHT = 26;
    public static final int PAREN_LEFT = 38;
    public static final int IDEN = 82;
    public static final int OFFSET_UNIV_NAME = 37;
    public static final int IFNO = 79;
    public static final int HAT = 76;
    public static final int SKOLEM_DEPTH = 12;
    public static final int INLINE_COMMENT = 93;
    public static final int SHARING = 10;
    public static final int BLOCK_COMMENT = 94;
    public static final int EQ = 59;
    public static final int DIVIDE = 74;
    public static final int TIMEOUT = 16;
    public static final int INTS = 83;
    public static final int IFF = 56;
    public static final int GE = 63;
    public static final int IMPLIES = 57;
    public static final int BRACKET_LEFT = 25;
    public static final int ELSE = 54;
    public static final int NO = 89;
    public static final int WHITESPACE = 92;
    public static final int SEMICOLON = 32;
    public static final int INT = 88;
    public static final int ACYCLIC = 65;
    public static final int TOTAL_ORDERING = 69;
    public static final int ABS = 85;
    public static final int UNIV = 18;
    public static final int STR_LITERAL = 6;
    public static final int BOUNDS = 23;
    public static final int SYMMETRY_BREAKING = 8;
    public static final int NONE = 44;
    public static final int BRACE_LEFT = 40;
    public static final int OR = 55;
    public static final int GT = 62;
    public static final int TUPLE_SET_REG = 20;
    public static final int FALSE = 15;
    public static final int SOLVE = 31;
    public static final int DELAY = 17;
    public static final int TUPLE_NAME = 47;
    public static final int AMP = 77;
    public static final int NAT = 91;
    public static final int AND = 35;
    public static final int SUM = 50;
    public static final int BIT_WIDTH = 11;
    public static final int IF = 52;
    public static final int RELATION_NAME = 24;
    public static final int VARIABLE_NAME = 81;
    public static final int THEN = 53;
    public static final int IN = 64;
    public static final int COMMA = 7;
    public static final int SOME = 49;
    public static final int ALL = 45;
    public static final int INT_BOUNDS = 27;
    public static final int TILDE = 84;
    public static final int PLUS = 33;
    public static final int DOT = 80;
    public static final int PAREN_RIGHT = 39;
    public static final int DOT_DOT = 41;
    public static final int MODULO = 75;
    public static final int COLON_EQ = 21;
    public static final int ATOM_NAME = 46;
    public static final int INT_EXPR_REG = 30;
    public static final int HASH = 42;
    public static final int RELATION = 95;
    public static final int SET = 90;
    public static final int REL_EXPR_REG = 29;
    public static final int MINUS = 34;
    public static final int TRUE = 14;
    public static final int NUM = 9;
    public static final int COLON = 5;
    public static final int UNIV_NAME = 19;
    public static final int SGN = 86;
    public static final int OVERRIDE = 78;
    public static final int FLATTEN = 13;
    public static final int ARROW = 36;
    public static final int SOLVER = 4;
    public static final int BAR = 48;
    public static final int LET = 51;
    public static final int LE = 61;
    public static final int FORMULA_REG = 28;
    public static final int LONE = 68;
    Context context;
    boolean verbose;
    int maxSolutions;
    boolean solveAll;
    boolean prove;
    boolean cleanUpInst;
    Lexer lexer;
    int problemNo = 0;
    long startParsingTime;
    Options options;
    int timeout = 0;
    int delay = 0;
    Universe universe;
    TupleFactory factory;
    Bounds bounds;
    ExecutorService executor = null;
    int nextInt;
    HashMap<Integer, Relation> atomRelations;
    HashMap<Integer, Relation> univRelations;
    Relation[] smallSets = new Relation[10];
    Vector<Vector<Relation>> relations = new Vector();
    Vector<Vector<Variable>> variables = new Vector();
    Vector<Vector<TupleSet>> tupleSets;
    Vector<Vector<Tuple>> tuples;
    Vector<Expression> exprs;
    Vector<IntExpression> intExprs;
    Vector<Formula> formulas;
    HashMap<Integer, IntConstant> intConstants = new HashMap();
    StringBuilder bigBuf = null;
    private final int OFFSET_LIMIT = 65536;
    private final int CARD_LIMIT = 65536;
    public static final BitSet FOLLOW_problem_in_problems60 = new BitSet(new long[]{474386L});
    public static final BitSet FOLLOW_option_in_problem87 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_univ_spec_in_problem98 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_tuple_reg_directive_in_problem108 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_bound_spec_in_problem119 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_int_bound_spec_in_problem130 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_expr_reg_directive_in_problem141 = new BitSet(new long[]{4174855440L});
    public static final BitSet FOLLOW_solve_directive_in_problem152 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SOLVER_in_option170 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option172 = new BitSet(new long[]{64L});
    public static final BitSet FOLLOW_STR_LITERAL_in_option178 = new BitSet(new long[]{130L});
    public static final BitSet FOLLOW_COMMA_in_option191 = new BitSet(new long[]{64L});
    public static final BitSet FOLLOW_STR_LITERAL_in_option197 = new BitSet(new long[]{130L});
    public static final BitSet FOLLOW_SYMMETRY_BREAKING_in_option215 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option217 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option223 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SHARING_in_option237 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option239 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option245 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BIT_WIDTH_in_option259 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option261 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option267 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SKOLEM_DEPTH_in_option281 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option283 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option289 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FLATTEN_in_option303 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option305 = new BitSet(new long[]{49152L});
    public static final BitSet FOLLOW_set_in_option311 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TIMEOUT_in_option331 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option333 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option339 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_DELAY_in_option353 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_option355 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_option361 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_UNIV_in_univ_spec377 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_univ_spec379 = new BitSet(new long[]{524288L});
    public static final BitSet FOLLOW_UNIV_NAME_in_univ_spec385 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TUPLE_SET_REG_in_tuple_reg_directive405 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_tuple_reg_directive411 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_tuple_set_in_tuple_reg_directive417 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TUPLE_REG_in_tuple_reg_directive436 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_tuple_reg_directive442 = new BitSet(new long[]{211106270281728L});
    public static final BitSet FOLLOW_tuple_in_tuple_reg_directive448 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BOUNDS_in_bound_spec469 = new BitSet(new long[]{0x1000000L});
    public static final BitSet FOLLOW_RELATION_NAME_in_bound_spec475 = new BitSet(new long[]{160L});
    public static final BitSet FOLLOW_COMMA_in_bound_spec488 = new BitSet(new long[]{0x1000000L});
    public static final BitSet FOLLOW_RELATION_NAME_in_bound_spec494 = new BitSet(new long[]{160L});
    public static final BitSet FOLLOW_COLON_in_bound_spec512 = new BitSet(new long[]{54288421748736L});
    public static final BitSet FOLLOW_tuple_set_in_bound_spec527 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_bound_spec541 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_tuple_set_in_bound_spec547 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_COMMA_in_bound_spec559 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_tuple_set_in_bound_spec565 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_bound_spec568 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INT_BOUNDS_in_int_bound_spec585 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_int_bound_spec587 = new BitSet(new long[]{0x2000200L});
    public static final BitSet FOLLOW_int_bound_seq_in_int_bound_spec593 = new BitSet(new long[]{130L});
    public static final BitSet FOLLOW_COMMA_in_int_bound_spec596 = new BitSet(new long[]{0x2000200L});
    public static final BitSet FOLLOW_int_bound_seq_in_int_bound_spec602 = new BitSet(new long[]{130L});
    public static final BitSet FOLLOW_FORMULA_REG_in_expr_reg_directive622 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_expr_reg_directive624 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr_reg_directive630 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_REL_EXPR_REG_in_expr_reg_directive648 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_expr_reg_directive650 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr_reg_directive656 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INT_EXPR_REG_in_expr_reg_directive674 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_expr_reg_directive676 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr_reg_directive682 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SOLVE_in_solve_directive702 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_solve_directive708 = new BitSet(new long[]{0x100000000L});
    public static final BitSet FOLLOW_SEMICOLON_in_solve_directive710 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NUM_in_int_bound_seq732 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_int_bound_seq734 = new BitSet(new long[]{0x2000200L});
    public static final BitSet FOLLOW_tuple_set_seq_in_int_bound_seq742 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_tuple_set_seq773 = new BitSet(new long[]{54288455303168L});
    public static final BitSet FOLLOW_tuple_set_in_tuple_set_seq780 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_COMMA_in_tuple_set_seq786 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_tuple_set_in_tuple_set_seq792 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_tuple_set_seq808 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_intersect_tuple_set_in_tuple_set832 = new BitSet(new long[]{0x600000002L});
    public static final BitSet FOLLOW_set_in_tuple_set850 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_intersect_tuple_set_in_tuple_set862 = new BitSet(new long[]{0x600000002L});
    public static final BitSet FOLLOW_product_tuple_set_in_intersect_tuple_set890 = new BitSet(new long[]{0x800000002L});
    public static final BitSet FOLLOW_AND_in_intersect_tuple_set908 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_product_tuple_set_in_intersect_tuple_set914 = new BitSet(new long[]{0x800000002L});
    public static final BitSet FOLLOW_project_tuple_set_in_product_tuple_set942 = new BitSet(new long[]{0x1000000002L});
    public static final BitSet FOLLOW_ARROW_in_product_tuple_set960 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_project_tuple_set_in_product_tuple_set966 = new BitSet(new long[]{0x1000000002L});
    public static final BitSet FOLLOW_basic_tuple_set_in_project_tuple_set994 = new BitSet(new long[]{0x2000002L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_project_tuple_set1008 = new BitSet(new long[]{512L});
    public static final BitSet FOLLOW_NUM_in_project_tuple_set1014 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_project_tuple_set1016 = new BitSet(new long[]{0x2000002L});
    public static final BitSet FOLLOW_set_in_basic_tuple_set1050 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_basic_tuple_set1070 = new BitSet(new long[]{54288388194304L});
    public static final BitSet FOLLOW_tuple_set_in_basic_tuple_set1076 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_basic_tuple_set1081 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACE_LEFT_in_basic_tuple_set1097 = new BitSet(new long[]{219902363303936L});
    public static final BitSet FOLLOW_tuple_in_basic_tuple_set1112 = new BitSet(new long[]{0xE0000000080L});
    public static final BitSet FOLLOW_COMMA_in_basic_tuple_set1128 = new BitSet(new long[]{211106270281728L});
    public static final BitSet FOLLOW_tuple_in_basic_tuple_set1134 = new BitSet(new long[]{0x80000000080L});
    public static final BitSet FOLLOW_DOT_DOT_in_basic_tuple_set1159 = new BitSet(new long[]{211106270281728L});
    public static final BitSet FOLLOW_tuple_in_basic_tuple_set1165 = new BitSet(new long[]{0x80000000000L});
    public static final BitSet FOLLOW_HASH_in_basic_tuple_set1186 = new BitSet(new long[]{211106270281728L});
    public static final BitSet FOLLOW_tuple_in_basic_tuple_set1192 = new BitSet(new long[]{0x80000000000L});
    public static final BitSet FOLLOW_BRACE_RIGHT_in_basic_tuple_set1220 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NONE_in_basic_tuple_set1236 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ALL_in_basic_tuple_set1254 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TUPLE_SET_REG_in_basic_tuple_set1272 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_tuple1293 = new BitSet(new long[]{0x400000000000L});
    public static final BitSet FOLLOW_ATOM_NAME_in_tuple1299 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_COMMA_in_tuple1304 = new BitSet(new long[]{0x400000000000L});
    public static final BitSet FOLLOW_ATOM_NAME_in_tuple1310 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_tuple1316 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ATOM_NAME_in_tuple1334 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TUPLE_NAME_in_tuple1352 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TUPLE_REG_in_tuple1370 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ALL_in_expr1391 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_decls_in_expr1397 = new BitSet(new long[]{0x1000000000000L});
    public static final BitSet FOLLOW_BAR_in_expr1403 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1409 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SOME_in_expr1423 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_decls_in_expr1429 = new BitSet(new long[]{0x1000000000000L});
    public static final BitSet FOLLOW_BAR_in_expr1435 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1441 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SUM_in_expr1455 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_decls_in_expr1461 = new BitSet(new long[]{0x1000000000000L});
    public static final BitSet FOLLOW_BAR_in_expr1467 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1473 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LET_in_expr1491 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_assigns_in_expr1497 = new BitSet(new long[]{0x1000000000000L});
    public static final BitSet FOLLOW_BAR_in_expr1499 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1505 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_IF_in_expr1523 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1529 = new BitSet(new long[]{0x20000000000000L});
    public static final BitSet FOLLOW_THEN_in_expr1535 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1541 = new BitSet(new long[]{0x40000000000000L});
    public static final BitSet FOLLOW_ELSE_in_expr1547 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr1553 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_iff_formula_in_expr1571 = new BitSet(new long[]{0x80000000000002L});
    public static final BitSet FOLLOW_OR_in_expr1588 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_or_formula_tail_in_expr1594 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_iff_formula_in_or_formula_tail1635 = new BitSet(new long[]{0x80000000000002L});
    public static final BitSet FOLLOW_OR_in_or_formula_tail1648 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_or_formula_tail_in_or_formula_tail1654 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_implies_formula_in_iff_formula1693 = new BitSet(new long[]{0x100000000000002L});
    public static final BitSet FOLLOW_IFF_in_iff_formula1710 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_implies_formula_in_iff_formula1716 = new BitSet(new long[]{0x100000000000002L});
    public static final BitSet FOLLOW_and_formula_in_implies_formula1742 = new BitSet(new long[]{0x200000000000002L});
    public static final BitSet FOLLOW_IMPLIES_in_implies_formula1759 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_implies_formula_in_implies_formula1765 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_basic_formula_in_and_formula1791 = new BitSet(new long[]{0x800000002L});
    public static final BitSet FOLLOW_AND_in_and_formula1808 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_and_formula_tail_in_and_formula1814 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_basic_formula_in_and_formula_tail1855 = new BitSet(new long[]{0x800000002L});
    public static final BitSet FOLLOW_AND_in_and_formula_tail1868 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_and_formula_tail_in_and_formula_tail1874 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NOT_in_basic_formula1913 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_basic_formula_in_basic_formula1919 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_predicate_formula_in_basic_formula1937 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_shift_expr_in_basic_formula1955 = new BitSet(new long[]{-576460752303423486L, 1L});
    public static final BitSet FOLLOW_set_in_basic_formula1970 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_shift_expr_in_basic_formula1998 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_multiplicity_in_basic_formula2021 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_add_expr_in_basic_formula2027 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ACYCLIC_in_predicate_formula2051 = new BitSet(new long[]{0x4000000000L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_predicate_formula2053 = new BitSet(new long[]{0x1000000L});
    public static final BitSet FOLLOW_RELATION_NAME_in_predicate_formula2059 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_predicate_formula2061 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FUNCTION_in_predicate_formula2079 = new BitSet(new long[]{0x4000000000L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_predicate_formula2081 = new BitSet(new long[]{0x1000000L});
    public static final BitSet FOLLOW_RELATION_NAME_in_predicate_formula2087 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_COMMA_in_predicate_formula2093 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_predicate_formula2099 = new BitSet(new long[]{0x1000000000L});
    public static final BitSet FOLLOW_ARROW_in_predicate_formula2101 = new BitSet(new long[]{0L, 24L});
    public static final BitSet FOLLOW_set_in_predicate_formula2115 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_predicate_formula2127 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_predicate_formula2129 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TOTAL_ORDERING_in_predicate_formula2147 = new BitSet(new long[]{0x4000000000L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_predicate_formula2149 = new BitSet(new long[]{0x1000000L});
    public static final BitSet FOLLOW_RELATION_NAME_in_predicate_formula2155 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_COMMA_in_predicate_formula2157 = new BitSet(new long[]{137456254976L});
    public static final BitSet FOLLOW_set_in_predicate_formula2171 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_COMMA_in_predicate_formula2183 = new BitSet(new long[]{0x400001000000L});
    public static final BitSet FOLLOW_set_in_predicate_formula2197 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_COMMA_in_predicate_formula2205 = new BitSet(new long[]{0x400001000000L});
    public static final BitSet FOLLOW_set_in_predicate_formula2211 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_predicate_formula2227 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_add_expr_in_shift_expr2251 = new BitSet(new long[]{2L, 448L});
    public static final BitSet FOLLOW_set_in_shift_expr2268 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_add_expr_in_shift_expr2284 = new BitSet(new long[]{2L, 448L});
    public static final BitSet FOLLOW_mult_expr_in_add_expr2310 = new BitSet(new long[]{0x600000002L});
    public static final BitSet FOLLOW_set_in_add_expr2327 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_mult_expr_in_add_expr2339 = new BitSet(new long[]{0x600000002L});
    public static final BitSet FOLLOW_expr_to_int_cast_in_mult_expr2365 = new BitSet(new long[]{2L, 3584L});
    public static final BitSet FOLLOW_set_in_mult_expr2382 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_expr_to_int_cast_in_mult_expr2398 = new BitSet(new long[]{2L, 3584L});
    public static final BitSet FOLLOW_set_in_expr_to_int_cast2424 = new BitSet(new long[]{0x4000000000L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_expr_to_int_cast2432 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_expr_to_int_cast2438 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_expr_to_int_cast2440 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_product_expr_in_expr_to_int_cast2458 = new BitSet(new long[]{0x1000000000002L, 28672L});
    public static final BitSet FOLLOW_set_in_expr_to_int_cast2475 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_product_expr_in_expr_to_int_cast2491 = new BitSet(new long[]{0x1000000000002L, 28672L});
    public static final BitSet FOLLOW_OVERRIDE_in_expr_to_int_cast2502 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_expr_to_int_cast_in_expr_to_int_cast2508 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ifno_expr_in_product_expr2534 = new BitSet(new long[]{0x1000000002L});
    public static final BitSet FOLLOW_ARROW_in_product_expr2551 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_product_expr_tail_in_product_expr2557 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ifno_expr_in_product_expr_tail2598 = new BitSet(new long[]{0x1000000002L});
    public static final BitSet FOLLOW_ARROW_in_product_expr_tail2611 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_product_expr_tail_in_product_expr_tail2617 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_apply_expr_in_ifno_expr2656 = new BitSet(new long[]{2L, 32768L});
    public static final BitSet FOLLOW_IFNO_in_ifno_expr2673 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_apply_expr_in_ifno_expr2679 = new BitSet(new long[]{2L, 32768L});
    public static final BitSet FOLLOW_project_expr_in_apply_expr2705 = new BitSet(new long[]{0x4000000002L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_apply_expr2722 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_apply_expr2728 = new BitSet(new long[]{0x8000000080L});
    public static final BitSet FOLLOW_COMMA_in_apply_expr2733 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_apply_expr2739 = new BitSet(new long[]{0x8000000080L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_apply_expr2745 = new BitSet(new long[]{0x4000000002L});
    public static final BitSet FOLLOW_basic_expr_in_project_expr2769 = new BitSet(new long[]{0x2000002L, 65536L});
    public static final BitSet FOLLOW_DOT_in_project_expr2786 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_basic_expr_in_project_expr2792 = new BitSet(new long[]{0x2000002L, 65536L});
    public static final BitSet FOLLOW_project_columns_in_project_expr2803 = new BitSet(new long[]{0x2000002L});
    public static final BitSet FOLLOW_PAREN_LEFT_in_basic_expr2825 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_basic_expr2831 = new BitSet(new long[]{0x8000000000L});
    public static final BitSet FOLLOW_PAREN_RIGHT_in_basic_expr2833 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_basic_expr2851 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_VARIABLE_NAME_in_basic_expr2895 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FORMULA_REG_in_basic_expr2913 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_REL_EXPR_REG_in_basic_expr2931 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INT_EXPR_REG_in_basic_expr2949 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NUM_in_basic_expr2967 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FALSE_in_basic_expr2981 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TRUE_in_basic_expr2995 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_IDEN_in_basic_expr3009 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INTS_in_basic_expr3023 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NONE_in_basic_expr3037 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_UNIV_in_basic_expr3051 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_basic_expr3069 = new BitSet(new long[]{1219789788594688L, 33427968L});
    public static final BitSet FOLLOW_basic_expr_in_basic_expr3097 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACE_LEFT_in_basic_expr3111 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_decls_in_basic_expr3117 = new BitSet(new long[]{0x1000000000000L});
    public static final BitSet FOLLOW_BAR_in_basic_expr3123 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_basic_expr3129 = new BitSet(new long[]{0x80000000000L});
    public static final BitSet FOLLOW_BRACE_RIGHT_in_basic_expr3131 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_basic_expr3149 = new BitSet(new long[]{0x2000000L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_basic_expr3157 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_basic_expr3163 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_basic_expr3165 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_decls3186 = new BitSet(new long[]{0x4000000L, 131072L});
    public static final BitSet FOLLOW_decl_in_decls3201 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_COMMA_in_decls3215 = new BitSet(new long[]{0L, 131072L});
    public static final BitSet FOLLOW_decl_in_decls3221 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_decls3237 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_VARIABLE_NAME_in_decl3259 = new BitSet(new long[]{32L});
    public static final BitSet FOLLOW_COLON_in_decl3265 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_multiplicity_in_decl3271 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_decl3277 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_assigns3297 = new BitSet(new long[]{0x70000000L});
    public static final BitSet FOLLOW_assign_in_assigns3299 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_COMMA_in_assigns3311 = new BitSet(new long[]{0x70000000L});
    public static final BitSet FOLLOW_assign_in_assigns3313 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_assigns3318 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_FORMULA_REG_in_assign3339 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_assign3345 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_assign3351 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_REL_EXPR_REG_in_assign3369 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_assign3375 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_assign3381 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INT_EXPR_REG_in_assign3399 = new BitSet(new long[]{0x200000L});
    public static final BitSet FOLLOW_COLON_EQ_in_assign3405 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_assign3411 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_multiplicity3435 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_BRACKET_LEFT_in_project_columns3484 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_project_columns3490 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_COMMA_in_project_columns3499 = new BitSet(new long[]{296803699706872320L, 134091326L});
    public static final BitSet FOLLOW_expr_in_project_columns3505 = new BitSet(new long[]{0x4000080L});
    public static final BitSet FOLLOW_BRACKET_RIGHT_in_project_columns3519 = new BitSet(new long[]{2L});

    public KodkodiParser(TokenStream tokenStream) {
        this(tokenStream, new RecognizerSharedState());
    }

    public KodkodiParser(TokenStream tokenStream, RecognizerSharedState recognizerSharedState) {
        super(tokenStream, recognizerSharedState);
    }

    public String[] getTokenNames() {
        return tokenNames;
    }

    public String getGrammarFileName() {
        return "src/Kodkodi.g";
    }

    public final void reset() {
        this.options = null;
    }

    public final void ensure() {
        if (this.options != null) {
            return;
        }
        ++this.problemNo;
        this.startParsingTime = System.currentTimeMillis();
        ConsoleReporterV2 consoleReporterV2 = new ConsoleReporterV2(){

            @Override
            void output(String string) {
                KodkodiParser.this.context.output(string);
            }
        };
        consoleReporterV2.setProblemNo(this.problemNo);
        consoleReporterV2.setPrintsTimestamps(true);
        consoleReporterV2.println("parsing...");
        this.options = new Options();
        this.options.setReporter((Reporter)consoleReporterV2);
        this.timeout = 0;
        this.delay = 0;
        this.universe = null;
        this.factory = null;
        this.bounds = null;
        this.nextInt = 0;
        this.atomRelations = new HashMap();
        this.univRelations = new HashMap();
        this.tupleSets = new Vector();
        this.tuples = new Vector();
        this.exprs = new Vector();
        this.intExprs = new Vector();
        this.formulas = new Vector();
        if (this.bigBuf == null) {
            this.bigBuf = new StringBuilder();
        }
    }

    public static final KodkodiParser create(Context context, ExecutorService executorService, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, Lexer lexer) {
        KodkodiParser kodkodiParser = new KodkodiParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        kodkodiParser.context = context;
        kodkodiParser.executor = executorService;
        kodkodiParser.verbose = bl;
        kodkodiParser.solveAll = bl2;
        kodkodiParser.prove = bl3;
        kodkodiParser.maxSolutions = n;
        kodkodiParser.cleanUpInst = bl4;
        kodkodiParser.lexer = lexer;
        return kodkodiParser;
    }

    public final void emitErrorMessage(String string) {
        this.context.error(string);
    }

    private static final String fixedMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(throwable.getMessage());
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '.') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private final void setTuple(Token token, Tuple tuple) {
        String string = token.getText();
        int n = this.arity(string);
        int n2 = this.id(string);
        if (n >= this.tuples.size()) {
            int n3 = this.tuples.size();
            this.tuples.setSize(n + 1);
            for (int i = n3; i <= n; ++i) {
                this.tuples.setElementAt(new Vector(), i);
            }
        }
        if (n2 >= this.tuples.elementAt(n).size()) {
            this.tuples.elementAt(n).setSize(n2 + 1);
        }
        this.tuples.elementAt(n).setElementAt(tuple, n2);
    }

    private final void setTupleSet(Token token, TupleSet tupleSet) {
        String string = token.getText();
        int n = this.arity(string);
        int n2 = this.id(string);
        if (n >= this.tupleSets.size()) {
            int n3 = this.tupleSets.size();
            this.tupleSets.setSize(n + 1);
            for (int i = n3; i <= n; ++i) {
                this.tupleSets.setElementAt(new Vector(), i);
            }
        }
        if (n2 >= this.tupleSets.elementAt(n).size()) {
            this.tupleSets.elementAt(n).setSize(n2 + 1);
        }
        this.tupleSets.elementAt(n).setElementAt(tupleSet, n2);
    }

    private final void setFormulaReg(Token token, Formula formula) {
        int n = this.id(token.getText());
        if (n >= this.formulas.size()) {
            this.formulas.setSize(n + 1);
        }
        this.formulas.setElementAt(formula, n);
    }

    private final void setExprReg(Token token, Expression expression) {
        int n = this.id(token.getText());
        if (n >= this.exprs.size()) {
            this.exprs.setSize(n + 1);
        }
        this.exprs.setElementAt(expression, n);
    }

    private final void setIntExprReg(Token token, IntExpression intExpression) {
        int n = this.id(token.getText());
        if (n >= this.intExprs.size()) {
            this.intExprs.setSize(n + 1);
        }
        this.intExprs.setElementAt(intExpression, n);
    }

    private final void setReg(Token token, Node node) {
        switch (token.getText().charAt(1)) {
            case 'f': {
                this.setFormulaReg(token, (Formula)node);
                break;
            }
            case 'e': {
                this.setExprReg(token, (Expression)node);
                break;
            }
            case 'i': {
                this.setIntExprReg(token, (IntExpression)node);
                break;
            }
            default: {
                this.panic();
            }
        }
    }

    private final TupleSet univTupleSet(Token token, int n) {
        int n2 = this.card(n);
        int n3 = this.offset(n);
        if (n2 == 0) {
            return this.factory.noneOf(1);
        }
        if (n2 + n3 > this.universe.size()) {
            this.huh(token, "universe too small for '" + token.getText() + "'");
            return this.factory.noneOf(1);
        }
        return this.factory.range(this.factory.tuple(new Object[]{this.universe.atom(n3)}), this.factory.tuple(new Object[]{this.universe.atom(n2 + n3 - 1)}));
    }

    private final Object getAtom(Token token) {
        String string = token.getText();
        try {
            return this.universe.atom(this.id(string));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.huh(token, "atom '" + string + "' not in universe");
            return this.universe.atom(0);
        }
    }

    private final Relation getRelation(Token token) {
        int n;
        String string = token.getText();
        int n2 = 1;
        Relation relation = null;
        if (string.charAt(0) == 'A') {
            int n3 = this.id(string);
            relation = this.atomRelations.get(n3);
            if (relation == null) {
                relation = Relation.nary((String)string, (int)1);
                try {
                    this.bounds.boundExactly(relation, this.factory.setOf(new Object[]{this.universe.atom(n3)}));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.huh(token, "atom '" + string + "' not in universe");
                }
                this.atomRelations.put(n3, relation);
            }
            return relation;
        }
        if (string.charAt(0) == 'u') {
            int n4 = this.id(string);
            relation = this.univRelations.get(n4);
            if (relation == null) {
                relation = Relation.nary((String)string, (int)1);
                this.bounds.boundExactly(relation, this.univTupleSet(token, n4));
                this.univRelations.put(n4, relation);
            }
            return relation;
        }
        if (string.charAt(0) == 's' && string.length() == 2) {
            n = string.charAt(1) - 48;
            relation = this.smallSets[n];
            if (relation != null) {
                return relation;
            }
        } else {
            n2 = this.arity(string);
            n = this.id(string);
        }
        if (n2 < this.relations.size() && n < this.relations.elementAt(n2).size()) {
            relation = this.relations.elementAt(n2).elementAt(n);
        } else {
            if (n2 >= this.relations.size()) {
                int n5 = this.relations.size();
                this.relations.setSize(n2 + 1);
                for (int i = n5; i <= n2; ++i) {
                    this.relations.setElementAt(new Vector(), i);
                }
            }
            this.relations.elementAt(n2).setSize(n + 1);
        }
        if (relation == null) {
            relation = Relation.nary((String)string, (int)n2);
            this.relations.elementAt(n2).setElementAt(relation, n);
            if (n2 == 1 && n < 10) {
                this.smallSets[n] = relation;
            }
        }
        return relation;
    }

    private final Variable getVariable(Token token) {
        String string = token.getText();
        int n = this.arity(string);
        int n2 = this.id(string);
        Variable variable = null;
        if (n < this.variables.size() && n2 < this.variables.elementAt(n).size()) {
            variable = this.variables.elementAt(n).elementAt(n2);
        } else {
            if (n >= this.variables.size()) {
                int n3 = this.variables.size();
                this.variables.setSize(n + 1);
                for (int i = n3; i <= n; ++i) {
                    this.variables.setElementAt(new Vector(), i);
                }
            }
            this.variables.elementAt(n).setSize(n2 + 1);
        }
        if (variable == null) {
            variable = Variable.nary((String)string, (int)n);
            this.variables.elementAt(n).setElementAt(variable, n2);
        }
        return variable;
    }

    private final TupleSet getTupleSet(Token token) {
        String string = token.getText();
        int n = this.arity(string);
        int n2 = this.id(string);
        if (n < this.tupleSets.size() && n2 < this.tupleSets.elementAt(n).size()) {
            return this.tupleSets.elementAt(n).elementAt(n2);
        }
        this.huh(token, "No such tuple set '" + string + "'");
        return this.factory.noneOf(n);
    }

    private final Tuple getTuple(Token token) {
        String string = token.getText();
        int n = this.arity(string);
        int n2 = this.id(string);
        if (n < this.tuples.size() && n2 < this.tuples.elementAt(n).size()) {
            return this.tuples.elementAt(n).elementAt(n2);
        }
        this.huh(token, "No such tuple '" + string + "'");
        return this.factory.tuple(1, 0);
    }

    private final Formula getFormulaReg(Token token) {
        String string = token.getText();
        try {
            Formula formula = this.formulas.elementAt(this.id(string));
            if (formula != null) {
                return formula;
            }
            this.huh(token, "No such formula '" + string + "'");
            return Formula.FALSE;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.huh(token, "No such formula '" + string + "'");
            return Formula.FALSE;
        }
    }

    private final Expression getExprReg(Token token) {
        String string = token.getText();
        try {
            Expression expression = this.exprs.elementAt(this.id(string));
            if (expression != null) {
                return expression;
            }
            this.huh(token, "No such relational expression '" + string + "'");
            return Expression.NONE;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.huh(token, "No such relational expression '" + string + "'");
            return Expression.NONE;
        }
    }

    private final IntExpression getIntExprReg(Token token) {
        String string = token.getText();
        try {
            IntExpression intExpression = this.intExprs.elementAt(this.id(token.getText()));
            if (intExpression != null) {
                return intExpression;
            }
            this.huh(token, "No such integer expression '" + string + "'");
            return IntConstant.constant((int)0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.huh(token, "No such integer expression '" + string + "'");
            return IntConstant.constant((int)0);
        }
    }

    private final IntConstant getIntConstant(Token token) {
        int n = this.getInt(token);
        IntConstant intConstant = this.intConstants.get(n);
        if (intConstant == null) {
            intConstant = IntConstant.constant((int)n);
            this.intConstants.put(n, intConstant);
        }
        return intConstant;
    }

    private final int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.huh(Token.INVALID_TOKEN, "integer '" + string + "' out of range");
            return 0;
        }
    }

    private final int getInt(Token token) {
        return this.getInt(token, token.getText());
    }

    private final int getInt(Token token, String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.huh(token, "integer '" + string + "' out of range");
            return 0;
        }
    }

    private final void huh(Token token, String string) {
        SemanticException semanticException = new SemanticException(token, string);
        this.reportError(semanticException);
    }

    private final void panic() {
        Exception exception = new Exception();
        this.context.error("this cannot happen");
        exception.printStackTrace();
        this.context.exit(1);
    }

    private final int arity(String string) {
        int n = 0;
        if (string.charAt(0) == '$') {
            ++n;
        }
        switch (string.charAt(n)) {
            case 'A': 
            case 'S': 
            case 'a': 
            case 's': 
            case 'u': {
                return 1;
            }
            case 'P': 
            case 'R': 
            case 'p': 
            case 'r': {
                return 2;
            }
            case 'M': 
            case 'T': 
            case 'm': 
            case 't': {
                int n2 = string.indexOf(95);
                if (n2 < 0) break;
                int n3 = this.getInt(string.substring(n + 1, n2));
                if (n3 >= 3) {
                    return n3;
                }
                this.huh(Token.INVALID_TOKEN, "expected arity 3 or more, got " + n3);
                return 3;
            }
        }
        this.panic();
        return 0;
    }

    private final int universeId(int n, int n2) {
        if (n < 0 || n >= 65536) {
            this.huh(Token.INVALID_TOKEN, "expected reasonable cardinality, got '" + n + "'");
            return 0;
        }
        if (n2 < 0 || n2 >= 65536) {
            this.huh(Token.INVALID_TOKEN, "expected reasonable offset, got '" + n2 + "'");
            return 0;
        }
        return n2 * 65536 + n;
    }

    private final int card(int n) {
        return n % 65536;
    }

    private final int offset(int n) {
        return n / 65536;
    }

    private final int id(String string) {
        int n;
        int n2 = 0;
        if (string.charAt(0) == '$') {
            ++n2;
        }
        if ((n = string.indexOf(95)) == -1) {
            n = n2;
        }
        switch (string.charAt(n2)) {
            case 'A': 
            case 'P': 
            case 'T': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'i': 
            case 'p': 
            case 't': {
                int n3 = this.getInt(string.substring(n + 1));
                if (n3 >= 0) {
                    return n3;
                }
                this.huh(Token.INVALID_TOKEN, "expected nonnegative ID, got '" + n3 + "'");
                return 0;
            }
            case 'M': 
            case 'R': 
            case 'S': 
            case 'm': 
            case 'r': 
            case 's': {
                int n4;
                if (string.endsWith("'")) {
                    int n5 = this.getInt(string.substring(n + 1, string.length() - 1));
                    n4 = 2 * n5 + 1;
                } else {
                    int n6 = this.getInt(string.substring(n + 1));
                    n4 = 2 * n6;
                }
                if (n4 >= 0) {
                    return n4;
                }
                this.huh(Token.INVALID_TOKEN, "expected nonnegative ID, got '" + n4 + "'");
                return 0;
            }
            case 'u': {
                int n7;
                int n8 = string.indexOf(64);
                int n9 = 0;
                if (n8 >= 0) {
                    n7 = this.getInt(string.substring(n + 1, n8));
                    n9 = this.getInt(string.substring(n8 + 1));
                } else {
                    n7 = this.getInt(string.substring(n + 1));
                }
                return this.universeId(n7, n9);
            }
        }
        this.panic();
        return 0;
    }

    private final String sstr(Token token) {
        String string = token.getText();
        if (string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        this.panic();
        return "";
    }

    private final Formula F(Token token, Object object) {
        try {
            return (Formula)object;
        }
        catch (ClassCastException classCastException) {
            this.huh(token, "expected formula");
            return Formula.FALSE;
        }
    }

    private final Expression E(Token token, Object object) {
        try {
            return (Expression)object;
        }
        catch (ClassCastException classCastException) {
            this.huh(token, "expected relational expression");
            return Expression.NONE;
        }
    }

    private final IntExpression I(Token token, Object object) {
        try {
            return (IntExpression)object;
        }
        catch (ClassCastException classCastException) {
            this.huh(token, "expected integer expression");
            return IntConstant.constant((int)0);
        }
    }

    private static final boolean isExpression(Object object) {
        try {
            Expression expression = (Expression)object;
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private static final boolean isIntExpression(Object object) {
        try {
            IntExpression intExpression = (IntExpression)object;
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private static final boolean isRealRelation(Relation relation) {
        switch (relation.name().charAt(0)) {
            case 'm': 
            case 'r': 
            case 's': {
                return true;
            }
        }
        return false;
    }

    private static final Instance cleanedUpInstance(Instance instance, Bounds bounds, boolean bl) {
        int[] nArray;
        Relation relation2;
        Instance instance2 = new Instance(bounds.universe());
        Set set = instance.relations();
        Map map = bounds.lowerBounds();
        Map map2 = bounds.upperBounds();
        Map map3 = instance.relationTuples();
        for (Relation relation2 : set) {
            if ((!bl || ((TupleSet)map.get(relation2)).equals(map2.get(relation2))) && !KodkodiParser.isRealRelation(relation2)) continue;
            instance2.add(relation2, (TupleSet)map3.get(relation2));
        }
        SparseSequence sparseSequence = bounds.intBounds();
        relation2 = instance.intTuples();
        for (int n : nArray = relation2.indices().toArray()) {
            TupleSet tupleSet = (TupleSet)relation2.get(n);
            if (((TupleSet)sparseSequence.get(n)).equals((Object)tupleSet)) continue;
            instance2.add(n, tupleSet);
        }
        return instance2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void solve(Token token, int n, long l, Options options, int n2, int n3, Universe universe, Bounds bounds, Formula formula) {
        boolean bl;
        block37: {
            Solver solver = new Solver(options);
            bl = false;
            if (this.prove) {
                options.setLogTranslation(2);
                options.setCoreGranularity(0);
            }
            try {
                Solution solution;
                boolean bl2 = false;
                ((ConsoleReporterV2)options.reporter()).println("kodkoding...");
                Vector vector = new Vector();
                if (this.solveAll) {
                    int n4 = this.maxSolutions;
                    Iterator iterator = solver.solveAll(formula, bounds);
                    if (iterator.hasNext() && n4-- > 0) {
                        vector.add(iterator.next());
                        while (iterator.hasNext()) {
                            solution = (Solution)iterator.next();
                            if (solution.outcome() == Solution.Outcome.UNSATISFIABLE || n4-- <= 0) continue;
                            vector.add(solution);
                        }
                    }
                } else {
                    vector.add(solver.solve(formula, bounds));
                }
                ((ConsoleReporterV2)options.reporter()).println("done kodkoding");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("*** PROBLEM " + n + " ***\n");
                if (this.verbose) {
                    stringBuilder.append("\n---UNIVERSE---\n" + universe.toString() + "\n");
                    stringBuilder.append("\n---BOUNDS---\n" + bounds.toString() + "\n");
                    stringBuilder.append("\n---FORMULA---\n" + formula.toString() + "\n");
                }
                for (int i = 0; i < vector.size(); ++i) {
                    block36: {
                        KodkodiParser kodkodiParser;
                        solution = (Solution)vector.elementAt(i);
                        if (solution.outcome() == Solution.Outcome.TRIVIALLY_SATISFIABLE || solution.outcome() == Solution.Outcome.SATISFIABLE) {
                            kodkodiParser = this;
                            synchronized (kodkodiParser) {
                                --this.maxSolutions;
                                bl2 = this.maxSolutions <= 0;
                            }
                        }
                        stringBuilder.append("\n---OUTCOME---\n");
                        stringBuilder.append(solution.outcome());
                        stringBuilder.append("\n");
                        if (solution.instance() != null) {
                            stringBuilder.append("\n---INSTANCE---\n");
                            stringBuilder.append(KodkodiParser.cleanedUpInstance(solution.instance(), bounds, this.cleanUpInst));
                            stringBuilder.append("\n");
                        }
                        if (solution.proof() != null) {
                            try {
                                if (solution.outcome() != Solution.Outcome.UNSATISFIABLE && solution.outcome() != Solution.Outcome.TRIVIALLY_UNSATISFIABLE) break block36;
                                kodkodiParser = solution.proof();
                                try {
                                    kodkodiParser.minimize((ReductionStrategy)new RCEStrategy(kodkodiParser.log()));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Map map = kodkodiParser.highLevelCore();
                                LinkedHashSet linkedHashSet = new LinkedHashSet(map.keySet());
                                stringBuilder.append("\n---PROOF---\nminimal unsatisfiable core:\n");
                                stringBuilder.append(linkedHashSet);
                                stringBuilder.append("\n");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    stringBuilder.append("\n---STATS---\n");
                    stringBuilder.append(solution.stats());
                    int n5 = stringBuilder.lastIndexOf("translation time:");
                    if (n5 == -1) {
                        n5 = stringBuilder.length();
                    }
                    stringBuilder.insert(n5, "parsing time: " + l + " ms\n");
                    n5 = stringBuilder.lastIndexOf("ints: []\n");
                    if (n5 != -1) {
                        stringBuilder.delete(n5, n5 + 9);
                    }
                    stringBuilder.append("\n");
                    if (bl2) break;
                }
                this.context.output(stringBuilder.toString());
                StringBuilder stringBuilder2 = this.bigBuf;
                synchronized (stringBuilder2) {
                    this.bigBuf.append((CharSequence)stringBuilder);
                }
                if (!bl2) break block37;
                if (n3 > 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.context.exit(0);
            }
            catch (UnboundLeafException unboundLeafException) {
                this.huh(token, "formula contains unbounded leaf expression: " + unboundLeafException.leaf());
            }
            catch (HigherOrderDeclException higherOrderDeclException) {
                this.huh(token, "formula contains unskolemizable higher-order declaration: " + higherOrderDeclException.decl());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.huh(token, "out-of-bounds exception");
            }
            catch (ArithmeticException arithmeticException) {
                this.huh(token, "arithmetic exception");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.huh(token, "out of memory");
            }
        }
        if (bl) {
            if (options.solver() == SATFactory.DefaultSAT4J) {
                this.huh(Token.INVALID_TOKEN, "cannot launch SAT solver");
            } else {
                this.context.error("cannot launch SAT solver, falling back on \"DefaultSAT4J\"");
                options.setSolver(SATFactory.DefaultSAT4J);
                this.solve(token, n, l, options, n2, n3, universe, bounds, formula);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String problems() throws RecognitionException {
        String string = null;
        try {
            block9: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 4 || n2 == 8 || n2 >= 10 && n2 <= 13 || n2 >= 16 && n2 <= 18) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        this.pushFollow(FOLLOW_problem_in_problems60);
                        this.problem();
                        --this.state._fsp;
                        continue block9;
                    }
                }
                break;
            }
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(31622400L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.context.exit(130);
            }
            String string2 = this.bigBuf.toString();
            this.bigBuf = new StringBuilder();
            String string3 = string2;
            return string3;
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void problem() throws RecognitionException {
        try {
            int n;
            int n2;
            this.reset();
            block19: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 4 || n == 8 || n >= 10 && n <= 13 || n >= 16 && n <= 17) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        this.pushFollow(FOLLOW_option_in_problem87);
                        this.option();
                        --this.state._fsp;
                        continue block19;
                    }
                }
                break;
            }
            this.pushFollow(FOLLOW_univ_spec_in_problem98);
            this.univ_spec();
            --this.state._fsp;
            block20: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 20 || n == 22) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        this.pushFollow(FOLLOW_tuple_reg_directive_in_problem108);
                        this.tuple_reg_directive();
                        --this.state._fsp;
                        continue block20;
                    }
                }
                break;
            }
            block21: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 23) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        this.pushFollow(FOLLOW_bound_spec_in_problem119);
                        this.bound_spec();
                        --this.state._fsp;
                        continue block21;
                    }
                }
                break;
            }
            n2 = 2;
            n = this.input.LA(1);
            if (n == 27) {
                n2 = 1;
            }
            switch (n2) {
                case 1: {
                    this.pushFollow(FOLLOW_int_bound_spec_in_problem130);
                    this.int_bound_spec();
                    --this.state._fsp;
                }
            }
            block22: while (true) {
                int n3 = 2;
                int n4 = this.input.LA(1);
                if (n4 >= 28 && n4 <= 30) {
                    n3 = 1;
                }
                switch (n3) {
                    case 1: {
                        this.pushFollow(FOLLOW_expr_reg_directive_in_problem141);
                        this.expr_reg_directive();
                        --this.state._fsp;
                        continue block22;
                    }
                }
                break;
            }
            this.pushFollow(FOLLOW_solve_directive_in_problem152);
            this.solve_directive();
            --this.state._fsp;
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector<String> option() throws RecognitionException {
        Vector<String> vector = new Vector<String>();
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        try {
            int n = 8;
            switch (this.input.LA(1)) {
                case 4: {
                    n = 1;
                    break;
                }
                case 8: {
                    n = 2;
                    break;
                }
                case 10: {
                    n = 3;
                    break;
                }
                case 11: {
                    n = 4;
                    break;
                }
                case 12: {
                    n = 5;
                    break;
                }
                case 13: {
                    n = 6;
                    break;
                }
                case 16: {
                    n = 7;
                    break;
                }
                case 17: {
                    n = 8;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 8, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    int n2;
                    this.match((IntStream)this.input, 4, FOLLOW_SOLVER_in_option170);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option172);
                    token = (Token)this.match((IntStream)this.input, 6, FOLLOW_STR_LITERAL_in_option178);
                    vector.add(this.sstr(token));
                    block39: while (true) {
                        n2 = 2;
                        int n3 = this.input.LA(1);
                        if (n3 == 7) {
                            n2 = 1;
                        }
                        switch (n2) {
                            case 1: {
                                this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_option191);
                                token2 = (Token)this.match((IntStream)this.input, 6, FOLLOW_STR_LITERAL_in_option197);
                                vector.add(this.sstr(token2));
                                continue block39;
                            }
                        }
                        break;
                    }
                    this.ensure();
                    n2 = 1;
                    SATFactory sATFactory = null;
                    if (vector.elementAt(0).equals("CryptoMiniSat")) {
                        sATFactory = SATFactory.CryptoMiniSat;
                    } else if (vector.elementAt(0).equals("DefaultSAT4J")) {
                        sATFactory = SATFactory.DefaultSAT4J;
                    } else if (vector.elementAt(0).equals("LightSAT4J")) {
                        sATFactory = SATFactory.LightSAT4J;
                    } else if (vector.elementAt(0).equals("Lingeling")) {
                        sATFactory = SATFactory.Lingeling;
                    } else if (vector.elementAt(0).equals("MiniSat")) {
                        sATFactory = SATFactory.MiniSat;
                    } else if (vector.elementAt(0).equals("MiniSatProver")) {
                        sATFactory = SATFactory.MiniSatProver;
                    } else if (vector.elementAt(0).equals("ZChaffMincost")) {
                        sATFactory = SATFactory.ZChaffMincost;
                    } else if (vector.elementAt(0).equals("SAT4J")) {
                        n2 = 2;
                        if (vector.size() >= 2) {
                            sATFactory = SATFactory.sat4jFactory((String)vector.elementAt(1));
                        }
                    } else if (vector.elementAt(0).equals("External")) {
                        n2 = 3;
                        if (vector.size() >= n2) {
                            String[] stringArray = new String[vector.size() - n2];
                            for (int i = n2; i < vector.size(); ++i) {
                                stringArray[i - n2] = vector.elementAt(i);
                            }
                            sATFactory = SATFactory.externalFactory((String)vector.elementAt(1), (String)vector.elementAt(2), (String[])stringArray);
                        }
                    } else if (vector.elementAt(0).equals("ExternalV2")) {
                        n2 = 7;
                        if (vector.size() >= n2) {
                            String[] stringArray = new String[vector.size() - n2];
                            for (int i = n2; i < vector.size(); ++i) {
                                stringArray[i - n2] = vector.elementAt(i);
                            }
                            sATFactory = ExternalSolverV2.satFactory(vector.elementAt(1), vector.elementAt(2), vector.elementAt(3), vector.elementAt(4), vector.elementAt(5), vector.elementAt(6), stringArray);
                        }
                    }
                    if (sATFactory != null) {
                        this.options.setSolver(sATFactory);
                    } else {
                        this.huh(token, "unknown SAT solver '" + vector + "'");
                    }
                    if (vector.size() < n2 || n2 <= 2 && vector.size() > n2) {
                        this.huh(token, "expected " + n2 + " strings, got " + vector.size());
                    }
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 8, FOLLOW_SYMMETRY_BREAKING_in_option215);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option217);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option223);
                    try {
                        this.options.setSymmetryBreaking(this.getInt(token3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "symmetry breaking value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                    break;
                }
                case 3: {
                    this.match((IntStream)this.input, 10, FOLLOW_SHARING_in_option237);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option239);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option245);
                    try {
                        this.options.setSharing(this.getInt(token3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "sharing value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                    break;
                }
                case 4: {
                    this.match((IntStream)this.input, 11, FOLLOW_BIT_WIDTH_in_option259);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option261);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option267);
                    try {
                        this.options.setBitwidth(this.getInt(token3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "bit width value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                    break;
                }
                case 5: {
                    this.match((IntStream)this.input, 12, FOLLOW_SKOLEM_DEPTH_in_option281);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option283);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option289);
                    try {
                        this.options.setSkolemDepth(this.getInt(token3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "Skolem depth value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                    break;
                }
                case 6: {
                    this.match((IntStream)this.input, 13, FOLLOW_FLATTEN_in_option303);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option305);
                    token4 = this.input.LT(1);
                    if (this.input.LA(1) < 14 || this.input.LA(1) > 15) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.options.setFlatten((token4 != null ? token4.getType() : 0) == 14);
                    break;
                }
                case 7: {
                    this.match((IntStream)this.input, 16, FOLLOW_TIMEOUT_in_option331);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option333);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option339);
                    try {
                        this.timeout = this.getInt(token3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "timeout value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                    break;
                }
                case 8: {
                    this.match((IntStream)this.input, 17, FOLLOW_DELAY_in_option353);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_option355);
                    token3 = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_option361);
                    try {
                        this.delay = this.getInt(token3);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "delay value " + (token3 != null ? token3.getText() : null) + " out of range");
                    }
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void univ_spec() throws RecognitionException {
        Token token = null;
        try {
            this.match((IntStream)this.input, 18, FOLLOW_UNIV_in_univ_spec377);
            this.match((IntStream)this.input, 5, FOLLOW_COLON_in_univ_spec379);
            token = (Token)this.match((IntStream)this.input, 19, FOLLOW_UNIV_NAME_in_univ_spec385);
            this.ensure();
            int n = this.id(token != null ? token.getText() : null);
            if (n == 0) {
                this.huh(token, "invalid universe '" + (token != null ? token.getText() : null) + "'");
                n = 1;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new String("A" + i));
            }
            this.universe = new Universe(arrayList);
            this.factory = this.universe.factory();
            this.bounds = new Bounds(this.universe);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tuple_reg_directive() throws RecognitionException {
        Token token = null;
        Token token2 = null;
        TupleSet tupleSet = null;
        tuple_return tuple_return2 = null;
        try {
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 20) {
                n = 1;
            } else if (n2 == 22) {
                n = 2;
            } else {
                NoViableAltException noViableAltException = new NoViableAltException("", 9, 0, (IntStream)this.input);
                throw noViableAltException;
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 20, FOLLOW_TUPLE_SET_REG_in_tuple_reg_directive405);
                    token2 = (Token)this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_tuple_reg_directive411);
                    this.pushFollow(FOLLOW_tuple_set_in_tuple_reg_directive417);
                    tupleSet = this.tuple_set(this.arity(token != null ? token.getText() : null));
                    --this.state._fsp;
                    if (tupleSet.arity() == this.arity(token != null ? token.getText() : null)) {
                        this.setTupleSet(token, tupleSet);
                        break;
                    }
                    this.huh(token2, "expected " + this.arity(token != null ? token.getText() : null) + "-tuple set, got " + tupleSet.arity() + "-tuple set");
                    break;
                }
                case 2: {
                    token = (Token)this.match((IntStream)this.input, 22, FOLLOW_TUPLE_REG_in_tuple_reg_directive436);
                    token2 = (Token)this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_tuple_reg_directive442);
                    this.pushFollow(FOLLOW_tuple_in_tuple_reg_directive448);
                    tuple_return2 = this.tuple(this.arity(token != null ? token.getText() : null));
                    --this.state._fsp;
                    if ((tuple_return2 != null ? tuple_return2.value : null).arity() == this.arity(token != null ? token.getText() : null)) {
                        this.setTuple(token, tuple_return2 != null ? tuple_return2.value : null);
                        break;
                    }
                    this.huh(token2, "expected " + this.arity(token != null ? token.getText() : null) + "-tuple, got " + (tuple_return2 != null ? tuple_return2.value : null).arity() + "-tuple");
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Relation> bound_spec() throws RecognitionException {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        TupleSet tupleSet = null;
        TupleSet tupleSet2 = null;
        try {
            int n;
            int n2;
            this.match((IntStream)this.input, 23, FOLLOW_BOUNDS_in_bound_spec469);
            token = (Token)this.match((IntStream)this.input, 24, FOLLOW_RELATION_NAME_in_bound_spec475);
            arrayList.add(this.getRelation(token));
            block13: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 7) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_bound_spec488);
                        token2 = (Token)this.match((IntStream)this.input, 24, FOLLOW_RELATION_NAME_in_bound_spec494);
                        arrayList.add(this.getRelation(token2));
                        continue block13;
                    }
                }
                break;
            }
            token3 = (Token)this.match((IntStream)this.input, 5, FOLLOW_COLON_in_bound_spec512);
            n2 = 2;
            n = this.input.LA(1);
            if (n >= 19 && n <= 20 || n >= 37 && n <= 38 || n == 40 || n >= 44 && n <= 45) {
                n2 = 1;
            } else if (n == 25) {
                n2 = 2;
            } else {
                NoViableAltException noViableAltException = new NoViableAltException("", 11, 0, (IntStream)this.input);
                throw noViableAltException;
            }
            switch (n2) {
                case 1: {
                    this.pushFollow(FOLLOW_tuple_set_in_bound_spec527);
                    tupleSet = this.tuple_set(((Relation)arrayList.get(0)).arity());
                    --this.state._fsp;
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_bound_spec541);
                    this.pushFollow(FOLLOW_tuple_set_in_bound_spec547);
                    tupleSet = this.tuple_set(((Relation)arrayList.get(0)).arity());
                    --this.state._fsp;
                    this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_bound_spec559);
                    this.pushFollow(FOLLOW_tuple_set_in_bound_spec565);
                    tupleSet2 = this.tuple_set(((Relation)arrayList.get(0)).arity());
                    --this.state._fsp;
                    this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_bound_spec568);
                }
            }
            try {
                if (tupleSet2 == null) {
                    for (Relation relation : arrayList) {
                        if (this.bounds.lowerBound(relation) == null) {
                            this.bounds.boundExactly(relation, tupleSet);
                            continue;
                        }
                        this.huh(token3, "relation already bound");
                    }
                } else {
                    for (Relation relation : arrayList) {
                        if (this.bounds.lowerBound(relation) == null) {
                            this.bounds.bound(relation, tupleSet, tupleSet2);
                            continue;
                        }
                        this.huh(token3, "relation already bound");
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.huh(token3, "invalid bounds: " + KodkodiParser.fixedMessage(illegalArgumentException));
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void int_bound_spec() throws RecognitionException {
        try {
            this.match((IntStream)this.input, 27, FOLLOW_INT_BOUNDS_in_int_bound_spec585);
            this.match((IntStream)this.input, 5, FOLLOW_COLON_in_int_bound_spec587);
            this.pushFollow(FOLLOW_int_bound_seq_in_int_bound_spec593);
            this.int_bound_seq();
            --this.state._fsp;
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 7) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_int_bound_spec596);
                        this.pushFollow(FOLLOW_int_bound_seq_in_int_bound_spec602);
                        this.int_bound_seq();
                        --this.state._fsp;
                        continue block7;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expr_reg_directive() throws RecognitionException {
        Token token = null;
        Object object = null;
        try {
            int n = 3;
            switch (this.input.LA(1)) {
                case 28: {
                    n = 1;
                    break;
                }
                case 29: {
                    n = 2;
                    break;
                }
                case 30: {
                    n = 3;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 13, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 28, FOLLOW_FORMULA_REG_in_expr_reg_directive622);
                    this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_expr_reg_directive624);
                    this.pushFollow(FOLLOW_expr_in_expr_reg_directive630);
                    object = this.expr();
                    --this.state._fsp;
                    this.setFormulaReg(token, this.F(token, object));
                    break;
                }
                case 2: {
                    token = (Token)this.match((IntStream)this.input, 29, FOLLOW_REL_EXPR_REG_in_expr_reg_directive648);
                    this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_expr_reg_directive650);
                    this.pushFollow(FOLLOW_expr_in_expr_reg_directive656);
                    object = this.expr();
                    --this.state._fsp;
                    this.setExprReg(token, this.E(token, object));
                    break;
                }
                case 3: {
                    token = (Token)this.match((IntStream)this.input, 30, FOLLOW_INT_EXPR_REG_in_expr_reg_directive674);
                    this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_expr_reg_directive676);
                    this.pushFollow(FOLLOW_expr_in_expr_reg_directive682);
                    object = this.expr();
                    --this.state._fsp;
                    this.setIntExprReg(token, this.I(token, object));
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void solve_directive() throws RecognitionException {
        block9: {
            Token token = null;
            Object object = null;
            try {
                token = (Token)this.match((IntStream)this.input, 31, FOLLOW_SOLVE_in_solve_directive702);
                this.pushFollow(FOLLOW_expr_in_solve_directive708);
                object = this.expr();
                --this.state._fsp;
                this.match((IntStream)this.input, 32, FOLLOW_SEMICOLON_in_solve_directive710);
                final long l = System.currentTimeMillis() - this.startParsingTime;
                final Token token2 = token;
                final int n = this.problemNo;
                final Options options = this.options;
                final Universe universe = this.universe;
                final Bounds bounds = this.bounds;
                final Formula formula = this.F(token, object);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            KodkodiParser.this.solve(token2, n, l, options, KodkodiParser.this.timeout, KodkodiParser.this.delay, universe, bounds, formula);
                        }
                        catch (Throwable throwable) {
                            String string = throwable.getMessage();
                            if (string == null || string.length() == 0) {
                                string = throwable.toString();
                            }
                            try {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                KodkodiParser.this.context.error("Solve error: " + string);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                if (this.timeout > 0) {
                    Future<?> future = this.executor.submit(runnable);
                    try {
                        future.get(this.timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException executionException) {
                        this.context.error("Error: Java execution error");
                        future.cancel(true);
                    }
                    catch (InterruptedException interruptedException) {
                        this.context.error("Error: Java interruption error");
                        future.cancel(true);
                    }
                    catch (TimeoutException timeoutException) {
                        this.context.error("Error: problem timed out");
                        future.cancel(true);
                    }
                    break block9;
                }
                this.executor.execute(runnable);
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover((IntStream)this.input, recognitionException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void int_bound_seq() throws RecognitionException {
        Token token = null;
        tuple_set_seq_return tuple_set_seq_return2 = null;
        try {
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 9) {
                n = 1;
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_int_bound_seq732);
                    this.match((IntStream)this.input, 5, FOLLOW_COLON_in_int_bound_seq734);
                }
            }
            this.pushFollow(FOLLOW_tuple_set_seq_in_int_bound_seq742);
            tuple_set_seq_return2 = this.tuple_set_seq(1);
            --this.state._fsp;
            if (token != null) {
                this.nextInt = this.getInt(token);
            }
            for (TupleSet tupleSet : tuple_set_seq_return2 != null ? tuple_set_seq_return2.value : null) {
                try {
                    this.bounds.boundExactly(this.nextInt, tupleSet);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.huh(tuple_set_seq_return2 != null ? tuple_set_seq_return2.token : null, "invalid bounds: " + KodkodiParser.fixedMessage(illegalArgumentException));
                }
                ++this.nextInt;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final tuple_set_seq_return tuple_set_seq(int n) throws RecognitionException {
        tuple_set_seq_return tuple_set_seq_return2 = new tuple_set_seq_return();
        tuple_set_seq_return2.start = this.input.LT(1);
        Token token = null;
        TupleSet tupleSet = null;
        TupleSet tupleSet2 = null;
        try {
            token = (Token)this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_tuple_set_seq773);
            int n2 = 2;
            int n3 = this.input.LA(1);
            if (n3 >= 19 && n3 <= 20 || n3 >= 37 && n3 <= 38 || n3 == 40 || n3 >= 44 && n3 <= 45) {
                n2 = 1;
            }
            switch (n2) {
                case 1: {
                    this.pushFollow(FOLLOW_tuple_set_in_tuple_set_seq780);
                    tupleSet = this.tuple_set(n);
                    --this.state._fsp;
                    tuple_set_seq_return2.token = token;
                    tuple_set_seq_return2.value.add(tupleSet);
                    block10: while (true) {
                        int n4 = 2;
                        int n5 = this.input.LA(1);
                        if (n5 == 7) {
                            n4 = 1;
                        }
                        switch (n4) {
                            case 1: {
                                this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_tuple_set_seq786);
                                this.pushFollow(FOLLOW_tuple_set_in_tuple_set_seq792);
                                tupleSet2 = this.tuple_set(n);
                                --this.state._fsp;
                                tuple_set_seq_return2.value.add(tupleSet2);
                                continue block10;
                            }
                        }
                        break;
                    }
                    break;
                }
            }
            this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_tuple_set_seq808);
            tuple_set_seq_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return tuple_set_seq_return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TupleSet tuple_set(int n) throws RecognitionException {
        TupleSet tupleSet;
        block13: {
            tupleSet = null;
            Token token = null;
            TupleSet tupleSet2 = null;
            TupleSet tupleSet3 = null;
            try {
                this.pushFollow(FOLLOW_intersect_tuple_set_in_tuple_set832);
                tupleSet2 = this.intersect_tuple_set(n);
                --this.state._fsp;
                tupleSet = tupleSet2;
                block9: while (true) {
                    int n2 = 2;
                    int n3 = this.input.LA(1);
                    if (n3 >= 33 && n3 <= 34) {
                        n2 = 1;
                    }
                    switch (n2) {
                        case 1: {
                            token = this.input.LT(1);
                            if (this.input.LA(1) < 33 || this.input.LA(1) > 34) {
                                MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                                throw mismatchedSetException;
                            }
                            this.input.consume();
                            this.state.errorRecovery = false;
                            this.pushFollow(FOLLOW_intersect_tuple_set_in_tuple_set862);
                            tupleSet3 = this.intersect_tuple_set(n);
                            --this.state._fsp;
                            try {
                                if ((token != null ? token.getType() : 0) == 33) {
                                    tupleSet.addAll((Collection)tupleSet3);
                                    break;
                                }
                                tupleSet.removeAll((Collection)tupleSet3);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.huh(token, "illegal tuple set: " + KodkodiParser.fixedMessage(illegalArgumentException));
                            }
                            continue block9;
                        }
                        default: {
                            break block13;
                        }
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover((IntStream)this.input, recognitionException);
            }
        }
        return tupleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TupleSet intersect_tuple_set(int n) throws RecognitionException {
        TupleSet tupleSet = null;
        Token token = null;
        TupleSet tupleSet2 = null;
        TupleSet tupleSet3 = null;
        try {
            this.pushFollow(FOLLOW_product_tuple_set_in_intersect_tuple_set890);
            tupleSet2 = this.product_tuple_set(n);
            --this.state._fsp;
            tupleSet = tupleSet2;
            block9: while (true) {
                int n2 = 2;
                int n3 = this.input.LA(1);
                if (n3 == 35) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        token = (Token)this.match((IntStream)this.input, 35, FOLLOW_AND_in_intersect_tuple_set908);
                        this.pushFollow(FOLLOW_product_tuple_set_in_intersect_tuple_set914);
                        tupleSet3 = this.product_tuple_set(n);
                        --this.state._fsp;
                        try {
                            tupleSet.retainAll((Collection)tupleSet3);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.huh(token, "illegal tuple set: " + KodkodiParser.fixedMessage(illegalArgumentException));
                        }
                        continue block9;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return tupleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TupleSet product_tuple_set(int n) throws RecognitionException {
        TupleSet tupleSet = null;
        Token token = null;
        TupleSet tupleSet2 = null;
        TupleSet tupleSet3 = null;
        try {
            this.pushFollow(FOLLOW_project_tuple_set_in_product_tuple_set942);
            tupleSet2 = this.project_tuple_set(n);
            --this.state._fsp;
            tupleSet = tupleSet2;
            block9: while (true) {
                int n2 = 2;
                int n3 = this.input.LA(1);
                if (n3 == 36) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        token = (Token)this.match((IntStream)this.input, 36, FOLLOW_ARROW_in_product_tuple_set960);
                        this.pushFollow(FOLLOW_project_tuple_set_in_product_tuple_set966);
                        tupleSet3 = this.project_tuple_set(n);
                        --this.state._fsp;
                        try {
                            tupleSet = tupleSet.product(tupleSet3);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.huh(token, "illegal tuple set: " + KodkodiParser.fixedMessage(illegalArgumentException));
                        }
                        continue block9;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return tupleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TupleSet project_tuple_set(int n) throws RecognitionException {
        TupleSet tupleSet;
        block11: {
            tupleSet = null;
            Token token = null;
            basic_tuple_set_return basic_tuple_set_return2 = null;
            try {
                this.pushFollow(FOLLOW_basic_tuple_set_in_project_tuple_set994);
                basic_tuple_set_return2 = this.basic_tuple_set(n);
                --this.state._fsp;
                tupleSet = basic_tuple_set_return2 != null ? basic_tuple_set_return2.value : null;
                block9: while (true) {
                    int n2 = 2;
                    int n3 = this.input.LA(1);
                    if (n3 == 25) {
                        n2 = 1;
                    }
                    switch (n2) {
                        case 1: {
                            this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_project_tuple_set1008);
                            token = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_project_tuple_set1014);
                            this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_project_tuple_set1016);
                            int n4 = this.getInt(token);
                            try {
                                tupleSet = tupleSet.project(n4);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.huh(token, "dimension " + n4 + " out of range");
                                tupleSet = basic_tuple_set_return2 != null ? basic_tuple_set_return2.value : null;
                            }
                            continue block9;
                        }
                        default: {
                            break block11;
                        }
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover((IntStream)this.input, recognitionException);
            }
        }
        return tupleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final basic_tuple_set_return basic_tuple_set(int n) throws RecognitionException {
        basic_tuple_set_return basic_tuple_set_return2 = new basic_tuple_set_return();
        basic_tuple_set_return2.start = this.input.LT(1);
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        TupleSet tupleSet = null;
        tuple_return tuple_return2 = null;
        tuple_return tuple_return3 = null;
        try {
            int n2 = 6;
            switch (this.input.LA(1)) {
                case 19: 
                case 37: {
                    n2 = 1;
                    break;
                }
                case 38: {
                    n2 = 2;
                    break;
                }
                case 40: {
                    n2 = 3;
                    break;
                }
                case 44: {
                    n2 = 4;
                    break;
                }
                case 45: {
                    n2 = 5;
                    break;
                }
                case 20: {
                    n2 = 6;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 24, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n2) {
                case 1: {
                    token = this.input.LT(1);
                    if (this.input.LA(1) != 19 && this.input.LA(1) != 37) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    basic_tuple_set_return2.value = this.univTupleSet(token, this.id(token != null ? token.getText() : null));
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_basic_tuple_set1070);
                    this.pushFollow(FOLLOW_tuple_set_in_basic_tuple_set1076);
                    tupleSet = this.tuple_set(n);
                    --this.state._fsp;
                    basic_tuple_set_return2.value = tupleSet;
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_basic_tuple_set1081);
                    break;
                }
                case 3: {
                    token2 = (Token)this.match((IntStream)this.input, 40, FOLLOW_BRACE_LEFT_in_basic_tuple_set1097);
                    int n3 = 2;
                    int n4 = this.input.LA(1);
                    if (n4 == 22 || n4 == 25 || n4 >= 46 && n4 <= 47) {
                        n3 = 1;
                    } else if (n4 == 43) {
                        n3 = 2;
                    } else {
                        NoViableAltException noViableAltException = new NoViableAltException("", 23, 0, (IntStream)this.input);
                        throw noViableAltException;
                    }
                    switch (n3) {
                        case 1: {
                            this.pushFollow(FOLLOW_tuple_in_basic_tuple_set1112);
                            tuple_return2 = this.tuple(n);
                            --this.state._fsp;
                            int n5 = 3;
                            switch (this.input.LA(1)) {
                                case 7: 
                                case 43: {
                                    n5 = 1;
                                    break;
                                }
                                case 41: {
                                    n5 = 2;
                                    break;
                                }
                                case 42: {
                                    n5 = 3;
                                    break;
                                }
                                default: {
                                    NoViableAltException noViableAltException = new NoViableAltException("", 22, 0, (IntStream)this.input);
                                    throw noViableAltException;
                                }
                            }
                            switch (n5) {
                                case 1: {
                                    basic_tuple_set_return2.list.add(tuple_return2 != null ? tuple_return2.value : null);
                                    block51: while (true) {
                                        int n6 = 2;
                                        int n7 = this.input.LA(1);
                                        if (n7 == 7) {
                                            n6 = 1;
                                        }
                                        switch (n6) {
                                            case 1: {
                                                this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_basic_tuple_set1128);
                                                this.pushFollow(FOLLOW_tuple_in_basic_tuple_set1134);
                                                tuple_return3 = this.tuple(n);
                                                --this.state._fsp;
                                                basic_tuple_set_return2.list.add(tuple_return3 != null ? tuple_return3.value : null);
                                                continue block51;
                                            }
                                        }
                                        break;
                                    }
                                    try {
                                        basic_tuple_set_return2.value = this.factory.setOf(basic_tuple_set_return2.list);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        this.huh(token2, "illegal tuple set: " + KodkodiParser.fixedMessage(illegalArgumentException));
                                    }
                                    break;
                                }
                                case 2: {
                                    token3 = (Token)this.match((IntStream)this.input, 41, FOLLOW_DOT_DOT_in_basic_tuple_set1159);
                                    this.pushFollow(FOLLOW_tuple_in_basic_tuple_set1165);
                                    tuple_return3 = this.tuple(n);
                                    --this.state._fsp;
                                    try {
                                        basic_tuple_set_return2.value = this.factory.range(tuple_return2 != null ? tuple_return2.value : null, tuple_return3 != null ? tuple_return3.value : null);
                                    }
                                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                        this.huh(token3, "invalid range");
                                        basic_tuple_set_return2.value = this.factory.setOf(tuple_return2 != null ? tuple_return2.value : null, new Tuple[0]);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        this.huh(token3, "invalid range");
                                        basic_tuple_set_return2.value = this.factory.setOf(tuple_return2 != null ? tuple_return2.value : null, new Tuple[0]);
                                    }
                                    break;
                                }
                                case 3: {
                                    token4 = (Token)this.match((IntStream)this.input, 42, FOLLOW_HASH_in_basic_tuple_set1186);
                                    this.pushFollow(FOLLOW_tuple_in_basic_tuple_set1192);
                                    tuple_return3 = this.tuple(n);
                                    --this.state._fsp;
                                    try {
                                        basic_tuple_set_return2.value = this.factory.area(tuple_return2 != null ? tuple_return2.value : null, tuple_return3 != null ? tuple_return3.value : null);
                                        break;
                                    }
                                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                        this.huh(token4, "invalid area");
                                        basic_tuple_set_return2.value = this.factory.setOf(tuple_return2 != null ? tuple_return2.value : null, new Tuple[0]);
                                        break;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        this.huh(token4, "invalid area");
                                        basic_tuple_set_return2.value = this.factory.setOf(tuple_return2 != null ? tuple_return2.value : null, new Tuple[0]);
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            try {
                                basic_tuple_set_return2.value = this.factory.noneOf(n);
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.huh(token2, "arity " + n + " too large for universe of " + "cardinality " + this.universe.size());
                            }
                        }
                    }
                    this.match((IntStream)this.input, 43, FOLLOW_BRACE_RIGHT_in_basic_tuple_set1220);
                    break;
                }
                case 4: {
                    token = (Token)this.match((IntStream)this.input, 44, FOLLOW_NONE_in_basic_tuple_set1236);
                    try {
                        basic_tuple_set_return2.value = this.factory.noneOf(n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token, "arity " + n + " too large for universe of " + "cardinality " + this.universe.size());
                    }
                    break;
                }
                case 5: {
                    token5 = (Token)this.match((IntStream)this.input, 45, FOLLOW_ALL_in_basic_tuple_set1254);
                    try {
                        basic_tuple_set_return2.value = this.factory.allOf(n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token5, "arity " + n + " too large for universe of " + "cardinality " + this.universe.size());
                    }
                    break;
                }
                case 6: {
                    token6 = (Token)this.match((IntStream)this.input, 20, FOLLOW_TUPLE_SET_REG_in_basic_tuple_set1272);
                    basic_tuple_set_return2.value = this.getTupleSet(token6);
                }
            }
            basic_tuple_set_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return basic_tuple_set_return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final tuple_return tuple(int n) throws RecognitionException {
        tuple_return tuple_return2 = new tuple_return();
        tuple_return2.start = this.input.LT(1);
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        try {
            int n2 = 4;
            switch (this.input.LA(1)) {
                case 25: {
                    n2 = 1;
                    break;
                }
                case 46: {
                    n2 = 2;
                    break;
                }
                case 47: {
                    n2 = 3;
                    break;
                }
                case 22: {
                    n2 = 4;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 26, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n2) {
                case 1: {
                    this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_tuple1293);
                    token = (Token)this.match((IntStream)this.input, 46, FOLLOW_ATOM_NAME_in_tuple1299);
                    tuple_return2.atoms = new ArrayList<Object>();
                    tuple_return2.atoms.add(this.getAtom(token));
                    block21: while (true) {
                        int n3 = 2;
                        int n4 = this.input.LA(1);
                        if (n4 == 7) {
                            n3 = 1;
                        }
                        switch (n3) {
                            case 1: {
                                this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_tuple1304);
                                token2 = (Token)this.match((IntStream)this.input, 46, FOLLOW_ATOM_NAME_in_tuple1310);
                                tuple_return2.atoms.add(this.getAtom(token2));
                                continue block21;
                            }
                        }
                        break;
                    }
                    this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_tuple1316);
                    tuple_return2.value = this.factory.tuple(tuple_return2.atoms);
                    break;
                }
                case 2: {
                    token3 = (Token)this.match((IntStream)this.input, 46, FOLLOW_ATOM_NAME_in_tuple1334);
                    tuple_return2.value = this.factory.tuple(new Object[]{this.getAtom(token3)});
                    break;
                }
                case 3: {
                    token3 = (Token)this.match((IntStream)this.input, 47, FOLLOW_TUPLE_NAME_in_tuple1352);
                    String string = token3 != null ? token3.getText() : null;
                    try {
                        tuple_return2.value = this.factory.tuple(this.arity(string), this.id(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "tuple index out of range");
                        tuple_return2.value = this.factory.tuple(this.arity(string), 0);
                    }
                    break;
                }
                case 4: {
                    token4 = (Token)this.match((IntStream)this.input, 22, FOLLOW_TUPLE_REG_in_tuple1370);
                    tuple_return2.value = this.getTuple(token4);
                }
            }
            tuple_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return tuple_return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Decls decls = null;
        Object object2 = null;
        assigns_return assigns_return2 = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        try {
            int n;
            int n2 = 6;
            switch (this.input.LA(1)) {
                case 45: {
                    n2 = 1;
                    break;
                }
                case 49: {
                    n = this.input.LA(2);
                    if (n == 25) {
                        n2 = 2;
                        break;
                    }
                    if (n == 9 || n >= 14 && n <= 15 || n >= 18 && n <= 19 || n == 24 || n >= 28 && n <= 30 || n == 34 || n >= 37 && n <= 38 || n == 40 || n == 42 || n == 44 || n == 46 || n == 50 || n == 73 || n == 76 || n >= 81 && n <= 88) {
                        n2 = 6;
                        break;
                    }
                    NoViableAltException noViableAltException = new NoViableAltException("", 28, 2, (IntStream)this.input);
                    throw noViableAltException;
                }
                case 50: {
                    n = this.input.LA(2);
                    if (n == 38) {
                        n2 = 6;
                        break;
                    }
                    if (n == 25) {
                        n2 = 3;
                        break;
                    }
                    NoViableAltException noViableAltException = new NoViableAltException("", 28, 3, (IntStream)this.input);
                    throw noViableAltException;
                }
                case 51: {
                    n2 = 4;
                    break;
                }
                case 52: {
                    n2 = 5;
                    break;
                }
                case 9: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 24: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 37: 
                case 38: 
                case 40: 
                case 42: 
                case 44: 
                case 46: 
                case 58: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 73: 
                case 76: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    n2 = 6;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 28, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n2) {
                case 1: {
                    this.match((IntStream)this.input, 45, FOLLOW_ALL_in_expr1391);
                    this.pushFollow(FOLLOW_decls_in_expr1397);
                    decls = this.decls();
                    --this.state._fsp;
                    token = (Token)this.match((IntStream)this.input, 48, FOLLOW_BAR_in_expr1403);
                    this.pushFollow(FOLLOW_expr_in_expr1409);
                    object2 = this.expr();
                    --this.state._fsp;
                    if (decls == null) {
                        object = this.F(token, object2);
                        break;
                    }
                    object = this.F(token, object2).forAll(decls);
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 49, FOLLOW_SOME_in_expr1423);
                    this.pushFollow(FOLLOW_decls_in_expr1429);
                    decls = this.decls();
                    --this.state._fsp;
                    token = (Token)this.match((IntStream)this.input, 48, FOLLOW_BAR_in_expr1435);
                    this.pushFollow(FOLLOW_expr_in_expr1441);
                    object2 = this.expr();
                    --this.state._fsp;
                    if (decls == null) {
                        object = this.F(token, object2);
                        break;
                    }
                    object = this.F(token, object2).forSome(decls);
                    break;
                }
                case 3: {
                    this.match((IntStream)this.input, 50, FOLLOW_SUM_in_expr1455);
                    this.pushFollow(FOLLOW_decls_in_expr1461);
                    decls = this.decls();
                    --this.state._fsp;
                    token = (Token)this.match((IntStream)this.input, 48, FOLLOW_BAR_in_expr1467);
                    this.pushFollow(FOLLOW_expr_in_expr1473);
                    object2 = this.expr();
                    --this.state._fsp;
                    try {
                        object = this.I(token, object2).sum(decls);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token, "expected one or more declarations with multiplicity 'one'");
                    }
                    break;
                }
                case 4: {
                    token2 = (Token)this.match((IntStream)this.input, 51, FOLLOW_LET_in_expr1491);
                    this.pushFollow(FOLLOW_assigns_in_expr1497);
                    assigns_return2 = this.assigns();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 48, FOLLOW_BAR_in_expr1499);
                    this.pushFollow(FOLLOW_expr_in_expr1505);
                    object2 = this.expr();
                    --this.state._fsp;
                    object = object2;
                    for (n = (assigns_return2 != null ? assigns_return2.oldNodes : null).size() - 1; n >= 0; --n) {
                        this.setReg((assigns_return2 != null ? assigns_return2.tokens : null).elementAt(n), (assigns_return2 != null ? assigns_return2.oldNodes : null).elementAt(n));
                    }
                    break;
                }
                case 5: {
                    token3 = (Token)this.match((IntStream)this.input, 52, FOLLOW_IF_in_expr1523);
                    this.pushFollow(FOLLOW_expr_in_expr1529);
                    object2 = this.expr();
                    --this.state._fsp;
                    token4 = (Token)this.match((IntStream)this.input, 53, FOLLOW_THEN_in_expr1535);
                    this.pushFollow(FOLLOW_expr_in_expr1541);
                    object3 = this.expr();
                    --this.state._fsp;
                    token5 = (Token)this.match((IntStream)this.input, 54, FOLLOW_ELSE_in_expr1547);
                    this.pushFollow(FOLLOW_expr_in_expr1553);
                    object4 = this.expr();
                    --this.state._fsp;
                    if (KodkodiParser.isExpression(object3)) {
                        try {
                            object = this.F(token3, object2).thenElse(this.E(token4, object3), this.E(token5, object4));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            int n3 = this.E(token4, object3).arity();
                            int n4 = this.E(token5, object4).arity();
                            if (n3 == n4) {
                                this.panic();
                                break;
                            }
                            this.huh(token5, "arity mismatch (" + n3 + " vs. " + n4 + ")");
                        }
                        break;
                    }
                    if (KodkodiParser.isIntExpression(object3)) {
                        object = this.F(token3, object2).thenElse(this.I(token4, object3), this.I(token5, object4));
                        break;
                    }
                    Formula formula = this.F(token3, object2);
                    object = formula.and(this.F(token5, object3)).or(formula.not().and(this.F(token5, object4)));
                    break;
                }
                case 6: {
                    this.pushFollow(FOLLOW_iff_formula_in_expr1571);
                    object3 = this.iff_formula();
                    --this.state._fsp;
                    object = object3;
                    n = 2;
                    int n5 = this.input.LA(1);
                    if (n5 == 55) {
                        n = 1;
                    }
                    switch (n) {
                        case 1: {
                            token6 = (Token)this.match((IntStream)this.input, 55, FOLLOW_OR_in_expr1588);
                            this.pushFollow(FOLLOW_or_formula_tail_in_expr1594);
                            object5 = this.or_formula_tail(token6, new SingletonArrayList<Formula>(this.F(token6, object)));
                            --this.state._fsp;
                            object = object5;
                        }
                    }
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object or_formula_tail(Token token, List<Formula> list) throws RecognitionException {
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_iff_formula_in_or_formula_tail1635);
            object2 = this.iff_formula();
            --this.state._fsp;
            list.add(this.F(token, object2));
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 55) {
                n = 1;
            } else if (n2 == 7 || n2 == 26 || n2 >= 28 && n2 <= 32 || n2 == 36 || n2 == 39 || n2 == 43 || n2 >= 53 && n2 <= 54) {
                n = 2;
            } else {
                NoViableAltException noViableAltException = new NoViableAltException("", 29, 0, (IntStream)this.input);
                throw noViableAltException;
            }
            switch (n) {
                case 1: {
                    this.match((IntStream)this.input, 55, FOLLOW_OR_in_or_formula_tail1648);
                    this.pushFollow(FOLLOW_or_formula_tail_in_or_formula_tail1654);
                    object3 = this.or_formula_tail(token, list);
                    --this.state._fsp;
                    object = object3;
                    break;
                }
                case 2: {
                    object = Formula.or(list);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object iff_formula() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_implies_formula_in_iff_formula1693);
            object2 = this.implies_formula();
            --this.state._fsp;
            object = object2;
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 56) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        token = (Token)this.match((IntStream)this.input, 56, FOLLOW_IFF_in_iff_formula1710);
                        this.pushFollow(FOLLOW_implies_formula_in_iff_formula1716);
                        object3 = this.implies_formula();
                        --this.state._fsp;
                        object = this.F(token, object).iff(this.F(token, object3));
                        continue block7;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object implies_formula() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_and_formula_in_implies_formula1742);
            object2 = this.and_formula();
            --this.state._fsp;
            object = object2;
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 57) {
                n = 1;
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 57, FOLLOW_IMPLIES_in_implies_formula1759);
                    this.pushFollow(FOLLOW_implies_formula_in_implies_formula1765);
                    object3 = this.implies_formula();
                    --this.state._fsp;
                    object = this.F(token, object).implies(this.F(token, object3));
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object and_formula() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_basic_formula_in_and_formula1791);
            object2 = this.basic_formula();
            --this.state._fsp;
            object = object2;
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 35) {
                n = 1;
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 35, FOLLOW_AND_in_and_formula1808);
                    this.pushFollow(FOLLOW_and_formula_tail_in_and_formula1814);
                    object3 = this.and_formula_tail(token, new SingletonArrayList<Formula>(this.F(token, object)));
                    --this.state._fsp;
                    object = object3;
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object and_formula_tail(Token token, List<Formula> list) throws RecognitionException {
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_basic_formula_in_and_formula_tail1855);
            object2 = this.basic_formula();
            --this.state._fsp;
            list.add(this.F(token, object2));
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 35) {
                n = 1;
            } else if (n2 == 7 || n2 == 26 || n2 >= 28 && n2 <= 32 || n2 == 36 || n2 == 39 || n2 == 43 || n2 >= 53 && n2 <= 57) {
                n = 2;
            } else {
                NoViableAltException noViableAltException = new NoViableAltException("", 33, 0, (IntStream)this.input);
                throw noViableAltException;
            }
            switch (n) {
                case 1: {
                    this.match((IntStream)this.input, 35, FOLLOW_AND_in_and_formula_tail1868);
                    this.pushFollow(FOLLOW_and_formula_tail_in_and_formula_tail1874);
                    object3 = this.and_formula_tail(token, list);
                    --this.state._fsp;
                    object = object3;
                    break;
                }
                case 2: {
                    object = Formula.and(list);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object basic_formula() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        multiplicity_return multiplicity_return2 = null;
        try {
            int n = 4;
            switch (this.input.LA(1)) {
                case 58: {
                    n = 1;
                    break;
                }
                case 65: 
                case 66: 
                case 69: {
                    n = 2;
                    break;
                }
                case 9: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 24: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 37: 
                case 38: 
                case 40: 
                case 42: 
                case 44: 
                case 46: 
                case 50: 
                case 73: 
                case 76: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: {
                    n = 3;
                    break;
                }
                case 49: 
                case 67: 
                case 68: 
                case 89: 
                case 90: {
                    n = 4;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 35, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            block9 : switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 58, FOLLOW_NOT_in_basic_formula1913);
                    this.pushFollow(FOLLOW_basic_formula_in_basic_formula1919);
                    object2 = this.basic_formula();
                    --this.state._fsp;
                    object = this.F(token, object2).not();
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_predicate_formula_in_basic_formula1937);
                    object2 = this.predicate_formula();
                    --this.state._fsp;
                    object = object2;
                    break;
                }
                case 3: {
                    this.pushFollow(FOLLOW_shift_expr_in_basic_formula1955);
                    object2 = this.shift_expr();
                    --this.state._fsp;
                    int n2 = 2;
                    int n3 = this.input.LA(1);
                    if (n3 >= 59 && n3 <= 64) {
                        n2 = 1;
                    } else if (n3 == 7 || n3 == 26 || n3 >= 28 && n3 <= 32 || n3 >= 35 && n3 <= 36 || n3 == 39 || n3 == 43 || n3 >= 53 && n3 <= 57) {
                        n2 = 2;
                    } else {
                        NoViableAltException noViableAltException = new NoViableAltException("", 34, 0, (IntStream)this.input);
                        throw noViableAltException;
                    }
                    switch (n2) {
                        case 1: {
                            token = this.input.LT(1);
                            if (this.input.LA(1) < 59 || this.input.LA(1) > 64) {
                                MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                                throw mismatchedSetException;
                            }
                            this.input.consume();
                            this.state.errorRecovery = false;
                            this.pushFollow(FOLLOW_shift_expr_in_basic_formula1998);
                            object3 = this.shift_expr();
                            --this.state._fsp;
                            if (KodkodiParser.isExpression(object2)) {
                                try {
                                    if ((token != null ? token.getType() : 0) == 59) {
                                        object = this.E(token, object2).eq(this.E(token, object3));
                                        break block9;
                                    }
                                    if ((token != null ? token.getType() : 0) == 64) {
                                        object = this.E(token, object2).in(this.E(token, object3));
                                        break block9;
                                    }
                                    this.huh(token, "mismatched input '" + (token != null ? token.getText() : null) + "' expecting EQ or IN");
                                    object = Formula.FALSE;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    int n4 = this.E(token, object2).arity();
                                    int n5 = this.E(token, object3).arity();
                                    if (n4 == n5) {
                                        this.panic();
                                        break block9;
                                    }
                                    this.huh(token, "arity mismatch (" + n4 + " vs. " + n5 + ")");
                                }
                                break block9;
                            }
                            if (KodkodiParser.isIntExpression(object2)) {
                                if ((token != null ? token.getType() : 0) != 64) {
                                    object = this.I(token, object2).compare((token != null ? token.getType() : 0) == 59 ? IntCompOperator.EQ : ((token != null ? token.getType() : 0) == 60 ? IntCompOperator.LT : ((token != null ? token.getType() : 0) == 61 ? IntCompOperator.LTE : ((token != null ? token.getType() : 0) == 62 ? IntCompOperator.GT : IntCompOperator.GTE))), this.I(token, object3));
                                    break block9;
                                }
                                this.huh(token, "mismatched input 'in' expecting EQ, LT, GT, etc.");
                                object = Formula.FALSE;
                                break block9;
                            }
                            this.huh(token, "operands may not be formulas");
                            break block9;
                        }
                        case 2: {
                            object = object2;
                        }
                    }
                    break;
                }
                case 4: {
                    this.pushFollow(FOLLOW_multiplicity_in_basic_formula2021);
                    multiplicity_return2 = this.multiplicity();
                    --this.state._fsp;
                    this.pushFollow(FOLLOW_add_expr_in_basic_formula2027);
                    object2 = this.add_expr();
                    --this.state._fsp;
                    if ((multiplicity_return2 != null ? multiplicity_return2.value : null) != Multiplicity.SET) {
                        object = this.E(multiplicity_return2 != null ? multiplicity_return2.token : null, object2).apply(multiplicity_return2 != null ? multiplicity_return2.value : null);
                        break;
                    }
                    this.huh(multiplicity_return2 != null ? multiplicity_return2.token : null, "invalid multiplicity 'set'");
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object predicate_formula() throws RecognitionException {
        Formula formula = null;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Token token8 = null;
        Token token9 = null;
        Object object = null;
        Object object2 = null;
        try {
            int n = 3;
            switch (this.input.LA(1)) {
                case 65: {
                    n = 1;
                    break;
                }
                case 66: {
                    n = 2;
                    break;
                }
                case 69: {
                    n = 3;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 36, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 65, FOLLOW_ACYCLIC_in_predicate_formula2051);
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_predicate_formula2053);
                    token2 = (Token)this.match((IntStream)this.input, 24, FOLLOW_RELATION_NAME_in_predicate_formula2059);
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_predicate_formula2061);
                    try {
                        formula = this.getRelation(token2).acyclic();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token, "invalid arity");
                    }
                    break;
                }
                case 2: {
                    token3 = (Token)this.match((IntStream)this.input, 66, FOLLOW_FUNCTION_in_predicate_formula2079);
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_predicate_formula2081);
                    token2 = (Token)this.match((IntStream)this.input, 24, FOLLOW_RELATION_NAME_in_predicate_formula2087);
                    token4 = (Token)this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_predicate_formula2093);
                    this.pushFollow(FOLLOW_expr_in_predicate_formula2099);
                    object = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 36, FOLLOW_ARROW_in_predicate_formula2101);
                    token5 = this.input.LT(1);
                    if (this.input.LA(1) < 67 || this.input.LA(1) > 68) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.pushFollow(FOLLOW_expr_in_predicate_formula2127);
                    object2 = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_predicate_formula2129);
                    try {
                        Relation relation = this.getRelation(token2);
                        formula = (token5 != null ? token5.getType() : 0) == 67 ? relation.function(this.E(token4, object), this.E(token5, object2)) : relation.partialFunction(this.E(token4, object), this.E(token5, object2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "invalid arity");
                    }
                    break;
                }
                case 3: {
                    token5 = (Token)this.match((IntStream)this.input, 69, FOLLOW_TOTAL_ORDERING_in_predicate_formula2147);
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_predicate_formula2149);
                    token6 = (Token)this.match((IntStream)this.input, 24, FOLLOW_RELATION_NAME_in_predicate_formula2155);
                    this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_predicate_formula2157);
                    token7 = this.input.LT(1);
                    if (this.input.LA(1) != 19 && this.input.LA(1) != 24 && this.input.LA(1) != 37) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_predicate_formula2183);
                    token8 = this.input.LT(1);
                    if (this.input.LA(1) != 24 && this.input.LA(1) != 46) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_predicate_formula2205);
                    token9 = this.input.LT(1);
                    if (this.input.LA(1) != 24 && this.input.LA(1) != 46) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_predicate_formula2227);
                    try {
                        formula = this.getRelation(token6).totalOrder(this.getRelation(token7), this.getRelation(token8), this.getRelation(token9));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token5, "invalid arity");
                    }
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return formula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object shift_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_add_expr_in_shift_expr2251);
            object2 = this.add_expr();
            --this.state._fsp;
            object = object2;
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 >= 70 && n2 <= 72) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        token = this.input.LT(1);
                        if (this.input.LA(1) < 70 || this.input.LA(1) > 72) {
                            MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                            throw mismatchedSetException;
                        }
                        this.input.consume();
                        this.state.errorRecovery = false;
                        this.pushFollow(FOLLOW_add_expr_in_shift_expr2284);
                        object3 = this.add_expr();
                        --this.state._fsp;
                        object = this.I(token, object).compose((token != null ? token.getType() : 0) == 70 ? IntOperator.SHL : ((token != null ? token.getType() : 0) == 71 ? IntOperator.SHA : IntOperator.SHR), this.I(token, object3));
                        continue block7;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object add_expr() throws RecognitionException {
        Object object;
        block15: {
            object = null;
            Token token = null;
            Object object2 = null;
            Object object3 = null;
            try {
                this.pushFollow(FOLLOW_mult_expr_in_add_expr2310);
                object2 = this.mult_expr();
                --this.state._fsp;
                object = object2;
                block9: while (true) {
                    int n = 2;
                    int n2 = this.input.LA(1);
                    if (n2 >= 33 && n2 <= 34) {
                        n = 1;
                    }
                    switch (n) {
                        case 1: {
                            token = this.input.LT(1);
                            if (this.input.LA(1) < 33 || this.input.LA(1) > 34) {
                                MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                                throw mismatchedSetException;
                            }
                            this.input.consume();
                            this.state.errorRecovery = false;
                            this.pushFollow(FOLLOW_mult_expr_in_add_expr2339);
                            object3 = this.mult_expr();
                            --this.state._fsp;
                            if (KodkodiParser.isExpression(object)) {
                                try {
                                    object = this.E(token, object).compose((token != null ? token.getType() : 0) == 33 ? ExprOperator.UNION : ExprOperator.DIFFERENCE, this.E(token, object3));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    int n3 = this.E(token, object).arity();
                                    int n4 = this.E(token, object3).arity();
                                    if (n3 == n4) {
                                        this.panic();
                                        break;
                                    }
                                    this.huh(token, "arity mismatch (" + n3 + " vs. " + n4 + ")");
                                }
                                continue block9;
                            }
                            if (KodkodiParser.isIntExpression(object)) {
                                object = this.I(token, object).compose((token != null ? token.getType() : 0) == 33 ? IntOperator.PLUS : IntOperator.MINUS, this.I(token, object3));
                                break;
                            }
                            this.huh(token, "operands may not be formulas");
                            break;
                        }
                        default: {
                            break block15;
                        }
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover((IntStream)this.input, recognitionException);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object mult_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_expr_to_int_cast_in_mult_expr2365);
            object2 = this.expr_to_int_cast();
            --this.state._fsp;
            object = object2;
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 >= 73 && n2 <= 75) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        token = this.input.LT(1);
                        if (this.input.LA(1) < 73 || this.input.LA(1) > 75) {
                            MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                            throw mismatchedSetException;
                        }
                        this.input.consume();
                        this.state.errorRecovery = false;
                        this.pushFollow(FOLLOW_expr_to_int_cast_in_mult_expr2398);
                        object3 = this.expr_to_int_cast();
                        --this.state._fsp;
                        object = this.I(token, object).compose((token != null ? token.getType() : 0) == 73 ? IntOperator.MULTIPLY : ((token != null ? token.getType() : 0) == 74 ? IntOperator.DIVIDE : IntOperator.MODULO), this.I(token, object3));
                        continue block7;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object expr_to_int_cast() throws RecognitionException {
        Object object = null;
        Token token = null;
        Token token2 = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        try {
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 42 || n2 == 50) {
                n = 1;
            } else if (n2 == 9 || n2 >= 14 && n2 <= 15 || n2 >= 18 && n2 <= 19 || n2 == 24 || n2 >= 28 && n2 <= 30 || n2 == 34 || n2 >= 37 && n2 <= 38 || n2 == 40 || n2 == 44 || n2 == 46 || n2 == 73 || n2 == 76 || n2 >= 81 && n2 <= 88) {
                n = 2;
            } else {
                NoViableAltException noViableAltException = new NoViableAltException("", 42, 0, (IntStream)this.input);
                throw noViableAltException;
            }
            block5 : switch (n) {
                case 1: {
                    token = this.input.LT(1);
                    if (this.input.LA(1) != 42 && this.input.LA(1) != 50) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_expr_to_int_cast2432);
                    this.pushFollow(FOLLOW_expr_in_expr_to_int_cast2438);
                    object2 = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_expr_to_int_cast2440);
                    try {
                        object = this.E(token, object2).apply((token != null ? token.getType() : 0) == 42 ? ExprCastOperator.CARDINALITY : ExprCastOperator.SUM);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token, "illegal arity");
                    }
                    break;
                }
                case 2: {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    this.pushFollow(FOLLOW_product_expr_in_expr_to_int_cast2458);
                    object3 = this.product_expr();
                    --this.state._fsp;
                    object = object3;
                    block20: while (true) {
                        n6 = 2;
                        n5 = this.input.LA(1);
                        if (n5 == 48 || n5 >= 76 && n5 <= 77) {
                            n6 = 1;
                        }
                        switch (n6) {
                            case 1: {
                                token2 = this.input.LT(1);
                                if (this.input.LA(1) != 48 && (this.input.LA(1) < 76 || this.input.LA(1) > 77)) {
                                    MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                                    throw mismatchedSetException;
                                }
                                this.input.consume();
                                this.state.errorRecovery = false;
                                this.pushFollow(FOLLOW_product_expr_in_expr_to_int_cast2491);
                                object4 = this.product_expr();
                                --this.state._fsp;
                                if ((token2 != null ? token2.getType() : 0) == 48) {
                                    object = this.I(token2, object).or(this.I(token2, object4));
                                    break;
                                }
                                if ((token2 != null ? token2.getType() : 0) == 76) {
                                    object = this.I(token2, object).xor(this.I(token2, object4));
                                    break;
                                }
                                if (KodkodiParser.isExpression(object)) {
                                    try {
                                        object = this.E(token2, object).intersection(this.E(token2, object4));
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        n4 = this.E(token2, object).arity();
                                        n3 = this.E(token2, object4).arity();
                                        if (n4 == n3) {
                                            this.panic();
                                            break;
                                        }
                                        this.huh(token2, "arity mismatch (" + n4 + " vs. " + n3 + ")");
                                    }
                                    continue block20;
                                }
                                if (KodkodiParser.isIntExpression(object)) {
                                    object = this.I(token2, object).and(this.I(token2, object4));
                                    break;
                                }
                                this.huh(token2, "operands may not be formulas");
                                break;
                            }
                            default: {
                                break block20;
                            }
                        }
                    }
                    n6 = 2;
                    n5 = this.input.LA(1);
                    if (n5 == 78) {
                        n6 = 1;
                    }
                    switch (n6) {
                        case 1: {
                            token2 = (Token)this.match((IntStream)this.input, 78, FOLLOW_OVERRIDE_in_expr_to_int_cast2502);
                            this.pushFollow(FOLLOW_expr_to_int_cast_in_expr_to_int_cast2508);
                            object4 = this.expr_to_int_cast();
                            --this.state._fsp;
                            try {
                                object = this.E(token2, object).override(this.E(token2, object4));
                                break block5;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                n4 = this.E(token2, object).arity();
                                n3 = this.E(token2, object4).arity();
                                if (n4 == n3) {
                                    this.panic();
                                    break block5;
                                }
                                this.huh(token2, "arity mismatch (" + n4 + " vs. " + n3 + ")");
                            }
                        }
                    }
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object product_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            int n;
            this.pushFollow(FOLLOW_ifno_expr_in_product_expr2534);
            object2 = this.ifno_expr();
            --this.state._fsp;
            object = object2;
            int n2 = 2;
            int n3 = this.input.LA(1);
            if (n3 == 36 && ((n = this.input.LA(2)) == 9 || n >= 14 && n <= 15 || n >= 18 && n <= 19 || n == 24 || n >= 28 && n <= 30 || n == 34 || n >= 37 && n <= 38 || n == 40 || n == 44 || n == 46 || n == 73 || n == 76 || n >= 81 && n <= 88)) {
                n2 = 1;
            }
            switch (n2) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 36, FOLLOW_ARROW_in_product_expr2551);
                    this.pushFollow(FOLLOW_product_expr_tail_in_product_expr2557);
                    object3 = this.product_expr_tail(token, new SingletonArrayList<Expression>(this.E(token, object)));
                    --this.state._fsp;
                    object = object3;
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object product_expr_tail(Token token, List<Expression> list) throws RecognitionException {
        void var3_6;
        Object var3_3 = null;
        Object object = null;
        Object object2 = null;
        try {
            int n;
            block14: {
                int n2;
                block15: {
                    this.pushFollow(FOLLOW_ifno_expr_in_product_expr_tail2598);
                    object = this.ifno_expr();
                    --this.state._fsp;
                    list.add(this.E(token, object));
                    n = 2;
                    n2 = this.input.LA(1);
                    if (n2 != 36) break block15;
                    int n3 = this.input.LA(2);
                    if (n3 >= 67 && n3 <= 68) {
                        n = 2;
                        break block14;
                    } else if (n3 == 9 || n3 >= 14 && n3 <= 15 || n3 >= 18 && n3 <= 19 || n3 == 24 || n3 >= 28 && n3 <= 30 || n3 == 34 || n3 >= 37 && n3 <= 38 || n3 == 40 || n3 == 44 || n3 == 46 || n3 == 73 || n3 == 76 || n3 >= 81 && n3 <= 88) {
                        n = 1;
                        break block14;
                    } else {
                        NoViableAltException noViableAltException = new NoViableAltException("", 44, 1, (IntStream)this.input);
                        throw noViableAltException;
                    }
                }
                if (n2 == 7 || n2 == 26 || n2 >= 28 && n2 <= 35 || n2 == 39 || n2 == 43 || n2 == 48 || n2 >= 53 && n2 <= 57 || n2 >= 59 && n2 <= 64 || n2 >= 70 && n2 <= 78) {
                    n = 2;
                } else {
                    NoViableAltException noViableAltException = new NoViableAltException("", 44, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    this.match((IntStream)this.input, 36, FOLLOW_ARROW_in_product_expr_tail2611);
                    this.pushFollow(FOLLOW_product_expr_tail_in_product_expr_tail2617);
                    object2 = this.product_expr_tail(token, list);
                    --this.state._fsp;
                    Object object3 = object2;
                    return var3_6;
                }
                case 2: {
                    Expression expression = Expression.product(list);
                    return var3_6;
                }
            }
            return var3_6;
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
            return var3_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object ifno_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this.pushFollow(FOLLOW_apply_expr_in_ifno_expr2656);
            object2 = this.apply_expr();
            --this.state._fsp;
            object = object2;
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 79) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        token = (Token)this.match((IntStream)this.input, 79, FOLLOW_IFNO_in_ifno_expr2673);
                        this.pushFollow(FOLLOW_apply_expr_in_ifno_expr2679);
                        object3 = this.apply_expr();
                        --this.state._fsp;
                        object = this.E(token, object).no().thenElse(this.E(token, object3), this.E(token, object));
                        continue block7;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object apply_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        try {
            this.pushFollow(FOLLOW_project_expr_in_apply_expr2705);
            object2 = this.project_expr();
            --this.state._fsp;
            object = object2;
            block14: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 38) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        int n3;
                        token = (Token)this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_apply_expr2722);
                        this.pushFollow(FOLLOW_expr_in_apply_expr2728);
                        object3 = this.expr();
                        --this.state._fsp;
                        try {
                            object = this.E(token, object3).join(this.E(token, object));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            n3 = this.E(token, object).arity();
                            int n4 = this.E(token, object3).arity();
                            if (n3 + n4 > 2) {
                                this.panic();
                            }
                            this.huh(token, "illegal arities (1 and 1)");
                        }
                        block15: while (true) {
                            int n5 = 2;
                            n3 = this.input.LA(1);
                            if (n3 == 7) {
                                n5 = 1;
                            }
                            switch (n5) {
                                case 1: {
                                    this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_apply_expr2733);
                                    this.pushFollow(FOLLOW_expr_in_apply_expr2739);
                                    object4 = this.expr();
                                    --this.state._fsp;
                                    try {
                                        object = this.E(token, object4).join(this.E(token, object));
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        int n6 = this.E(token, object).arity();
                                        int n7 = this.E(token, object4).arity();
                                        if (n6 + n7 > 2) {
                                            this.panic();
                                            break;
                                        }
                                        this.huh(token, "illegal arities (1 and 1)");
                                    }
                                    continue block15;
                                }
                                default: {
                                    break block15;
                                }
                            }
                        }
                        this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_apply_expr2745);
                        continue block14;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object project_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Object object2 = null;
        Object object3 = null;
        project_columns_return project_columns_return2 = null;
        try {
            int n;
            int n2;
            this.pushFollow(FOLLOW_basic_expr_in_project_expr2769);
            object2 = this.basic_expr();
            --this.state._fsp;
            object = object2;
            block12: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 80) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        token = (Token)this.match((IntStream)this.input, 80, FOLLOW_DOT_in_project_expr2786);
                        this.pushFollow(FOLLOW_basic_expr_in_project_expr2792);
                        object3 = this.basic_expr();
                        --this.state._fsp;
                        try {
                            object = this.E(token, object).join(this.E(token, object3));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            int n3 = this.E(token, object).arity();
                            int n4 = this.E(token, object3).arity();
                            if (n3 + n4 > 2) {
                                this.panic();
                                break;
                            }
                            this.huh(token, "illegal arities (1 and 1)");
                        }
                        continue block12;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            block13: while (true) {
                n2 = 2;
                n = this.input.LA(1);
                if (n == 25) {
                    n2 = 1;
                }
                switch (n2) {
                    case 1: {
                        this.pushFollow(FOLLOW_project_columns_in_project_expr2803);
                        project_columns_return2 = this.project_columns();
                        --this.state._fsp;
                        IntExpression[] intExpressionArray = new IntExpression[(project_columns_return2 != null ? project_columns_return2.nodes : null).size()];
                        (project_columns_return2 != null ? project_columns_return2.nodes : null).toArray(intExpressionArray);
                        object = this.E(project_columns_return2 != null ? project_columns_return2.token : null, object).project(intExpressionArray);
                        continue block13;
                    }
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object basic_expr() throws RecognitionException {
        Object object = null;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Object object2 = null;
        Decls decls = null;
        try {
            int n = 16;
            switch (this.input.LA(1)) {
                case 38: {
                    n = 1;
                    break;
                }
                case 19: 
                case 24: 
                case 37: 
                case 46: {
                    n = 2;
                    break;
                }
                case 81: {
                    n = 3;
                    break;
                }
                case 28: {
                    n = 4;
                    break;
                }
                case 29: {
                    n = 5;
                    break;
                }
                case 30: {
                    n = 6;
                    break;
                }
                case 9: {
                    n = 7;
                    break;
                }
                case 15: {
                    n = 8;
                    break;
                }
                case 14: {
                    n = 9;
                    break;
                }
                case 82: {
                    n = 10;
                    break;
                }
                case 83: {
                    n = 11;
                    break;
                }
                case 44: {
                    n = 12;
                    break;
                }
                case 18: {
                    n = 13;
                    break;
                }
                case 34: 
                case 73: 
                case 76: 
                case 84: 
                case 85: 
                case 86: {
                    n = 14;
                    break;
                }
                case 40: {
                    n = 15;
                    break;
                }
                case 87: 
                case 88: {
                    n = 16;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 50, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    this.match((IntStream)this.input, 38, FOLLOW_PAREN_LEFT_in_basic_expr2825);
                    this.pushFollow(FOLLOW_expr_in_basic_expr2831);
                    object2 = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 39, FOLLOW_PAREN_RIGHT_in_basic_expr2833);
                    object = object2;
                    break;
                }
                case 2: {
                    token = this.input.LT(1);
                    if (this.input.LA(1) != 19 && this.input.LA(1) != 24 && this.input.LA(1) != 37 && this.input.LA(1) != 46) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    object = this.getRelation(token);
                    break;
                }
                case 3: {
                    token = (Token)this.match((IntStream)this.input, 81, FOLLOW_VARIABLE_NAME_in_basic_expr2895);
                    object = this.getVariable(token);
                    break;
                }
                case 4: {
                    token2 = (Token)this.match((IntStream)this.input, 28, FOLLOW_FORMULA_REG_in_basic_expr2913);
                    object = this.getFormulaReg(token2);
                    break;
                }
                case 5: {
                    token2 = (Token)this.match((IntStream)this.input, 29, FOLLOW_REL_EXPR_REG_in_basic_expr2931);
                    object = this.getExprReg(token2);
                    break;
                }
                case 6: {
                    token2 = (Token)this.match((IntStream)this.input, 30, FOLLOW_INT_EXPR_REG_in_basic_expr2949);
                    object = this.getIntExprReg(token2);
                    break;
                }
                case 7: {
                    token = (Token)this.match((IntStream)this.input, 9, FOLLOW_NUM_in_basic_expr2967);
                    object = this.getIntConstant(token);
                    break;
                }
                case 8: {
                    this.match((IntStream)this.input, 15, FOLLOW_FALSE_in_basic_expr2981);
                    object = Formula.FALSE;
                    break;
                }
                case 9: {
                    this.match((IntStream)this.input, 14, FOLLOW_TRUE_in_basic_expr2995);
                    object = Formula.TRUE;
                    break;
                }
                case 10: {
                    this.match((IntStream)this.input, 82, FOLLOW_IDEN_in_basic_expr3009);
                    object = Expression.IDEN;
                    break;
                }
                case 11: {
                    this.match((IntStream)this.input, 83, FOLLOW_INTS_in_basic_expr3023);
                    object = Expression.INTS;
                    break;
                }
                case 12: {
                    this.match((IntStream)this.input, 44, FOLLOW_NONE_in_basic_expr3037);
                    object = Expression.NONE;
                    break;
                }
                case 13: {
                    this.match((IntStream)this.input, 18, FOLLOW_UNIV_in_basic_expr3051);
                    object = Expression.UNIV;
                    break;
                }
                case 14: {
                    token3 = this.input.LT(1);
                    if (this.input.LA(1) != 34 && this.input.LA(1) != 73 && this.input.LA(1) != 76 && (this.input.LA(1) < 84 || this.input.LA(1) > 86)) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.pushFollow(FOLLOW_basic_expr_in_basic_expr3097);
                    object2 = this.basic_expr();
                    --this.state._fsp;
                    if (KodkodiParser.isExpression(object2)) {
                        try {
                            if ((token3 != null ? token3.getType() : 0) == 76) {
                                object = this.E(token3, object2).closure();
                                break;
                            }
                            if ((token3 != null ? token3.getType() : 0) == 73) {
                                object = this.E(token3, object2).reflexiveClosure();
                                break;
                            }
                            if ((token3 != null ? token3.getType() : 0) == 84) {
                                object = this.E(token3, object2).transpose();
                                break;
                            }
                            this.huh(token3, "mismatched input '" + (token3 != null ? token3.getText() : null) + "' expecting HAT, STAR, or TILDE");
                            object = Formula.FALSE;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (this.E(token3, object2).arity() == 2) {
                                this.panic();
                                break;
                            }
                            this.huh(token3, "illegal arity");
                        }
                        break;
                    }
                    if (KodkodiParser.isIntExpression(object2)) {
                        if ((token3 != null ? token3.getType() : 0) == 85) {
                            object = this.I(token3, object2).abs();
                            break;
                        }
                        if ((token3 != null ? token3.getType() : 0) == 86) {
                            object = this.I(token3, object2).signum();
                            break;
                        }
                        if ((token3 != null ? token3.getType() : 0) == 34) {
                            object = this.I(token3, object2).negate();
                            break;
                        }
                        if ((token3 != null ? token3.getType() : 0) == 84) {
                            object = this.I(token3, object2).not();
                            break;
                        }
                        this.huh(token3, "mismatched input '" + (token3 != null ? token3.getText() : null) + "' expecting ABS, SGN, MINUS, or TILDE");
                        object = IntConstant.constant((int)0);
                        break;
                    }
                    this.huh(token3, "operands may not be formulas");
                    break;
                }
                case 15: {
                    this.match((IntStream)this.input, 40, FOLLOW_BRACE_LEFT_in_basic_expr3111);
                    this.pushFollow(FOLLOW_decls_in_basic_expr3117);
                    decls = this.decls();
                    --this.state._fsp;
                    token3 = (Token)this.match((IntStream)this.input, 48, FOLLOW_BAR_in_basic_expr3123);
                    this.pushFollow(FOLLOW_expr_in_basic_expr3129);
                    object2 = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 43, FOLLOW_BRACE_RIGHT_in_basic_expr3131);
                    try {
                        object = this.F(token3, object2).comprehension(decls);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.huh(token3, "expected declarations with multiplicity 'one'");
                    }
                    catch (NullPointerException nullPointerException) {
                        this.huh(token3, "expected at least one declaration");
                    }
                    break;
                }
                case 16: {
                    token3 = this.input.LT(1);
                    if (this.input.LA(1) < 87 || this.input.LA(1) > 88) {
                        MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                        throw mismatchedSetException;
                    }
                    this.input.consume();
                    this.state.errorRecovery = false;
                    this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_basic_expr3157);
                    this.pushFollow(FOLLOW_expr_in_basic_expr3163);
                    object2 = this.expr();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_basic_expr3165);
                    object = this.I(token3, object2).cast((token3 != null ? token3.getType() : 0) == 87 ? IntCastOperator.BITSETCAST : IntCastOperator.INTCAST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Decls decls() throws RecognitionException {
        Decl decl = null;
        Decl decl2 = null;
        Decl decl3 = null;
        try {
            this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_decls3186);
            int n = 2;
            int n2 = this.input.LA(1);
            if (n2 == 81) {
                n = 1;
            }
            switch (n) {
                case 1: {
                    this.pushFollow(FOLLOW_decl_in_decls3201);
                    decl2 = this.decl();
                    --this.state._fsp;
                    decl = decl2;
                    block10: while (true) {
                        int n3 = 2;
                        int n4 = this.input.LA(1);
                        if (n4 == 7) {
                            n3 = 1;
                        }
                        switch (n3) {
                            case 1: {
                                this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_decls3215);
                                this.pushFollow(FOLLOW_decl_in_decls3221);
                                decl3 = this.decl();
                                --this.state._fsp;
                                decl = decl.and((Decls)decl3);
                                continue block10;
                            }
                        }
                        break;
                    }
                    break;
                }
            }
            this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_decls3237);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return decl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Decl decl() throws RecognitionException {
        Decl decl = null;
        Token token = null;
        Token token2 = null;
        multiplicity_return multiplicity_return2 = null;
        Object object = null;
        try {
            token = (Token)this.match((IntStream)this.input, 81, FOLLOW_VARIABLE_NAME_in_decl3259);
            token2 = (Token)this.match((IntStream)this.input, 5, FOLLOW_COLON_in_decl3265);
            this.pushFollow(FOLLOW_multiplicity_in_decl3271);
            multiplicity_return2 = this.multiplicity();
            --this.state._fsp;
            this.pushFollow(FOLLOW_expr_in_decl3277);
            object = this.expr();
            --this.state._fsp;
            try {
                decl = this.getVariable(token).declare(multiplicity_return2 != null ? multiplicity_return2.value : null, this.E(token2, object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.huh(token2, "invalid bound: " + KodkodiParser.fixedMessage(illegalArgumentException));
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return decl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final assigns_return assigns() throws RecognitionException {
        assigns_return assigns_return2 = new assigns_return();
        assigns_return2.start = this.input.LT(1);
        try {
            int n;
            this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_assigns3297);
            this.pushFollow(FOLLOW_assign_in_assigns3299);
            this.assign(assigns_return2.tokens, assigns_return2.oldNodes, assigns_return2.newNodes);
            --this.state._fsp;
            block7: while (true) {
                n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 7) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_assigns3311);
                        this.pushFollow(FOLLOW_assign_in_assigns3313);
                        this.assign(assigns_return2.tokens, assigns_return2.oldNodes, assigns_return2.newNodes);
                        --this.state._fsp;
                        continue block7;
                    }
                }
                break;
            }
            this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_assigns3318);
            for (n = 0; n < assigns_return2.tokens.size(); ++n) {
                this.setReg(assigns_return2.tokens.elementAt(n), assigns_return2.newNodes.elementAt(n));
            }
            assigns_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return assigns_return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assign(Vector<Token> vector, Vector<Node> vector2, Vector<Node> vector3) throws RecognitionException {
        Token token = null;
        Token token2 = null;
        Object object = null;
        try {
            int n = 3;
            switch (this.input.LA(1)) {
                case 28: {
                    n = 1;
                    break;
                }
                case 29: {
                    n = 2;
                    break;
                }
                case 30: {
                    n = 3;
                    break;
                }
                default: {
                    NoViableAltException noViableAltException = new NoViableAltException("", 54, 0, (IntStream)this.input);
                    throw noViableAltException;
                }
            }
            switch (n) {
                case 1: {
                    token = (Token)this.match((IntStream)this.input, 28, FOLLOW_FORMULA_REG_in_assign3339);
                    token2 = (Token)this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_assign3345);
                    this.pushFollow(FOLLOW_expr_in_assign3351);
                    object = this.expr();
                    --this.state._fsp;
                    int n2 = this.id(token != null ? token.getText() : null);
                    vector.add(token);
                    vector2.add((Node)(n2 < this.formulas.size() ? this.formulas.elementAt(n2) : null));
                    vector3.add((Node)this.F(token2, object));
                    break;
                }
                case 2: {
                    token = (Token)this.match((IntStream)this.input, 29, FOLLOW_REL_EXPR_REG_in_assign3369);
                    token2 = (Token)this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_assign3375);
                    this.pushFollow(FOLLOW_expr_in_assign3381);
                    object = this.expr();
                    --this.state._fsp;
                    int n3 = this.id(token != null ? token.getText() : null);
                    vector.add(token);
                    vector2.add((Node)(n3 < this.exprs.size() ? this.exprs.elementAt(n3) : null));
                    vector3.add((Node)this.E(token2, object));
                    break;
                }
                case 3: {
                    token = (Token)this.match((IntStream)this.input, 30, FOLLOW_INT_EXPR_REG_in_assign3399);
                    token2 = (Token)this.match((IntStream)this.input, 21, FOLLOW_COLON_EQ_in_assign3405);
                    this.pushFollow(FOLLOW_expr_in_assign3411);
                    object = this.expr();
                    --this.state._fsp;
                    int n4 = this.id(token != null ? token.getText() : null);
                    vector.add(token);
                    vector2.add((Node)(n4 < this.intExprs.size() ? this.intExprs.elementAt(n4) : null));
                    vector3.add((Node)this.I(token2, object));
                }
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final multiplicity_return multiplicity() throws RecognitionException {
        multiplicity_return multiplicity_return2 = new multiplicity_return();
        multiplicity_return2.start = this.input.LT(1);
        Token token = null;
        try {
            token = this.input.LT(1);
            if (!(this.input.LA(1) == 49 || this.input.LA(1) >= 67 && this.input.LA(1) <= 68 || this.input.LA(1) >= 89 && this.input.LA(1) <= 90)) {
                MismatchedSetException mismatchedSetException = new MismatchedSetException(null, (IntStream)this.input);
                throw mismatchedSetException;
            }
            this.input.consume();
            this.state.errorRecovery = false;
            multiplicity_return2.token = token;
            switch (token != null ? token.getType() : 0) {
                case 89: {
                    multiplicity_return2.value = Multiplicity.NO;
                    break;
                }
                case 68: {
                    multiplicity_return2.value = Multiplicity.LONE;
                    break;
                }
                case 67: {
                    multiplicity_return2.value = Multiplicity.ONE;
                    break;
                }
                case 49: {
                    multiplicity_return2.value = Multiplicity.SOME;
                    break;
                }
                case 90: {
                    multiplicity_return2.value = Multiplicity.SET;
                }
            }
            multiplicity_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return multiplicity_return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final project_columns_return project_columns() throws RecognitionException {
        project_columns_return project_columns_return2 = new project_columns_return();
        project_columns_return2.start = this.input.LT(1);
        Token token = null;
        Token token2 = null;
        Object object = null;
        Object object2 = null;
        try {
            token = (Token)this.match((IntStream)this.input, 25, FOLLOW_BRACKET_LEFT_in_project_columns3484);
            this.pushFollow(FOLLOW_expr_in_project_columns3490);
            object = this.expr();
            --this.state._fsp;
            project_columns_return2.token = token;
            project_columns_return2.nodes.add(this.I(token, object));
            block7: while (true) {
                int n = 2;
                int n2 = this.input.LA(1);
                if (n2 == 7) {
                    n = 1;
                }
                switch (n) {
                    case 1: {
                        token2 = (Token)this.match((IntStream)this.input, 7, FOLLOW_COMMA_in_project_columns3499);
                        this.pushFollow(FOLLOW_expr_in_project_columns3505);
                        object2 = this.expr();
                        --this.state._fsp;
                        project_columns_return2.nodes.add(this.I(token2, object2));
                        continue block7;
                    }
                }
                break;
            }
            this.match((IntStream)this.input, 26, FOLLOW_BRACKET_RIGHT_in_project_columns3519);
            project_columns_return2.stop = this.input.LT(-1);
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover((IntStream)this.input, recognitionException);
        }
        return project_columns_return2;
    }

    public static class project_columns_return
    extends ParserRuleReturnScope {
        public Token token;
        public Vector<IntExpression> nodes = new Vector();
    }

    public static class multiplicity_return
    extends ParserRuleReturnScope {
        public Token token;
        public Multiplicity value;
    }

    public static class assigns_return
    extends ParserRuleReturnScope {
        public Vector<Token> tokens = new Vector();
        public Vector<Node> oldNodes = new Vector();
        public Vector<Node> newNodes = new Vector();
    }

    public static class tuple_return
    extends ParserRuleReturnScope {
        public Tuple value;
        public List<Object> atoms;
    }

    public static class basic_tuple_set_return
    extends ParserRuleReturnScope {
        public TupleSet value;
        public List<Tuple> list = new ArrayList<Tuple>();
    }

    public static class tuple_set_seq_return
    extends ParserRuleReturnScope {
        public Token token;
        public List<TupleSet> value = new ArrayList<TupleSet>();
    }

    public class SingletonArrayList<T>
    extends ArrayList<T> {
        public SingletonArrayList(T t) {
            this.add(t);
        }
    }

    private static final class SemanticException
    extends RecognitionException {
        String message;

        public SemanticException(Token token, String string) {
            this.token = token;
            this.line = token.getLine();
            this.charPositionInLine = token.getCharPositionInLine();
            this.message = string;
        }

        public final String getMessage() {
            return this.message;
        }
    }
}

