/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Arrays;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntSet;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;

public final class IntBitSet
extends AbstractIntSet
implements Cloneable {
    private final int capacity;
    private long[] elements;
    private int size;

    public IntBitSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity < 0");
        }
        this.capacity = n;
        this.elements = new long[(n >>> 6) + 1];
        this.size = 0;
    }

    public IntBitSet(int n, long[] lArray) {
        if (n > lArray.length << 6) {
            throw new IllegalArgumentException("capacity too large: " + n + ", max: " + (lArray.length << 6));
        }
        this.capacity = n;
        this.elements = lArray;
        this.recalculateSize();
        if (this.size > 0 && n <= this.max()) {
            throw new IllegalArgumentException("capacity too small");
        }
    }

    @Override
    public int min() {
        this.checkNonEmpty();
        int n = 0;
        while (this.elements[n] == 0L) {
            ++n;
        }
        return (n << 6) + Long.numberOfTrailingZeros(this.elements[n]);
    }

    @Override
    public int max() {
        this.checkNonEmpty();
        int n = this.elements.length - 1;
        while (this.elements[n] == 0L) {
            --n;
        }
        return (n << 6) + 63 - Long.numberOfLeadingZeros(this.elements[n]);
    }

    @Override
    public int ceil(int n) {
        if (n <= 0) {
            return this.min();
        }
        int n2 = this.wordIndex(n);
        long l = 0L;
        if (n2 < this.elements.length) {
            l = this.extendedMask(n) & this.elements[n2];
        }
        while (l == 0L && n2 < this.elements.length - 1) {
            l = this.elements[++n2];
        }
        if (l == 0L) {
            throw new NoSuchElementException();
        }
        return (n2 << 6) + Long.numberOfTrailingZeros(l);
    }

    @Override
    public int floor(int n) {
        if (n < 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.wordIndex(n);
        long l = 0L;
        if (n2 < this.elements.length) {
            l = (this.extendedMask(n + 1) ^ 0xFFFFFFFFFFFFFFFFL) & this.elements[n2];
        } else {
            n2 = this.elements.length - 1;
            l = this.elements[n2];
        }
        while (l == 0L && n2 > 0) {
            l = this.elements[--n2];
        }
        if (l == 0L) {
            throw new NoSuchElementException();
        }
        return (n2 << 6) + 63 - Long.numberOfLeadingZeros(l);
    }

    @Override
    public IntIterator iterator() {
        return new AscendingIterator(0, this.capacity);
    }

    @Override
    public IntIterator iterator(int n, int n2) {
        return n > n2 ? new DescendingIterator(n, n2) : new AscendingIterator(n, n2);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    private final int wordIndex(int n) {
        return n >>> 6;
    }

    private final long bitMask(int n) {
        return 1L << n;
    }

    private final long extendedMask(int n) {
        return -1L << n;
    }

    private final boolean allows(int n) {
        return 0 <= n && n < this.capacity;
    }

    @Override
    public boolean contains(int n) {
        return this.allows(n) && (this.elements[this.wordIndex(n)] & this.bitMask(n)) != 0L;
    }

    @Override
    public boolean add(int n) {
        if (!this.allows(n)) {
            throw new IllegalArgumentException(n + " !in [0.." + this.capacity + ")");
        }
        int n2 = this.wordIndex(n);
        long l = this.elements[n2];
        int n3 = n2;
        this.elements[n3] = this.elements[n3] | this.bitMask(n);
        if (this.elements[n2] != l) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int n) {
        if (this.allows(n)) {
            int n2 = this.wordIndex(n);
            long l = this.elements[n2];
            int n3 = n2;
            this.elements[n3] = this.elements[n3] & (this.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.elements[n2] != l) {
                --this.size;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        if (intCollection instanceof IntBitSet) {
            IntBitSet intBitSet = (IntBitSet)intCollection;
            if (this.isEmpty() || intBitSet.isEmpty()) {
                return this.isEmpty() ? intBitSet.isEmpty() : true;
            }
            if (this.size < intBitSet.size || this.max() < intBitSet.max()) {
                return false;
            }
            int n = StrictMath.min(this.elements.length, intBitSet.elements.length);
            for (int i = 0; i < n; ++i) {
                if ((intBitSet.elements[i] & (this.elements[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            return true;
        }
        return super.containsAll(intCollection);
    }

    private boolean recalculateSize() {
        int n = this.size;
        this.size = 0;
        for (long l : this.elements) {
            this.size += Long.bitCount(l);
        }
        return this.size != n;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        if (intCollection instanceof IntBitSet) {
            IntBitSet intBitSet = (IntBitSet)intCollection;
            if (intBitSet.isEmpty()) {
                return false;
            }
            if (intBitSet.max() >= this.capacity) {
                throw new IllegalArgumentException(intBitSet.max() + " !in [0.." + this.capacity + ")");
            }
            int n = StrictMath.min(this.elements.length, intBitSet.elements.length);
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.elements[n2] = this.elements[n2] | intBitSet.elements[i];
            }
            return this.recalculateSize();
        }
        return super.addAll(intCollection);
    }

    @Override
    public boolean retainAll(IntCollection intCollection) {
        if (intCollection instanceof IntBitSet) {
            int n;
            IntBitSet intBitSet = (IntBitSet)intCollection;
            int n2 = StrictMath.min(this.elements.length, intBitSet.elements.length);
            for (n = 0; n < n2; ++n) {
                int n3 = n;
                this.elements[n3] = this.elements[n3] & intBitSet.elements[n];
            }
            while (n < this.elements.length) {
                this.elements[n] = 0L;
                ++n;
            }
            return this.recalculateSize();
        }
        return super.retainAll(intCollection);
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        if (intCollection instanceof IntBitSet) {
            IntBitSet intBitSet = (IntBitSet)intCollection;
            int n = StrictMath.min(this.elements.length, intBitSet.elements.length);
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.elements[n2] = this.elements[n2] & (intBitSet.elements[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return this.recalculateSize();
        }
        return super.removeAll(intCollection);
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, 0L);
        this.size = 0;
    }

    @Override
    public IntBitSet clone() {
        try {
            IntBitSet intBitSet = (IntBitSet)super.clone();
            intBitSet.elements = (long[])this.elements.clone();
            return intBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private final class DescendingIterator
    extends AbstractIterator {
        private final long minMask;
        private final int minIndex;

        DescendingIterator(int n, int n2) {
            if (n2 >= IntBitSet.this.capacity || n < 0) {
                this.minIndex = 0;
                this.unseenIndex = 0;
                this.minMask = 0L;
                this.unseen = 0L;
            } else {
                if (n < IntBitSet.this.capacity) {
                    this.unseenIndex = IntBitSet.this.wordIndex(n);
                    this.unseen = IntBitSet.this.elements[this.unseenIndex] & (IntBitSet.this.bitMask(n) == Long.MIN_VALUE ? -1L : IntBitSet.this.extendedMask(n + 1) ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    this.unseenIndex = IntBitSet.this.elements.length - 1;
                    this.unseen = IntBitSet.this.elements[this.unseenIndex];
                }
                if (n2 < 0) {
                    this.minIndex = 0;
                    this.minMask = -1L;
                } else {
                    this.minIndex = IntBitSet.this.wordIndex(n2);
                    this.minMask = IntBitSet.this.extendedMask(n2);
                }
            }
            this.lastReturned = -1;
        }

        @Override
        public boolean hasNext() {
            while (this.unseen == 0L && this.unseenIndex > 0) {
                this.unseen = IntBitSet.this.elements[--this.unseenIndex];
            }
            return this.unseenIndex > this.minIndex && this.unseen != 0L || this.unseenIndex == this.minIndex && (this.unseen & this.minMask) != 0L;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = Long.highestOneBit(this.unseen);
            this.unseen -= l;
            this.lastReturned = (this.unseenIndex << 6) + 63 - Long.numberOfLeadingZeros(l);
            return this.lastReturned;
        }
    }

    private final class AscendingIterator
    extends AbstractIterator {
        private final long maxMask;
        private final int maxIndex;

        AscendingIterator(int n, int n2) {
            if (n >= IntBitSet.this.capacity || n2 < 0) {
                this.unseenIndex = this.maxIndex = IntBitSet.this.elements.length;
                this.maxMask = 0L;
                this.unseen = 0L;
            } else {
                if (n2 >= IntBitSet.this.capacity) {
                    this.maxIndex = IntBitSet.this.elements.length - 1;
                    this.maxMask = -1L;
                } else {
                    this.maxIndex = IntBitSet.this.wordIndex(n2);
                    long l = this.maxMask = IntBitSet.this.bitMask(n2) == Long.MIN_VALUE ? -1L : IntBitSet.this.extendedMask(n2 + 1) ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (n < 0) {
                    this.unseenIndex = 0;
                    this.unseen = IntBitSet.this.elements[0];
                } else {
                    this.unseenIndex = IntBitSet.this.wordIndex(n);
                    this.unseen = IntBitSet.this.elements[this.unseenIndex] & IntBitSet.this.extendedMask(n);
                }
            }
            this.lastReturned = -1;
        }

        @Override
        public boolean hasNext() {
            while (this.unseen == 0L && this.unseenIndex < IntBitSet.this.elements.length - 1) {
                this.unseen = IntBitSet.this.elements[++this.unseenIndex];
            }
            return this.unseenIndex < this.maxIndex && this.unseen != 0L || this.unseenIndex == this.maxIndex && (this.unseen & this.maxMask) != 0L;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = Long.lowestOneBit(this.unseen);
            this.unseen -= l;
            this.lastReturned = (this.unseenIndex << 6) + Long.numberOfTrailingZeros(l);
            return this.lastReturned;
        }
    }

    private abstract class AbstractIterator
    implements IntIterator {
        long unseen;
        int unseenIndex;
        int lastReturned;

        private AbstractIterator() {
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            long[] lArray = IntBitSet.this.elements;
            int n = IntBitSet.this.wordIndex(this.lastReturned);
            lArray[n] = lArray[n] - IntBitSet.this.bitMask(this.lastReturned);
            IntBitSet.this.size--;
            this.lastReturned = -1;
        }
    }
}

