/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Containers {
    private static Comparator<Object> identityComparator;
    private static Comparator<Object> hashComparator;

    private Containers() {
    }

    public static final <T, E extends T> Iterator<T> iterate(E ... EArray) {
        return new AscendingArrayIterator(0, EArray.length, EArray);
    }

    public static final <T, E extends T> Iterator<T> iterate(int n, int n2, E ... EArray) {
        if (n < n2) {
            return new AscendingArrayIterator(n, n2, EArray);
        }
        if (n > n2) {
            return new DescendingArrayIterator(n, n2, EArray);
        }
        return Containers.emptyIterator();
    }

    public static final <T> Iterator<T> emptyIterator() {
        return Collections.emptySet().iterator();
    }

    public static final <T> T[] copy(T[] TArray, int n, T[] TArray2, int n2, int n3) {
        System.arraycopy(TArray, n, TArray2, n2, n3);
        return TArray2;
    }

    public static final <T> T[] copy(T[] TArray, T[] TArray2) {
        System.arraycopy(TArray, 0, TArray2, 0, TArray.length);
        return TArray2;
    }

    public static final Comparator<Object> identityComparator() {
        if (identityComparator == null) {
            identityComparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n;
                    int n2 = System.identityHashCode(object);
                    return n2 == (n = System.identityHashCode(object2)) ? 0 : (n2 < n ? -1 : 1);
                }
            };
        }
        return identityComparator;
    }

    static final int hash(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    static final boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static final Comparator<Object> hashComparator() {
        if (hashComparator == null) {
            hashComparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n;
                    int n2 = Containers.hash(object);
                    return n2 == (n = Containers.hash(object2)) ? 0 : (n2 < n ? -1 : 1);
                }
            };
        }
        return hashComparator;
    }

    public static final <T> T[] identitySort(T[] TArray) {
        Arrays.sort(TArray, Containers.identityComparator());
        return TArray;
    }

    public static final <T> T[] hashSort(T[] TArray) {
        Arrays.sort(TArray, Containers.hashComparator());
        return TArray;
    }

    public static final int identityBinarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length - 1;
        int n3 = System.identityHashCode(object);
        while (n <= n2) {
            int n4;
            int n5 = n + n2 >>> 1;
            int n6 = System.identityHashCode(objectArray[n5]);
            if (n6 < n3) {
                n = n5 + 1;
                continue;
            }
            if (n6 > n3) {
                n2 = n5 - 1;
                continue;
            }
            if (objectArray[n5] == object) {
                return n5;
            }
            for (n4 = n5 + 1; n4 < objectArray.length && System.identityHashCode(objectArray[n4]) == n3; ++n4) {
                if (objectArray[n4] != object) continue;
                return n4;
            }
            for (n4 = n5 - 1; n4 >= 0 && System.identityHashCode(objectArray[n4]) == n3; --n4) {
                if (objectArray[n4] != object) continue;
                return n4;
            }
            return -(n5 + 1);
        }
        return -(n + 1);
    }

    public static final int hashBinarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length - 1;
        int n3 = Containers.hash(object);
        while (n <= n2) {
            int n4;
            int n5 = n + n2 >>> 1;
            int n6 = Containers.hash(objectArray[n5]);
            if (n6 < n3) {
                n = n5 + 1;
                continue;
            }
            if (n6 > n3) {
                n2 = n5 - 1;
                continue;
            }
            if (Containers.eq(objectArray[n5], object)) {
                return n5;
            }
            for (n4 = n5 + 1; n4 < objectArray.length && Containers.hash(objectArray[n4]) == n3; ++n4) {
                if (!Containers.eq(objectArray[n4], object)) continue;
                return n4;
            }
            for (n4 = n5 - 1; n4 >= 0 && Containers.hash(objectArray[n4]) == n3; --n4) {
                if (!Containers.eq(objectArray[n4], object)) continue;
                return n4;
            }
            return -(n5 + 1);
        }
        return -(n + 1);
    }

    public static final <T> Set<T> asIdentitySet(final T[] TArray) {
        return new AbstractSet<T>(){

            @Override
            public boolean contains(Object object) {
                return Containers.identityBinarySearch(TArray, object) >= 0;
            }

            @Override
            public Iterator<T> iterator() {
                return Containers.iterate(TArray);
            }

            @Override
            public int size() {
                return TArray.length;
            }

            @Override
            public int hashCode() {
                int n = 0;
                for (Object object : TArray) {
                    n += System.identityHashCode(object);
                }
                return n;
            }
        };
    }

    public static final <T> Set<T> asHashSet(final T[] TArray) {
        return new AbstractSet<T>(){

            @Override
            public boolean contains(Object object) {
                return Containers.hashBinarySearch(TArray, object) >= 0;
            }

            @Override
            public Iterator<T> iterator() {
                return Containers.iterate(TArray);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    private static final class DescendingArrayIterator<T>
    extends ArrayIterator<T> {
        <E extends T> DescendingArrayIterator(int n, int n2, E[] EArray) {
            super(n, n2, EArray);
            if (n >= EArray.length || n2 < -1) {
                throw new IllegalArgumentException("start > end && (start >= items.length || end < -1)");
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor > this.end;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (T)this.items[this.cursor--];
        }
    }

    private static final class AscendingArrayIterator<T>
    extends ArrayIterator<T> {
        <E extends T> AscendingArrayIterator(int n, int n2, E[] EArray) {
            super(n, n2, EArray);
            if (n < 0 || n2 > EArray.length) {
                throw new IllegalArgumentException("start < end && (start < 0 || end > items.length)");
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= 0 && this.cursor < this.end;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (T)this.items[this.cursor++];
        }
    }

    private static abstract class ArrayIterator<T>
    implements Iterator<T> {
        final T[] items;
        final int end;
        int cursor;

        <E extends T> ArrayIterator(int n, int n2, E ... EArray) {
            this.items = EArray;
            this.cursor = n;
            this.end = n2;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

