/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kodkod.ast.BinaryFormula;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntExpression;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.Variable;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.operator.Quantifier;
import kodkod.ast.visitor.AbstractDetector;
import kodkod.ast.visitor.AbstractReplacer;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.config.Options;
import kodkod.engine.config.Reporter;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.FOL2BoolTranslator;
import kodkod.engine.fol2sat.LeafInterpreter;
import kodkod.engine.fol2sat.UnboundLeafException;
import kodkod.instance.Bounds;
import kodkod.instance.TupleSet;
import kodkod.util.nodes.AnnotatedNode;

abstract class Skolemizer
extends AbstractReplacer {
    private Environment<Expression> repEnv;
    private final LeafInterpreter interpreter;
    private final Bounds bounds;
    private final Reporter reporter;
    private final List<DeclInfo> nonSkolems;
    private final List<Decl> nonSkolemsView;
    private final List<Formula> topSkolemConstraints;
    private boolean negated;
    private int skolemDepth;

    static AnnotatedNode<Formula> skolemize(final AnnotatedNode<Formula> annotatedNode, Bounds bounds, Options options) {
        if (options.logTranslation() > 0) {
            final IdentityHashMap identityHashMap = new IdentityHashMap();
            Skolemizer skolemizer = new Skolemizer(annotatedNode, bounds, options){

                @Override
                protected Formula source(Formula formula, Node node) {
                    Node node2 = annotatedNode.sourceOf(node);
                    if (formula != node2) {
                        identityHashMap.put(formula, node2);
                    }
                    return formula;
                }
            };
            Formula formula = annotatedNode.node().accept(skolemizer);
            return formula == annotatedNode.node() ? annotatedNode : AnnotatedNode.annotate(formula, identityHashMap);
        }
        Skolemizer skolemizer = new Skolemizer((AnnotatedNode)annotatedNode, bounds, options){};
        Formula formula = annotatedNode.node().accept(skolemizer);
        return formula == annotatedNode.node() ? annotatedNode : AnnotatedNode.annotate(formula);
    }

    private Skolemizer(AnnotatedNode<Formula> annotatedNode, Bounds bounds, Options options) {
        super(annotatedNode.sharedNodes());
        AbstractDetector abstractDetector = annotatedNode.freeVariableDetector();
        AbstractDetector abstractDetector2 = annotatedNode.quantifiedFormulaDetector();
        for (Node node : annotatedNode.sharedNodes()) {
            if (((Boolean)node.accept(abstractDetector)).booleanValue() || node instanceof Formula && ((Boolean)node.accept(abstractDetector2)).booleanValue()) continue;
            this.cache.put(node, null);
        }
        this.reporter = options.reporter();
        this.bounds = bounds;
        this.interpreter = LeafInterpreter.overapproximating(bounds, options);
        this.repEnv = Environment.empty();
        this.nonSkolems = new ArrayList<DeclInfo>();
        this.nonSkolemsView = new AbstractList<Decl>(){

            @Override
            public Decl get(int n) {
                return ((DeclInfo)((Skolemizer)Skolemizer.this).nonSkolems.get((int)n)).decl;
            }

            @Override
            public int size() {
                return Skolemizer.this.nonSkolems.size();
            }
        };
        this.topSkolemConstraints = new ArrayList<Formula>();
        this.negated = false;
        this.skolemDepth = options.skolemDepth();
    }

    @Override
    protected final <N extends Node> N cache(N n, N n2) {
        if (this.cache.containsKey(n)) {
            this.cache.put(n, n2);
        }
        return n2;
    }

    protected Formula source(Formula formula, Node node) {
        return formula;
    }

    @Override
    public final Decl visit(Decl decl) {
        Decl decl2 = this.lookup(decl);
        if (decl2 != null) {
            return decl2;
        }
        int n = this.skolemDepth;
        this.skolemDepth = -1;
        Expression expression = decl.expression().accept(this);
        this.skolemDepth = n;
        decl2 = expression == decl.expression() ? decl : decl.variable().declare(decl.multiplicity(), expression);
        return this.cache(decl, decl2);
    }

    @Override
    public final Decls visit(Decls decls) {
        Decls decls2 = this.lookup(decls);
        if (decls2 == null) {
            Decl decl = null;
            boolean bl = true;
            for (Decl decl2 : decls) {
                Decl decl3 = this.visit(decl2);
                if (decl3 != decl2) {
                    bl = false;
                }
                decl = decl == null ? decl3 : decl.and(decl3);
                this.repEnv = this.repEnv.extend(decl2.variable(), decl2.variable());
            }
            decls2 = bl ? decls : decl;
            return this.cache(decls, decls2);
        }
        for (Decl decl : decls) {
            this.repEnv = this.repEnv.extend(decl.variable(), decl.variable());
        }
        return decls2;
    }

    @Override
    public final Expression visit(Variable variable) {
        Expression expression = this.repEnv.lookup(variable);
        if (expression == null) {
            throw new UnboundLeafException("Unbound variable", variable);
        }
        return expression;
    }

    @Override
    public final Expression visit(Comprehension comprehension) {
        Expression expression = this.lookup(comprehension);
        if (expression != null) {
            return expression;
        }
        Environment<Expression> environment = this.repEnv;
        Decls decls = this.visit(comprehension.decls());
        Formula formula = comprehension.formula().accept(this);
        expression = decls == comprehension.decls() && formula == comprehension.formula() ? comprehension : formula.comprehension(decls);
        this.repEnv = environment;
        return this.cache(comprehension, expression);
    }

    @Override
    public final IntExpression visit(SumExpression sumExpression) {
        IntExpression intExpression = this.lookup(sumExpression);
        if (intExpression != null) {
            return intExpression;
        }
        Environment<Expression> environment = this.repEnv;
        Decls decls = this.visit(sumExpression.decls());
        IntExpression intExpression2 = sumExpression.intExpr().accept(this);
        intExpression = decls == sumExpression.decls() && intExpression2 == sumExpression.intExpr() ? sumExpression : intExpression2.sum(decls);
        this.repEnv = environment;
        return this.cache(sumExpression, intExpression);
    }

    private final BooleanMatrix upperBound(Expression expression, Environment<BooleanMatrix> environment) {
        return FOL2BoolTranslator.approximate(AnnotatedNode.annotate(expression), this.interpreter, environment);
    }

    private Expression skolemExpr(Decl decl, Relation relation) {
        int n = this.nonSkolems.size();
        int n2 = n + decl.variable().arity();
        Expression expression = relation;
        Environment<BooleanMatrix> environment = Environment.empty();
        for (DeclInfo declInfo : this.nonSkolems) {
            if (declInfo.upperBound == null) {
                declInfo.upperBound = this.upperBound(declInfo.decl.expression(), environment);
            }
            environment = environment.extend(declInfo.decl.variable(), declInfo.upperBound);
            expression = declInfo.decl.variable().join(expression);
        }
        Object object = this.upperBound(decl.expression(), environment);
        for (int i = n - 1; i >= 0; --i) {
            object = this.nonSkolems.get((int)i).upperBound.cross((BooleanMatrix)object);
        }
        TupleSet tupleSet = this.bounds.universe().factory().setOf(n2, ((BooleanMatrix)object).denseIndices());
        this.bounds.bound(relation, tupleSet);
        return expression;
    }

    private Formula domainConstraint(Decl decl, Relation relation) {
        Iterator<DeclInfo> iterator = this.nonSkolems.iterator();
        Decls decls = iterator.next().decl;
        while (iterator.hasNext()) {
            decls = decls.and(iterator.next().decl);
        }
        Expression expression = relation;
        int n = decl.variable().arity();
        for (int i = 0; i < n; ++i) {
            expression = expression.join(Expression.UNIV);
        }
        return expression.in(Formula.TRUE.comprehension(decls));
    }

    @Override
    public final Formula visit(QuantifiedFormula quantifiedFormula) {
        Formula formula = this.lookup(quantifiedFormula);
        if (formula != null) {
            return formula;
        }
        Environment<Expression> environment = this.repEnv;
        Quantifier quantifier = quantifiedFormula.quantifier();
        Decls decls = quantifiedFormula.decls();
        if (this.skolemDepth >= 0 && (this.negated && quantifier == Quantifier.ALL || !this.negated && quantifier == Quantifier.SOME)) {
            LinkedList<Formula> linkedList = new LinkedList<Formula>();
            LinkedList<Formula> linkedList2 = new LinkedList<Formula>();
            for (Decl decl : decls) {
                Decl decl2 = this.visit(decl);
                Relation relation = Relation.nary("$" + decl2.variable().name(), this.nonSkolems.size() + decl2.variable().arity());
                this.reporter.skolemizing(decl, relation, this.nonSkolemsView);
                Expression expression = this.skolemExpr(decl2, relation);
                Multiplicity multiplicity = decl.multiplicity();
                linkedList.add(this.source(expression.in(decl2.expression()), decl));
                if (multiplicity != Multiplicity.SET) {
                    linkedList.add(this.source(expression.apply(multiplicity), decl));
                }
                if (!this.nonSkolems.isEmpty()) {
                    linkedList2.add(this.source(this.domainConstraint(decl2, relation), decl));
                }
                this.repEnv = this.repEnv.extend(decl.variable(), expression);
            }
            formula = this.source(Formula.and(linkedList), decls).compose(this.negated ? FormulaOperator.IMPLIES : FormulaOperator.AND, quantifiedFormula.formula().accept(this));
            if (!linkedList2.isEmpty()) {
                this.topSkolemConstraints.add(this.source(Formula.and(linkedList2), decls));
            }
        } else {
            Decls decls2 = this.visit(quantifiedFormula.decls());
            if (this.skolemDepth >= this.nonSkolems.size() + decls2.size()) {
                for (Decl decl : decls2) {
                    this.nonSkolems.add(new DeclInfo(decl));
                }
                Formula formula2 = quantifiedFormula.formula().accept(this);
                formula = decls2 == decls && formula2 == quantifiedFormula.formula() ? quantifiedFormula : formula2.quantify(quantifier, decls2);
                for (int i = decls2.size(); i > 0; --i) {
                    this.nonSkolems.remove(this.nonSkolems.size() - 1);
                }
            } else {
                int n = this.skolemDepth;
                this.skolemDepth = -1;
                Formula formula3 = quantifiedFormula.formula().accept(this);
                formula = decls2 == decls && formula3 == quantifiedFormula.formula() ? quantifiedFormula : formula3.quantify(quantifier, decls2);
                this.skolemDepth = n;
            }
        }
        this.repEnv = environment;
        if (this.repEnv.isEmpty() && !this.topSkolemConstraints.isEmpty()) {
            formula = this.source(Formula.and(this.topSkolemConstraints), quantifiedFormula).compose(this.negated ? FormulaOperator.IMPLIES : FormulaOperator.AND, formula);
        }
        return this.source(this.cache(quantifiedFormula, formula), quantifiedFormula);
    }

    @Override
    public final Formula visit(NotFormula notFormula) {
        Formula formula = this.lookup(notFormula);
        if (formula != null) {
            return formula;
        }
        this.negated = !this.negated;
        Formula formula2 = notFormula.formula().accept(this);
        this.negated = !this.negated;
        return formula2 == notFormula.formula() ? (Formula)this.cache(notFormula, notFormula) : this.source(this.cache(notFormula, formula2.not()), notFormula);
    }

    @Override
    public final Formula visit(BinaryFormula binaryFormula) {
        Formula formula;
        Formula formula2;
        Formula formula3 = this.lookup(binaryFormula);
        if (formula3 != null) {
            return formula3;
        }
        FormulaOperator formulaOperator = binaryFormula.op();
        int n = this.skolemDepth;
        if (formulaOperator == FormulaOperator.IFF || this.negated && formulaOperator == FormulaOperator.AND || !this.negated && (formulaOperator == FormulaOperator.OR || formulaOperator == FormulaOperator.IMPLIES)) {
            this.skolemDepth = -1;
        }
        if (this.negated && formulaOperator == FormulaOperator.IMPLIES) {
            this.negated = !this.negated;
            formula2 = binaryFormula.left().accept(this);
            this.negated = !this.negated;
            formula = binaryFormula.right().accept(this);
        } else {
            formula2 = binaryFormula.left().accept(this);
            formula = binaryFormula.right().accept(this);
        }
        this.skolemDepth = n;
        formula3 = formula2 == binaryFormula.left() && formula == binaryFormula.right() ? binaryFormula : formula2.compose(formulaOperator, formula);
        return this.source(this.cache(binaryFormula, formula3), binaryFormula);
    }

    @Override
    public final Formula visit(NaryFormula naryFormula) {
        Formula formula = this.lookup(naryFormula);
        if (formula != null) {
            return formula;
        }
        int n = this.skolemDepth;
        FormulaOperator formulaOperator = naryFormula.op();
        switch (formulaOperator) {
            case AND: {
                if (!this.negated) break;
                this.skolemDepth = -1;
                break;
            }
            case OR: {
                if (this.negated) break;
                this.skolemDepth = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown nary operator: " + (Object)((Object)formulaOperator));
            }
        }
        Formula[] formulaArray = new Formula[naryFormula.size()];
        boolean bl = true;
        for (int i = 0; i < formulaArray.length; ++i) {
            Formula formula2 = naryFormula.child(i);
            formulaArray[i] = formula2.accept(this);
            bl = bl && formula2 == formulaArray[i];
        }
        formula = bl ? naryFormula : Formula.compose(formulaOperator, formulaArray);
        this.skolemDepth = n;
        return this.source(this.cache(naryFormula, formula), naryFormula);
    }

    @Override
    public final Formula visit(IntComparisonFormula intComparisonFormula) {
        int n = this.skolemDepth;
        this.skolemDepth = -1;
        Formula formula = super.visit(intComparisonFormula);
        this.skolemDepth = n;
        return this.source(formula, intComparisonFormula);
    }

    @Override
    public final Formula visit(ComparisonFormula comparisonFormula) {
        int n = this.skolemDepth;
        this.skolemDepth = -1;
        Formula formula = super.visit(comparisonFormula);
        this.skolemDepth = n;
        return this.source(formula, comparisonFormula);
    }

    @Override
    public final Formula visit(MultiplicityFormula multiplicityFormula) {
        int n = this.skolemDepth;
        this.skolemDepth = -1;
        Formula formula = super.visit(multiplicityFormula);
        this.skolemDepth = n;
        return this.source(formula, multiplicityFormula);
    }

    @Override
    public final Formula visit(RelationPredicate relationPredicate) {
        int n = this.skolemDepth;
        this.skolemDepth = -1;
        Formula formula = super.visit(relationPredicate);
        this.skolemDepth = n;
        return this.source(formula, relationPredicate);
    }

    private static final class DeclInfo {
        final Decl decl;
        BooleanMatrix upperBound;

        DeclInfo(Decl decl) {
            this.decl = decl;
            this.upperBound = null;
        }
    }
}

