/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Formula;
import kodkod.ast.Node;
import kodkod.ast.Variable;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.FreeVariableCollector;
import kodkod.engine.fol2sat.RecordFilter;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationLogger;
import kodkod.engine.fol2sat.TranslationRecord;
import kodkod.instance.Bounds;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.util.collections.Containers;
import kodkod.util.collections.FixedMap;
import kodkod.util.ints.Ints;
import kodkod.util.nodes.AnnotatedNode;
import kodkod.util.nodes.Nodes;

final class FileLogger
extends TranslationLogger {
    private final FixedMap<Formula, Variable[]> logMap;
    private final AnnotatedNode<Formula> annotated;
    private final File file;
    private DataOutputStream out;
    private final Bounds bounds;

    FileLogger(AnnotatedNode<Formula> annotatedNode, Bounds bounds) {
        this.annotated = annotatedNode;
        try {
            this.file = File.createTempFile("kodkod", ".log");
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Map<Formula, Set<Variable>> map = FileLogger.freeVars(annotatedNode);
        Variable[] variableArray = new Variable[]{};
        this.logMap = new FixedMap(map.keySet());
        int n = 0;
        for (Map.Entry<Formula, Variable[]> entry : this.logMap.entrySet()) {
            Set<Variable> set = map.get(entry.getKey());
            int n2 = set.size();
            if (n2 == 0) {
                entry.setValue(variableArray);
            } else {
                entry.setValue(Containers.identitySort(set.toArray(new Variable[n2])));
            }
            ++n;
        }
        this.bounds = bounds.unmodifiableView();
    }

    private static Map<Formula, Set<Variable>> freeVars(AnnotatedNode<Formula> annotatedNode) {
        final IdentityHashMap<Formula, Set<Variable>> identityHashMap = new IdentityHashMap<Formula, Set<Variable>>();
        FreeVariableCollector freeVariableCollector = new FreeVariableCollector((Set)annotatedNode.sharedNodes()){

            @Override
            protected Set<Variable> cache(Node node, Set<Variable> set) {
                if (node instanceof Formula) {
                    identityHashMap.put((Formula)node, set);
                }
                return super.cache(node, set);
            }

            @Override
            public Set<Variable> visit(ConstantFormula constantFormula) {
                return this.cache((Node)constantFormula, Collections.EMPTY_SET);
            }
        };
        annotatedNode.node().accept(freeVariableCollector);
        return identityHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.out = null;
        }
    }

    @Override
    void log(Formula formula, BooleanValue booleanValue, Environment<BooleanMatrix> environment) {
        if (this.out == null) {
            throw new IllegalStateException();
        }
        int n = this.logMap.indexOf(formula);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.logMap.get(n);
        try {
            this.out.writeInt(n);
            this.out.writeInt(booleanValue.label());
            for (Variable variable : variableArray) {
                this.out.writeInt(environment.lookup(variable).denseIndices().min());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    TranslationLog log() {
        return new FileLog(this.annotated, this.logMap, this.file, this.bounds);
    }

    protected final void finalize() {
        this.close();
    }

    private static final class MutableRecord
    extends TranslationRecord {
        Node node = null;
        Formula translated = null;
        int literal = 0;
        Map<Variable, TupleSet> env = null;

        private MutableRecord() {
        }

        @Override
        public Map<Variable, TupleSet> env() {
            return this.env;
        }

        @Override
        public int literal() {
            return this.literal;
        }

        @Override
        public Node node() {
            return this.node;
        }

        void setAll(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
            this.node = node;
            this.translated = formula;
            this.literal = n;
            this.env = map;
        }

        TranslationRecord setAll(MutableRecord mutableRecord) {
            this.setAll(mutableRecord.node, mutableRecord.translated, mutableRecord.literal, mutableRecord.env);
            mutableRecord.setAll(null, null, 0, null);
            return this;
        }

        @Override
        public Formula translated() {
            return this.translated;
        }
    }

    private static final class FileLog
    extends TranslationLog {
        private final Set<Formula> roots;
        private final Node[] original;
        private final Formula[] translated;
        private final Variable[][] freeVars;
        private final File file;
        private final Bounds bounds;

        FileLog(AnnotatedNode<Formula> annotatedNode, FixedMap<Formula, Variable[]> fixedMap, File file, Bounds bounds) {
            this.file = file;
            this.bounds = bounds;
            this.roots = Nodes.conjuncts(annotatedNode.node());
            int n = fixedMap.entrySet().size();
            this.original = new Node[n];
            this.translated = new Formula[n];
            this.freeVars = new Variable[n][];
            int n2 = 0;
            for (Map.Entry<Formula, Variable[]> entry : fixedMap.entrySet()) {
                this.translated[n2] = entry.getKey();
                this.original[n2] = annotatedNode.sourceOf(entry.getKey());
                this.freeVars[n2] = entry.getValue();
                ++n2;
            }
        }

        protected final void finalize() {
            this.file.delete();
        }

        @Override
        public Set<Formula> roots() {
            return this.roots;
        }

        @Override
        public Bounds bounds() {
            return this.bounds;
        }

        @Override
        public Iterator<TranslationRecord> replay(final RecordFilter recordFilter) {
            try {
                return new Iterator<TranslationRecord>(){
                    final TupleFactory factory;
                    final DataInputStream in;
                    final MutableRecord current;
                    final MutableRecord next;
                    long remaining;
                    {
                        this.factory = FileLog.this.bounds.universe().factory();
                        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(FileLog.this.file)));
                        this.current = new MutableRecord();
                        this.next = new MutableRecord();
                        this.remaining = FileLog.this.file.length();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.remaining > 0L && this.next.node == null) {
                            try {
                                Map<Variable, TupleSet> map;
                                long l = this.in.readLong();
                                int n = (int)l;
                                int n2 = (int)(l >>> 32);
                                Variable[] variableArray = FileLog.this.freeVars[n2];
                                if (variableArray.length == 0) {
                                    map = Collections.emptyMap();
                                } else {
                                    map = new FixedMap(variableArray);
                                    for (int i = 0; i < variableArray.length; ++i) {
                                        map.put(variableArray[i], this.factory.setOf(1, Ints.singleton(this.in.readInt())));
                                    }
                                }
                                if (recordFilter.accept(FileLog.this.original[n2], FileLog.this.translated[n2], n, map)) {
                                    this.next.setAll(FileLog.this.original[n2], FileLog.this.translated[n2], n, map);
                                }
                                this.remaining -= (long)(8 + (variableArray.length << 2));
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                        if (this.next.node == null) {
                            try {
                                this.in.close();
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public TranslationRecord next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.current.setAll(this.next);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    protected final void finalize() {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
    }
}

