/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.BooleanVariable;
import kodkod.engine.bool.BooleanVisitor;
import kodkod.engine.bool.ITEGate;
import kodkod.engine.bool.MultiGate;
import kodkod.engine.bool.NotGate;
import kodkod.engine.bool.Operator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

final class BooleanFormulaFlattener
implements BooleanVisitor<BooleanValue, BooleanAccumulator> {
    private final BooleanFactory factory;
    private final IntSet flattenable;
    private final Map<MultiGate, BooleanValue> cache;

    static final BooleanValue flatten(BooleanFormula booleanFormula, BooleanFactory booleanFactory) {
        int n = booleanFactory.comparisonDepth();
        booleanFactory.setComparisonDepth(1);
        booleanFactory.clear();
        BooleanFormulaFlattener booleanFormulaFlattener = new BooleanFormulaFlattener(booleanFormula, booleanFactory);
        BooleanValue booleanValue = booleanFormula.accept(booleanFormulaFlattener, null);
        booleanFactory.setComparisonDepth(n);
        return booleanValue;
    }

    private BooleanFormulaFlattener(BooleanFormula booleanFormula, BooleanFactory booleanFactory) {
        this.factory = booleanFactory;
        FlatteningDataGatherer flatteningDataGatherer = new FlatteningDataGatherer(booleanFormula);
        booleanFormula.accept(flatteningDataGatherer, null);
        this.flattenable = flatteningDataGatherer.flattenable;
        flatteningDataGatherer.visited.removeAll(this.flattenable);
        this.cache = new IdentityHashMap<MultiGate, BooleanValue>(flatteningDataGatherer.visited.size());
    }

    private final BooleanValue addToParent(BooleanValue booleanValue, BooleanAccumulator booleanAccumulator) {
        return booleanAccumulator == null ? booleanValue : booleanAccumulator.add(booleanValue);
    }

    @Override
    public BooleanValue visit(MultiGate multiGate, BooleanAccumulator booleanAccumulator) {
        Operator.Nary nary = multiGate.op();
        if (this.flattenable.contains(multiGate.label())) {
            Iterator<BooleanFormula> iterator = multiGate.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().accept(this, booleanAccumulator) != nary.shortCircuit()) continue;
                return nary.shortCircuit();
            }
            return booleanAccumulator;
        }
        BooleanValue booleanValue = this.cache.get(multiGate);
        if (booleanValue == null) {
            BooleanAccumulator booleanAccumulator2 = BooleanAccumulator.treeGate(nary);
            Iterator<BooleanFormula> iterator = multiGate.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().accept(this, booleanAccumulator2) != nary.shortCircuit()) continue;
                return nary.shortCircuit();
            }
            booleanValue = this.factory.accumulate(booleanAccumulator2);
            this.cache.put(multiGate, booleanValue);
        }
        return this.addToParent(booleanValue, booleanAccumulator);
    }

    @Override
    public BooleanValue visit(ITEGate iTEGate, BooleanAccumulator booleanAccumulator) {
        return this.addToParent(this.factory.ite(iTEGate.input(0).accept(this, null), iTEGate.input(1).accept(this, null), iTEGate.input(2).accept(this, null)), booleanAccumulator);
    }

    @Override
    public BooleanValue visit(NotGate notGate, BooleanAccumulator booleanAccumulator) {
        return this.addToParent(this.factory.not(notGate.input(0).accept(this, null)), booleanAccumulator);
    }

    @Override
    public BooleanValue visit(BooleanVariable booleanVariable, BooleanAccumulator booleanAccumulator) {
        return this.addToParent(booleanVariable, booleanAccumulator);
    }

    private static final class FlatteningDataGatherer
    implements BooleanVisitor<Object, Operator> {
        final IntSet flattenable;
        final IntSet visited;

        private FlatteningDataGatherer(BooleanFormula booleanFormula) {
            int n = StrictMath.abs(booleanFormula.label());
            this.flattenable = Ints.bestSet(n + 1);
            this.visited = Ints.bestSet(n + 1);
        }

        @Override
        public Object visit(MultiGate multiGate, Operator operator) {
            int n = multiGate.label();
            if (this.visited.contains(n)) {
                this.flattenable.remove(n);
            } else {
                this.visited.add(n);
                if (operator == multiGate.op()) {
                    this.flattenable.add(n);
                }
                Iterator<BooleanFormula> iterator = multiGate.iterator();
                while (iterator.hasNext()) {
                    iterator.next().accept(this, multiGate.op());
                }
            }
            return null;
        }

        @Override
        public Object visit(ITEGate iTEGate, Operator operator) {
            if (this.visited.add(iTEGate.label())) {
                iTEGate.input(0).accept(this, null);
                iTEGate.input(1).accept(this, null);
                iTEGate.input(2).accept(this, null);
            }
            return null;
        }

        @Override
        public Object visit(NotGate notGate, Operator operator) {
            notGate.input(0).accept(this, null);
            return null;
        }

        @Override
        public Object visit(BooleanVariable booleanVariable, Operator operator) {
            return null;
        }
    }
}

