/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanVisitor;
import kodkod.engine.bool.Operator;
import kodkod.util.ints.Ints;

public abstract class MultiGate
extends BooleanFormula {
    final Operator.Nary op;
    private final int label;
    private final int labelhash;
    private final int hashcode;

    MultiGate(Operator.Nary nary, int n, int n2) {
        super(null);
        assert (nary != null);
        assert (n >= 0);
        this.op = nary;
        this.label = n;
        this.labelhash = Ints.superFastHash(n);
        this.hashcode = n2;
    }

    @Override
    public final int label() {
        return this.label;
    }

    @Override
    public final Operator.Nary op() {
        return this.op;
    }

    @Override
    public <T, A> T accept(BooleanVisitor<T, A> booleanVisitor, A a) {
        return booleanVisitor.visit(this, a);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        Iterator<BooleanFormula> iterator = this.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(this.op);
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return this.hashcode;
    }

    @Override
    final int hash(Operator operator) {
        return operator == this.op ? this.hashcode : this.labelhash;
    }
}

