/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.visitor.ReturnVisitor;

public abstract class AbstractDetector
implements ReturnVisitor<Boolean, Boolean, Boolean, Boolean> {
    protected final Map<Node, Boolean> cache;
    protected final Set<Node> cached;

    protected AbstractDetector(Set<Node> set) {
        this.cached = set;
        this.cache = new IdentityHashMap<Node, Boolean>(set.size());
    }

    protected AbstractDetector(Set<Node> set, Map<Node, Boolean> map) {
        this.cached = set;
        this.cache = map;
    }

    protected Boolean lookup(Node node) {
        return this.cache.get(node);
    }

    protected Boolean cache(Node node, boolean bl) {
        Boolean bl2 = bl;
        if (this.cached.contains(node)) {
            this.cache.put(node, bl2);
        }
        return bl2;
    }

    @Override
    public Boolean visit(Decls decls) {
        Boolean bl = this.lookup(decls);
        if (bl != null) {
            return bl;
        }
        for (Decl decl : decls) {
            if (!this.visit(decl).booleanValue()) continue;
            return this.cache(decls, true);
        }
        return this.cache(decls, false);
    }

    @Override
    public Boolean visit(Decl decl) {
        Boolean bl = this.lookup(decl);
        return bl != null ? bl : this.cache(decl, decl.variable().accept(this) != false || decl.expression().accept(this) != false);
    }

    @Override
    public Boolean visit(Relation relation) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(Variable variable) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ConstantExpression constantExpression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(NaryExpression naryExpression) {
        Boolean bl = this.lookup(naryExpression);
        if (bl != null) {
            return bl;
        }
        for (Expression expression : naryExpression) {
            if (!expression.accept(this).booleanValue()) continue;
            return this.cache(naryExpression, true);
        }
        return this.cache(naryExpression, false);
    }

    @Override
    public Boolean visit(BinaryExpression binaryExpression) {
        Boolean bl = this.lookup(binaryExpression);
        return bl != null ? bl : this.cache(binaryExpression, binaryExpression.left().accept(this) != false || binaryExpression.right().accept(this) != false);
    }

    @Override
    public Boolean visit(UnaryExpression unaryExpression) {
        Boolean bl = this.lookup(unaryExpression);
        return bl != null ? bl : this.cache(unaryExpression, unaryExpression.expression().accept(this));
    }

    @Override
    public Boolean visit(Comprehension comprehension) {
        Boolean bl = this.lookup(comprehension);
        return bl != null ? bl : this.cache(comprehension, comprehension.decls().accept(this) != false || comprehension.formula().accept(this) != false);
    }

    @Override
    public Boolean visit(IfExpression ifExpression) {
        Boolean bl = this.lookup(ifExpression);
        return bl != null ? bl : this.cache(ifExpression, ifExpression.condition().accept(this) != false || ifExpression.thenExpr().accept(this) != false || ifExpression.elseExpr().accept(this) != false);
    }

    @Override
    public Boolean visit(ProjectExpression projectExpression) {
        Boolean bl = this.lookup(projectExpression);
        if (bl != null) {
            return bl;
        }
        if (projectExpression.expression().accept(this).booleanValue()) {
            return this.cache(projectExpression, true);
        }
        int n = projectExpression.arity();
        for (int i = 0; i < n; ++i) {
            if (!projectExpression.column(i).accept(this).booleanValue()) continue;
            return this.cache(projectExpression, true);
        }
        return this.cache(projectExpression, false);
    }

    @Override
    public Boolean visit(IntToExprCast intToExprCast) {
        Boolean bl = this.lookup(intToExprCast);
        return bl != null ? bl : this.cache(intToExprCast, intToExprCast.intExpr().accept(this));
    }

    @Override
    public Boolean visit(IntConstant intConstant) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(IfIntExpression ifIntExpression) {
        Boolean bl = this.lookup(ifIntExpression);
        return bl != null ? bl : this.cache(ifIntExpression, ifIntExpression.condition().accept(this) != false || ifIntExpression.thenExpr().accept(this) != false || ifIntExpression.elseExpr().accept(this) != false);
    }

    @Override
    public Boolean visit(ExprToIntCast exprToIntCast) {
        Boolean bl = this.lookup(exprToIntCast);
        return bl != null ? bl : this.cache(exprToIntCast, exprToIntCast.expression().accept(this));
    }

    @Override
    public Boolean visit(NaryIntExpression naryIntExpression) {
        Boolean bl = this.lookup(naryIntExpression);
        if (bl != null) {
            return bl;
        }
        for (IntExpression intExpression : naryIntExpression) {
            if (!intExpression.accept(this).booleanValue()) continue;
            return this.cache(naryIntExpression, true);
        }
        return this.cache(naryIntExpression, false);
    }

    @Override
    public Boolean visit(BinaryIntExpression binaryIntExpression) {
        Boolean bl = this.lookup(binaryIntExpression);
        return bl != null ? bl : this.cache(binaryIntExpression, binaryIntExpression.left().accept(this) != false || binaryIntExpression.right().accept(this) != false);
    }

    @Override
    public Boolean visit(UnaryIntExpression unaryIntExpression) {
        Boolean bl = this.lookup(unaryIntExpression);
        return bl != null ? bl : this.cache(unaryIntExpression, unaryIntExpression.intExpr().accept(this));
    }

    @Override
    public Boolean visit(SumExpression sumExpression) {
        Boolean bl = this.lookup(sumExpression);
        return bl != null ? bl : this.cache(sumExpression, sumExpression.decls().accept(this) != false || sumExpression.intExpr().accept(this) != false);
    }

    @Override
    public Boolean visit(IntComparisonFormula intComparisonFormula) {
        Boolean bl = this.lookup(intComparisonFormula);
        return bl != null ? bl : this.cache(intComparisonFormula, intComparisonFormula.left().accept(this) != false || intComparisonFormula.right().accept(this) != false);
    }

    @Override
    public Boolean visit(QuantifiedFormula quantifiedFormula) {
        Boolean bl = this.lookup(quantifiedFormula);
        return bl != null ? bl : this.cache(quantifiedFormula, quantifiedFormula.decls().accept(this) != false || quantifiedFormula.formula().accept(this) != false);
    }

    @Override
    public Boolean visit(NaryFormula naryFormula) {
        Boolean bl = this.lookup(naryFormula);
        if (bl != null) {
            return bl;
        }
        for (Formula formula : naryFormula) {
            if (!formula.accept(this).booleanValue()) continue;
            return this.cache(naryFormula, true);
        }
        return this.cache(naryFormula, false);
    }

    @Override
    public Boolean visit(BinaryFormula binaryFormula) {
        Boolean bl = this.lookup(binaryFormula);
        return bl != null ? bl : this.cache(binaryFormula, binaryFormula.left().accept(this) != false || binaryFormula.right().accept(this) != false);
    }

    @Override
    public Boolean visit(NotFormula notFormula) {
        Boolean bl = this.lookup(notFormula);
        return bl != null ? bl : this.cache(notFormula, notFormula.formula().accept(this));
    }

    @Override
    public Boolean visit(ConstantFormula constantFormula) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ComparisonFormula comparisonFormula) {
        Boolean bl = this.lookup(comparisonFormula);
        return bl != null ? bl : this.cache(comparisonFormula, comparisonFormula.left().accept(this) != false || comparisonFormula.right().accept(this) != false);
    }

    @Override
    public Boolean visit(MultiplicityFormula multiplicityFormula) {
        Boolean bl = this.lookup(multiplicityFormula);
        return bl != null ? bl : this.cache(multiplicityFormula, multiplicityFormula.expression().accept(this));
    }

    @Override
    public Boolean visit(RelationPredicate relationPredicate) {
        Boolean bl = this.lookup(relationPredicate);
        if (bl != null) {
            return bl;
        }
        if (relationPredicate.relation().accept(this).booleanValue()) {
            return this.cache(relationPredicate, true);
        }
        if (relationPredicate.name() == RelationPredicate.Name.FUNCTION) {
            RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
            return this.cache(relationPredicate, function.domain().accept(this) != false || function.range().accept(this) != false);
        }
        if (relationPredicate.name() == RelationPredicate.Name.TOTAL_ORDERING) {
            RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
            return this.cache(relationPredicate, totalOrdering.ordered().accept(this) != false || totalOrdering.first().accept(this) != false || totalOrdering.last().accept(this) != false);
        }
        return this.cache(relationPredicate, false);
    }
}

